/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.data.recipes;

import com.benbenlaw.casting.recipe.EquipmentModifierRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EquipmentModifierRecipeBuilder
implements RecipeBuilder {
    protected String group;
    protected SizedIngredient upgradeItem;
    protected FluidStack upgradeFluid;
    protected String effect;
    protected final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public EquipmentModifierRecipeBuilder(SizedIngredient upgradeItem, FluidStack upgradeFluid, String effect) {
        this.upgradeItem = upgradeItem != null ? upgradeItem : SizedIngredient.of((ItemLike)ItemStack.EMPTY.getItem(), (int)1);
        this.upgradeFluid = upgradeFluid != null ? upgradeFluid : FluidStack.EMPTY;
        this.effect = effect;
    }

    public static EquipmentModifierRecipeBuilder ToolModifierRecipesBuilder(SizedIngredient upgradeItem, FluidStack upgradeFluid, String effect) {
        return new EquipmentModifierRecipeBuilder(upgradeItem, upgradeFluid, effect);
    }

    @NotNull
    public RecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    @NotNull
    public RecipeBuilder group(@Nullable String groupName) {
        this.group = groupName;
        return this;
    }

    public Item getResult() {
        return ItemStack.EMPTY.getItem();
    }

    public void save(@NotNull RecipeOutput recipeOutput) {
        this.save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"casting", (String)"tool_modifier/"));
    }

    public void save(@NotNull RecipeOutput recipeOutput, @NotNull ResourceLocation id) {
        Advancement.Builder builder = Advancement.Builder.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
        EquipmentModifierRecipe solidifierRecipe = new EquipmentModifierRecipe(this.upgradeItem, this.upgradeFluid, this.effect);
        recipeOutput.accept(id, (Recipe)solidifierRecipe, builder.build(id.withPrefix("recipes/tool_modifier/")));
    }
}

