/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.data;

import com.benbenlaw.casting.block.CastingBlocks;
import com.benbenlaw.casting.data.recipes.CoolantRecipeBuilder;
import com.benbenlaw.casting.data.recipes.EquipmentModifierRecipeBuilder;
import com.benbenlaw.casting.data.recipes.FluidStackHelper;
import com.benbenlaw.casting.data.recipes.FuelRecipeBuilder;
import com.benbenlaw.casting.data.recipes.MeltingRecipeBuilder;
import com.benbenlaw.casting.data.recipes.MixingRecipeBuilder;
import com.benbenlaw.casting.data.recipes.SolidifierRecipeBuilder;
import com.benbenlaw.casting.fluid.CastingFluids;
import com.benbenlaw.casting.fluid.FluidData;
import com.benbenlaw.casting.item.CastingItems;
import com.benbenlaw.casting.item.EquipmentModifier;
import com.benbenlaw.casting.util.CastingTags;
import com.benbenlaw.casting.util.MaterialMelting;
import com.benbenlaw.core.tag.CommonTags;
import com.benbenlaw.core.tag.ModdedTagBuilder;
import com.benbenlaw.core.tag.ResourceNames;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ItemExistsCondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;

public class CastingRecipeProvider
extends RecipeProvider {
    public CastingRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> completableFuture) {
        super(output, completableFuture);
    }

    protected void buildRecipes(RecipeOutput consumer) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.BRICK}), (RecipeCategory)RecipeCategory.MISC, (ItemStack)new ItemStack((ItemLike)CastingItems.BLACK_BRICK.get()), (float)0.5f, (int)200).unlockedBy("has_brick", CastingRecipeProvider.has((ItemLike)Items.BRICK)).save(consumer, "casting:smelting/black_brick");
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.BRICKS}), (RecipeCategory)RecipeCategory.MISC, (ItemStack)new ItemStack((ItemLike)CastingBlocks.BLACK_BRICKS.get()), (float)0.5f, (int)200).unlockedBy("has_brick", CastingRecipeProvider.has((ItemLike)Items.BRICK)).save(consumer, "casting:smelting/black_bricks");
        this.createSimpleSolidifierRecipe(FluidStackHelper.getFluidStack("molten_black_brick", 4000), CastingBlocks.CONTROLLER.toStack(), (ItemLike)CastingBlocks.MULTIBLOCK_CONTROLLER, "multiblock/controller", consumer);
        this.createSimpleSolidifierRecipe(FluidStackHelper.getFluidStack("molten_black_brick", 4000), CastingBlocks.TANK.toStack(), (ItemLike)CastingBlocks.MULTIBLOCK_FUEL_TANK, "multiblock/fuel_tank", consumer);
        this.createSimpleSolidifierRecipe(FluidStackHelper.getFluidStack("molten_black_brick", 4000), CastingBlocks.SOLIDIFIER.toStack(), (ItemLike)CastingBlocks.MULTIBLOCK_SOLIDIFIER, "multiblock/solidifier", consumer);
        this.createSimpleSolidifierRecipe(FluidStackHelper.getFluidStack("molten_black_brick", 4000), CastingBlocks.MIXER.toStack(), (ItemLike)CastingBlocks.MULTIBLOCK_MIXER, "multiblock/mixer", consumer);
        this.createSimpleSolidifierRecipe(FluidStackHelper.getFluidStack("molten_black_brick", 4000), CastingBlocks.MULTIBLOCK_FUEL_TANK.toStack(), (ItemLike)CastingBlocks.MULTIBLOCK_VALVE, "multiblock/valve", consumer);
        this.createSimpleSolidifierRecipe(FluidStackHelper.getFluidStack("molten_black_brick", 4000), Items.GLASS.getDefaultInstance(), (ItemLike)CastingBlocks.MULTIBLOCK_COOLANT_TANK, "multiblock/coolant_tank", consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CastingBlocks.BLACK_BRICKS.get()), (int)1).pattern("AA").pattern("AA").define(Character.valueOf('A'), CastingItems.BLACK_BRICK).unlockedBy("has_brick", CastingRecipeProvider.has(CastingItems.BLACK_BRICK)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CastingBlocks.BLACK_BRICK_GLASS.get()), (int)1).pattern(" A ").pattern("ABA").pattern(" A ").define(Character.valueOf('A'), CastingItems.BLACK_BRICK).define(Character.valueOf('B'), Tags.Items.GLASS_BLOCKS).unlockedBy("has_brick", CastingRecipeProvider.has(CastingItems.BLACK_BRICK)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CastingBlocks.MULTIBLOCK_REGULATOR.get()), (int)1).pattern(" A ").pattern("ABA").pattern(" A ").define(Character.valueOf('A'), CastingItems.BLACK_BRICK).define(Character.valueOf('B'), CastingBlocks.BLACK_BRICKS).unlockedBy("has_brick", CastingRecipeProvider.has(CastingItems.BLACK_BRICK)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CastingItems.FLUID_MOVER.get()), (int)1).pattern(" BB").pattern(" BB").pattern("B  ").define(Character.valueOf('B'), (ItemLike)CastingItems.BLACK_BRICK.get()).unlockedBy("has_black_brick", CastingRecipeProvider.has((ItemLike)((ItemLike)CastingItems.BLACK_BRICK.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CastingBlocks.TANK.get()), (int)1).pattern("BBB").pattern("BGB").pattern("BBB").define(Character.valueOf('B'), (ItemLike)CastingItems.BLACK_BRICK.get()).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).unlockedBy("has_black_brick", CastingRecipeProvider.has((ItemLike)((ItemLike)CastingBlocks.BLACK_BRICKS.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CastingBlocks.CONTROLLER.get()), (int)1).pattern("ABA").pattern("B B").pattern("ABA").define(Character.valueOf('A'), (ItemLike)CastingItems.BLACK_BRICK.get()).define(Character.valueOf('B'), (ItemLike)CastingBlocks.BLACK_BRICKS.get()).unlockedBy("has_black_brick", CastingRecipeProvider.has((ItemLike)((ItemLike)CastingBlocks.BLACK_BRICKS.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CastingBlocks.SOLIDIFIER.get()), (int)1).pattern("BBB").pattern("A A").pattern("BBB").define(Character.valueOf('A'), (ItemLike)CastingItems.BLACK_BRICK.get()).define(Character.valueOf('B'), (ItemLike)CastingBlocks.BLACK_BRICKS.get()).unlockedBy("has_black_brick", CastingRecipeProvider.has((ItemLike)((ItemLike)CastingBlocks.BLACK_BRICKS.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CastingBlocks.MIXER.get()), (int)1).pattern("BBB").pattern("A A").pattern("BBB").define(Character.valueOf('B'), (ItemLike)CastingBlocks.BLACK_BRICKS.get()).define(Character.valueOf('A'), CastingBlocks.TANK).unlockedBy("has_black_brick", CastingRecipeProvider.has((ItemLike)((ItemLike)CastingBlocks.BLACK_BRICKS.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CastingBlocks.MIXER_WHISK.get()), (int)1).pattern("BIB").pattern("BSB").pattern("BIB").define(Character.valueOf('B'), (ItemLike)CastingBlocks.BLACK_BRICKS.get()).define(Character.valueOf('S'), Tags.Items.STORAGE_BLOCKS_IRON).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).unlockedBy("has_black_brick", CastingRecipeProvider.has((ItemLike)((ItemLike)CastingBlocks.BLACK_BRICKS.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CastingBlocks.EQUIPMENT_MODIFIER.get()), (int)1).pattern("BBB").pattern("STS").pattern("BBB").define(Character.valueOf('B'), (ItemLike)CastingBlocks.BLACK_BRICKS.get()).define(Character.valueOf('S'), (ItemLike)CastingBlocks.SOLIDIFIER.get()).define(Character.valueOf('T'), Tags.Items.PLAYER_WORKSTATIONS_CRAFTING_TABLES).unlockedBy("has_black_brick", CastingRecipeProvider.has((ItemLike)((ItemLike)CastingBlocks.BLACK_BRICKS.get()))).save(consumer);
        this.toolModifierRecipes(consumer, null, FluidStackHelper.getFluidStack("molten_lapis", 1350), EquipmentModifier.FORTUNE.id);
        this.toolModifierRecipes(consumer, null, FluidStackHelper.getFluidStack("molten_redstone", 1350), EquipmentModifier.EFFICIENCY.id);
        this.toolModifierRecipes(consumer, null, FluidStackHelper.getFluidStack("molten_emerald", 720), EquipmentModifier.SILK_TOUCH.id);
        this.toolModifierRecipes(consumer, null, FluidStackHelper.getFluidStack("molten_obsidian", 8000), EquipmentModifier.UNBREAKING.id);
        this.toolModifierRecipes(consumer, null, FluidStackHelper.getFluidStack("molten_glowstone", 8000), EquipmentModifier.REPAIRING.id);
        this.toolModifierRecipes(consumer, new SizedIngredient(Ingredient.of((TagKey)Tags.Items.RODS_WOODEN), 64), FluidStackHelper.getFluidStack("molten_coal", 5120), EquipmentModifier.TORCH_PLACING.id);
        this.toolModifierRecipes(consumer, null, new FluidStack((Fluid)Fluids.LAVA, 8000), EquipmentModifier.AUTO_SMELT.id);
        this.toolModifierRecipes(consumer, new SizedIngredient(Ingredient.of((TagKey)Tags.Items.GEMS_EMERALD), 8), FluidStackHelper.getFluidStack("molten_lapis", 1350), EquipmentModifier.LOOTING.id);
        this.toolModifierRecipes(consumer, null, FluidStackHelper.getFluidStack("molten_quartz", 1350), EquipmentModifier.SHARPNESS.id);
        this.toolModifierRecipes(consumer, new SizedIngredient(Ingredient.of((TagKey)ItemTags.SKULLS), 1), null, EquipmentModifier.BEHEADING.id);
        this.toolModifierRecipes(consumer, null, FluidStackHelper.getFluidStack("molten_soul", 3200), EquipmentModifier.SOULBOUND.id);
        this.toolModifierRecipes(consumer, new SizedIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_APPLE}), 1), FluidStackHelper.getFluidStack("molten_gold", 720), EquipmentModifier.LIFESTEAL.id);
        this.toolModifierRecipes(consumer, new SizedIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.PISTON}), 4), null, EquipmentModifier.KNOCKBACK.id);
        this.toolModifierRecipes(consumer, new SizedIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.FLINT_AND_STEEL}), 1), new FluidStack((Fluid)Fluids.LAVA, 8000), EquipmentModifier.IGNITE.id);
        this.toolModifierRecipes(consumer, null, FluidStackHelper.getFluidStack("molten_diamond", 360), EquipmentModifier.EXCAVATION.id);
        this.toolModifierRecipes(consumer, null, FluidStackHelper.getFluidStack("molten_ender", 640), EquipmentModifier.TELEPORTING.id);
        this.toolModifierRecipes(consumer, new SizedIngredient(Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), 6), FluidStackHelper.getFluidStack("molten_gold", 540), EquipmentModifier.MAGNET.id);
        this.toolModifierRecipes(consumer, null, FluidStackHelper.getFluidStack("molten_steel", 720), EquipmentModifier.PROTECTION.id);
        this.toolModifierRecipes(consumer, new SizedIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.STICKY_PISTON}), 4), null, EquipmentModifier.STEP_ASSIST.id);
        this.toolModifierRecipes(consumer, new SizedIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_CARROT}), 8), null, EquipmentModifier.NIGHT_VISION.id);
        this.toolModifierRecipes(consumer, new SizedIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.PUFFERFISH}), 2), null, EquipmentModifier.WATER_BREATHING.id);
        this.toolModifierRecipes(consumer, new SizedIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR}), 12), null, EquipmentModifier.SPEED.id);
        this.toolModifierRecipes(consumer, new SizedIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.MAGMA_BLOCK}), 8), null, EquipmentModifier.LAVA_WALKER.id);
        this.toolModifierRecipes(consumer, new SizedIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SPONGE}), 8), null, EquipmentModifier.WATER_WALKER.id);
        this.toolModifierRecipes(consumer, new SizedIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_STAR}), 1), null, EquipmentModifier.FLIGHT.id);
        this.toolModifierRecipes(consumer, new SizedIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.FEATHER}), 4), null, EquipmentModifier.FEATHER_FALLING.id);
        this.toolModifierRecipes(consumer, null, FluidStackHelper.getFluidStack("molten_experience", 500), EquipmentModifier.EQUIPMENT_LEVEL.id);
        this.toolModifierRecipes(consumer, null, FluidStackHelper.getFluidStack("molten_blaze", 720), EquipmentModifier.JETS.id);
        this.createMoldRecipe((ItemLike)CastingItems.GEAR_MOLD.get(), (TagKey<Item>)ModdedTagBuilder.createNeoFabricItemTag((String)"gears"), consumer);
        this.createMoldRecipe((ItemLike)CastingItems.PLATE_MOLD.get(), (TagKey<Item>)ModdedTagBuilder.createNeoFabricItemTag((String)"plates"), consumer);
        this.createMoldRecipe((ItemLike)CastingItems.ROD_MOLD.get(), (TagKey<Item>)ModdedTagBuilder.createNeoFabricItemTag((String)"rods"), consumer);
        this.createMoldRecipe((ItemLike)CastingItems.NUGGET_MOLD.get(), (TagKey<Item>)ModdedTagBuilder.createNeoFabricItemTag((String)"nuggets"), consumer);
        this.createMoldRecipe((ItemLike)CastingItems.INGOT_MOLD.get(), (TagKey<Item>)ModdedTagBuilder.createNeoFabricItemTag((String)"ingots"), consumer);
        this.createMoldRecipeWithID((ItemLike)CastingItems.INGOT_MOLD.get(), (TagKey<Item>)Tags.Items.BRICKS, consumer, "ingot_mold_bricks");
        this.createMoldRecipe((ItemLike)CastingItems.BLOCK_MOLD.get(), (TagKey<Item>)ModdedTagBuilder.createNeoFabricItemTag((String)"storage_blocks"), consumer);
        this.createMoldRecipe((ItemLike)CastingItems.GEM_MOLD.get(), (TagKey<Item>)ModdedTagBuilder.createNeoFabricItemTag((String)"gems"), consumer);
        this.createMoldRecipeWithID((ItemLike)CastingItems.GEM_MOLD.get(), (TagKey<Item>)ItemTags.COALS, consumer, "gem_mold_coals");
        this.createMoldRecipe((ItemLike)CastingItems.DUST_MOLD.get(), (TagKey<Item>)ModdedTagBuilder.createNeoFabricItemTag((String)"dusts"), consumer);
        this.createMoldRecipe((ItemLike)CastingItems.BALL_MOLD.get(), CastingTags.Items.BALL_ITEMS, consumer);
        this.createMoldRecipe((ItemLike)CastingItems.WIRE_MOLD.get(), (TagKey<Item>)ModdedTagBuilder.createNeoFabricItemTag((String)"wires"), consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)CastingItems.REPAIRING_MOLD.get()), (int)1).pattern(" A ").pattern("ABA").pattern(" A ").define(Character.valueOf('A'), CastingItems.BLACK_BRICK).define(Character.valueOf('B'), (ItemLike)Items.ANVIL).unlockedBy("has_item", CastingRecipeProvider.has((ItemLike)Items.ANVIL)).save(consumer);
        FuelRecipeBuilder.fuelRecipesBuilder(new FluidStack((Fluid)Fluids.LAVA, 10), 1000, 300).unlockedBy("has_item", CastingRecipeProvider.has((ItemLike)Items.BUCKET)).save(consumer);
        FuelRecipeBuilder.fuelRecipesBuilder(FluidStackHelper.getFluidStack("molten_coal", 8), 1200, 260).unlockedBy("has_item", CastingRecipeProvider.has((ItemLike)Items.BUCKET)).save(consumer);
        FuelRecipeBuilder.fuelRecipesBuilder(FluidStackHelper.getFluidStack("molten_obsidian", 8), 1200, 200).unlockedBy("has_item", CastingRecipeProvider.has((ItemLike)Items.BUCKET)).save(consumer);
        FuelRecipeBuilder.fuelRecipesBuilder(FluidStackHelper.getFluidStack("molten_uranium", 20), 1400, 100).unlockedBy("has_item", CastingRecipeProvider.has((ItemLike)Items.BUCKET)).save(consumer);
        FuelRecipeBuilder.fuelRecipesBuilder(FluidStackHelper.getFluidStack("molten_blaze", 1), 1400, 60).unlockedBy("has_item", CastingRecipeProvider.has((ItemLike)Items.BLAZE_POWDER)).save(consumer);
        CoolantRecipeBuilder.coolantRecipesBuilder(new FluidStack((Fluid)Fluids.WATER, 10), 160).unlockedBy("has_item", CastingRecipeProvider.has((ItemLike)Items.BUCKET)).save(consumer);
        CoolantRecipeBuilder.coolantRecipesBuilder(FluidStackHelper.getFluidStack("molten_ender", 5), 100).unlockedBy("has_item", CastingRecipeProvider.has((ItemLike)Items.BUCKET)).save(consumer);
        CoolantRecipeBuilder.coolantRecipesBuilder(FluidStackHelper.getFluidStack("molten_glowstone", 10), 140).unlockedBy("has_item", CastingRecipeProvider.has((ItemLike)Items.BUCKET)).save(consumer);
        CoolantRecipeBuilder.coolantRecipesBuilder(FluidStackHelper.getFluidStack("molten_diamond", 20), 80).unlockedBy("has_item", CastingRecipeProvider.has((ItemLike)Items.BUCKET)).save(consumer);
        CoolantRecipeBuilder.coolantRecipesBuilder(FluidStackHelper.getFluidStack("chilled_water", 25), 60).unlockedBy("has_item", CastingRecipeProvider.has((ItemLike)Items.BUCKET)).save(consumer);
        CoolantRecipeBuilder.coolantRecipesBuilder(FluidStackHelper.getFluidStack("iced_water", 25), 40).unlockedBy("has_item", CastingRecipeProvider.has((ItemLike)Items.BUCKET)).save(consumer);
        CoolantRecipeBuilder.coolantRecipesBuilder(FluidStackHelper.getFluidStack("super_coolant", 10), 20).unlockedBy("has_item", CastingRecipeProvider.has((ItemLike)Items.BUCKET)).save(consumer);
        for (String resource : ResourceNames.getAllResourceNames()) {
            if (resource.equals("coal") || resource.equals("quartz")) continue;
            this.createCommonMeltingRecipes(resource, consumer);
            this.createCommonSolidifierRecipes(resource, consumer);
        }
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_quartz_enriched_iron", 90), (TagKey<Item>)ModdedTagBuilder.createNeoFabricItemTag((String)"ingots/quartz_enriched_iron"), FluidData.getTempByName("molten_quartz_enriched_iron"), "quartz_enriched_iron/from_ingot", consumer);
        this.createSimpleSolidifierRecipe(FluidStackHelper.getFluidStack("molten_quartz_enriched_iron", 90), CastingTags.Items.INGOT_MOLD, (TagKey<Item>)ModdedTagBuilder.createNeoFabricItemTag((String)"ingots/quartz_enriched_iron"), "quartz_enriched_iron/ingot", consumer);
        this.createSimpleMixingRecipe(FluidStackHelper.fluidList(FluidStackHelper.getFluidStack("molten_iron", 270), FluidStackHelper.getFluidStack("molten_quartz", 250)), FluidStackHelper.getFluidStack("molten_quartz_enriched_iron", 360), "molten_quartz_enriched_iron", consumer);
        this.createSimpleSolidifierRecipe(FluidStackHelper.getFluidStack("molten_experience", 100), Items.GLASS_BOTTLE.getDefaultInstance(), (ItemLike)Items.EXPERIENCE_BOTTLE, "experience/bottle", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_obsidian", 1000), (ItemLike)Items.OBSIDIAN, FluidData.getTempByName("molten_obsidian"), "obsidian/from_block", consumer);
        this.createSimpleSolidifierRecipe(FluidStackHelper.getFluidStack("molten_obsidian", 1000), CastingTags.Items.BLOCK_MOLD, (ItemLike)Items.OBSIDIAN, "obsidian/block", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_glass", 1000), (ItemLike)Items.GLASS, FluidData.getTempByName("molten_glass"), "glass/from_block", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_glass", 1000), (TagKey<Item>)ItemTags.SAND, FluidData.getTempByName("molten_glass"), "glass/from_sand", consumer);
        this.createSimpleSolidifierRecipe(FluidStackHelper.getFluidStack("molten_glass", 1000), CastingTags.Items.BLOCK_MOLD, (ItemLike)Items.GLASS, "glass/block", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_debris", 90), (ItemLike)Items.ANCIENT_DEBRIS, FluidData.getTempByName("molten_debris"), "debris/from_debris", consumer);
        this.createSimpleSolidifierRecipe(FluidStackHelper.getFluidStack("molten_debris", 90), CastingTags.Items.INGOT_MOLD, (ItemLike)Items.NETHERITE_SCRAP, "debris/netherite_scrap", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_silicon", 250), (TagKey<Item>)ModdedTagBuilder.createNeoFabricItemTag((String)"silicon"), FluidData.getTempByName("molten_silicon"), "silicon/from_silicon", consumer);
        this.createSimpleSolidifierRecipe(FluidStackHelper.getFluidStack("molten_silicon", 250), CastingTags.Items.BALL_MOLD, (TagKey<Item>)ModdedTagBuilder.createNeoFabricItemTag((String)"silicon"), "silicon/block", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_coal", 80), (ItemLike)Items.COAL, FluidData.getTempByName("molten_coals"), "coal/from_coal", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_coal", 720), (ItemLike)Items.COAL_BLOCK, FluidData.getTempByName("molten_coals"), "coal/from_block", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_coal", 80), (TagKey<Item>)ModdedTagBuilder.createNeoFabricItemTag((String)"ores/coal"), FluidData.getTempByName("molten_coals"), "coal/from_ore", consumer);
        this.createSimpleSolidifierRecipe(FluidStackHelper.getFluidStack("molten_coal", 80), CastingTags.Items.GEM_MOLD, (ItemLike)Items.COAL, "coal/coal", consumer);
        this.createSimpleSolidifierRecipe(FluidStackHelper.getFluidStack("molten_coal", 720), CastingTags.Items.BLOCK_MOLD, (ItemLike)Items.COAL_BLOCK, "coal/coal_block", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_black_quartz", 250), (TagKey<Item>)ModdedTagBuilder.createNeoFabricItemTag((String)"ores/black_quartz"), FluidData.getTempByName("molten_black_quartz"), "black_quartz/from_ore", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_black_quartz", 250), (TagKey<Item>)ModdedTagBuilder.createNeoFabricItemTag((String)"dusts/black_quartz"), FluidData.getTempByName("molten_black_quartz"), "black_quartz/from_dust", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_black_quartz", 250), (TagKey<Item>)ModdedTagBuilder.createNeoFabricItemTag((String)"gems/black_quartz"), FluidData.getTempByName("molten_black_quartz"), "black_quartz/from_black_quartz", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_black_quartz", 1000), (TagKey<Item>)ModdedTagBuilder.createNeoFabricItemTag((String)"storage_blocks/black_quartz"), FluidData.getTempByName("molten_black_quartz"), "black_quartz/from_block", consumer);
        this.createSimpleSolidifierRecipe(FluidStackHelper.getFluidStack("molten_black_quartz", 250), CastingTags.Items.GEM_MOLD, (TagKey<Item>)ModdedTagBuilder.createNeoFabricItemTag((String)"gems/black_quartz"), "black_quartz/gem", consumer);
        this.createSimpleSolidifierRecipe(FluidStackHelper.getFluidStack("molten_black_quartz", 250), CastingTags.Items.DUST_MOLD, (TagKey<Item>)ModdedTagBuilder.createNeoFabricItemTag((String)"dusts/black_quartz"), "black_quartz/dust", consumer);
        this.createSimpleSolidifierRecipe(FluidStackHelper.getFluidStack("molten_black_quartz", 1000), CastingTags.Items.BLOCK_MOLD, (TagKey<Item>)ModdedTagBuilder.createNeoFabricItemTag((String)"storage_blocks/black_quartz"), "black_quartz/block", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_quartz", 250), (TagKey<Item>)ModdedTagBuilder.createNeoFabricItemTag((String)"ores/quartz"), FluidData.getTempByName("molten_quartz"), "quartz/from_ore", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_quartz", 250), (ItemLike)Items.QUARTZ, FluidData.getTempByName("molten_quartz"), "quartz/from_quartz", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_quartz", 250), (TagKey<Item>)ModdedTagBuilder.createNeoFabricItemTag((String)"dusts/quartz"), FluidData.getTempByName("molten_quartz"), "quartz/from_dust", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_quartz", 1000), (ItemLike)Items.QUARTZ_BLOCK, FluidData.getTempByName("molten_quartz"), "quartz/from_block", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_quartz", 1000), (ItemLike)Items.QUARTZ_BRICKS, FluidData.getTempByName("molten_quartz"), "quartz/from_bricks", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_quartz", 1000), (ItemLike)Items.CHISELED_QUARTZ_BLOCK, FluidData.getTempByName("molten_quartz"), "quartz/from_chiseled_block", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_quartz", 1000), (ItemLike)Items.QUARTZ_PILLAR, FluidData.getTempByName("molten_quartz"), "quartz/from_pillar", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_quartz", 1000), (ItemLike)Items.SMOOTH_QUARTZ, FluidData.getTempByName("molten_quartz"), "quartz/from_smooth_block", consumer);
        this.createSimpleSolidifierRecipe(FluidStackHelper.getFluidStack("molten_quartz", 250), CastingTags.Items.GEM_MOLD, (ItemLike)Items.QUARTZ, "quartz/gem", consumer);
        this.createSimpleSolidifierRecipe(FluidStackHelper.getFluidStack("molten_quartz", 250), CastingTags.Items.DUST_MOLD, (TagKey<Item>)ModdedTagBuilder.createNeoFabricItemTag((String)"dusts/quartz"), "quartz/dust", consumer);
        this.createSimpleSolidifierRecipe(FluidStackHelper.getFluidStack("molten_quartz", 1000), CastingTags.Items.BLOCK_MOLD, (ItemLike)Items.QUARTZ_BLOCK, "quartz/block", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_ender", 250), (ItemLike)Items.ENDER_PEARL, FluidData.getTempByName("molten_ender"), "ender/from_ender_pearl", consumer);
        this.createSimpleSolidifierRecipe(FluidStackHelper.getFluidStack("molten_ender", 250), CastingTags.Items.BALL_MOLD, (ItemLike)Items.ENDER_PEARL, "ender/ender_pearl", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_end_stone", 1000), (ItemLike)Items.END_STONE, FluidData.getTempByName("molten_end_stone"), "end_stone/from_end_stone", consumer);
        this.createSimpleSolidifierRecipe(FluidStackHelper.getFluidStack("molten_end_stone", 1000), CastingTags.Items.BLOCK_MOLD, (ItemLike)Items.END_STONE, "end_stone/block", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_stone", 1000), (TagKey<Item>)Tags.Items.STONES, FluidData.getTempByName("molten_stone"), "stone/from_stones", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_stone", 1000), (TagKey<Item>)Tags.Items.COBBLESTONES, FluidData.getTempByName("molten_stone"), "stone/from_cobblestones", consumer);
        this.createSimpleSolidifierRecipe(FluidStackHelper.getFluidStack("molten_stone", 1000), CastingTags.Items.BLOCK_MOLD, (ItemLike)Items.STONE, "stone/block", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_glowstone", 250), (ItemLike)Items.GLOWSTONE_DUST, FluidData.getTempByName("molten_glowstone"), "glowstone/from_glowstone_dust", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_glowstone", 1000), (ItemLike)Items.GLOWSTONE, FluidData.getTempByName("molten_glowstone"), "glowstone/from_glowstone", consumer);
        this.createSimpleSolidifierRecipe(FluidStackHelper.getFluidStack("molten_glowstone", 250), CastingTags.Items.DUST_MOLD, (ItemLike)Items.GLOWSTONE_DUST, "glowstone/dust", consumer);
        this.createSimpleSolidifierRecipe(FluidStackHelper.getFluidStack("molten_glowstone", 1000), CastingTags.Items.BLOCK_MOLD, (ItemLike)Items.GLOWSTONE, "glowstone/block", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_black_brick", 1000), (ItemLike)CastingBlocks.BLACK_BRICKS.get(), FluidData.getTempByName("molten_black_brick"), "black_brick/from_black_bricks", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_black_brick", 250), (ItemLike)CastingItems.BLACK_BRICK.get(), FluidData.getTempByName("molten_black_brick"), "black_brick/from_black_brick", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_black_brick", 1000), (ItemLike)Items.CLAY, FluidData.getTempByName("molten_black_brick"), "black_brick/from_clay_block", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_black_brick", 250), (ItemLike)Items.CLAY_BALL, FluidData.getTempByName("molten_black_brick"), "black_brick/from_clay", consumer);
        this.createSimpleSolidifierRecipe(FluidStackHelper.getFluidStack("molten_black_brick", 1000), CastingTags.Items.BLOCK_MOLD, (ItemLike)CastingBlocks.BLACK_BRICKS.get(), "black_brick/block", consumer);
        this.createSimpleSolidifierRecipe(FluidStackHelper.getFluidStack("molten_black_brick", 250), CastingTags.Items.INGOT_MOLD, (ItemLike)CastingItems.BLACK_BRICK.get(), "black_brick/black_brick", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_soul", 1000), (TagKey<Item>)ItemTags.SOUL_FIRE_BASE_BLOCKS, FluidData.getTempByName("molten_soul"), "soul/from_soul_sand", consumer);
        this.createSimpleSolidifierRecipe(FluidStackHelper.getFluidStack("molten_soul", 1000), CastingTags.Items.BLOCK_MOLD, (TagKey<Item>)ItemTags.SOUL_FIRE_BASE_BLOCKS, "soul/block", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_blaze", 90), (ItemLike)Items.BLAZE_ROD, FluidData.getTempByName("molten_blaze"), "blaze/from_blaze_rod", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("molten_blaze", 45), (ItemLike)Items.BLAZE_POWDER, FluidData.getTempByName("molten_blaze"), "blaze/from_blaze_powder", consumer);
        this.createSimpleSolidifierRecipe(FluidStackHelper.getFluidStack("molten_blaze", 90), CastingTags.Items.DUST_MOLD, (ItemLike)Items.BLAZE_POWDER, "blaze/dust", consumer);
        this.createSimpleSolidifierRecipe(FluidStackHelper.getFluidStack("molten_blaze", 90), CastingTags.Items.ROD_MOLD, (ItemLike)Items.BLAZE_ROD, "blaze/rod", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("chilled_water", 250), (ItemLike)Items.SNOWBALL, FluidData.getTempByName("chilled_water"), "chilled_coolant/from_snow_ball", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("chilled_water", 1000), (ItemLike)Items.SNOW_BLOCK, FluidData.getTempByName("chilled_water"), "chilled_coolant/from_snow_block", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("iced_water", 1000), (ItemLike)Items.ICE, FluidData.getTempByName("iced_water"), "iced_water/from_ice", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("iced_water", 9000), (ItemLike)Items.PACKED_ICE, FluidData.getTempByName("iced_water"), "iced_water/from_packed_ice", consumer);
        this.createSimpleMeltingRecipe(FluidStackHelper.getFluidStack("iced_water", 81000), (ItemLike)Items.BLUE_ICE, FluidData.getTempByName("iced_water"), "iced_water/from_blue_ice", consumer);
        this.createSimpleMixingRecipe(FluidStackHelper.fluidList(FluidStackHelper.getFluidStack("iced_water", 1000), FluidStackHelper.getFluidStack("chilled_water", 1000)), FluidStackHelper.getFluidStack("super_coolant", 2000), "super_coolant", consumer);
        this.createSimpleMixingRecipe(FluidStackHelper.fluidList(FluidStackHelper.getFluidStack("molten_copper", 270), FluidStackHelper.getFluidStack("molten_tin", 90)), FluidStackHelper.getFluidStack("molten_bronze", 360), "bronze", consumer);
        this.createSimpleMixingRecipe(FluidStackHelper.fluidList(FluidStackHelper.getFluidStack("molten_gold", 90), FluidStackHelper.getFluidStack("molten_soul", 1000)), FluidStackHelper.getFluidStack("molten_soularium", 90), "soularium", consumer);
        this.createSimpleMixingRecipe(FluidStackHelper.fluidList(FluidStackHelper.getFluidStack("molten_coal", 160), FluidStackHelper.getFluidStack("molten_iron", 90)), FluidStackHelper.getFluidStack("molten_steel", 90), "steel", consumer);
        this.createSimpleMixingRecipe(FluidStackHelper.fluidList(FluidStackHelper.getFluidStack("molten_copper", 270), FluidStackHelper.getFluidStack("molten_zinc", 90)), FluidStackHelper.getFluidStack("molten_brass", 360), "brass", consumer);
        this.createSimpleMixingRecipe(FluidStackHelper.fluidList(FluidStackHelper.getFluidStack("molten_ender", 250), FluidStackHelper.getFluidStack("molten_energetic_alloy", 90)), FluidStackHelper.getFluidStack("molten_vibrant_alloy", 90), "vibrant_alloy", consumer);
        this.createSimpleMixingRecipe(FluidStackHelper.fluidList(new FluidStack((Fluid)Fluids.WATER, 1000), new FluidStack((Fluid)Fluids.LAVA, 1000)), FluidStackHelper.getFluidStack("molten_obsidian", 1000), "obsidian", consumer);
        this.createSimpleMixingRecipe(FluidStackHelper.fluidList(FluidStackHelper.getFluidStack("molten_silicon", 250), FluidStackHelper.getFluidStack("molten_redstone", 90)), FluidStackHelper.getFluidStack("molten_redstone_alloy", 90), "redstone_alloy", consumer);
        this.createSimpleMixingRecipe(FluidStackHelper.fluidList(FluidStackHelper.getFluidStack("molten_ender", 250), FluidStackHelper.getFluidStack("molten_iron", 90)), FluidStackHelper.getFluidStack("molten_pulsating_alloy", 90), "pulsating_alloy", consumer);
        this.createSimpleMixingRecipe(FluidStackHelper.fluidList(FluidStackHelper.getFluidStack("molten_lead", 270), FluidStackHelper.getFluidStack("molten_platinum", 90), FluidStackHelper.getFluidStack("molten_ender", 500)), FluidStackHelper.getFluidStack("molten_enderium", 360), "enderium", consumer);
        this.createSimpleMixingRecipe(FluidStackHelper.fluidList(FluidStackHelper.getFluidStack("molten_iron", 90), FluidStackHelper.getFluidStack("molten_coal", 160), FluidStackHelper.getFluidStack("molten_obsidian", 1000)), FluidStackHelper.getFluidStack("molten_dark_steel", 90), "dark_steel", consumer);
        this.createSimpleMixingRecipe(FluidStackHelper.fluidList(FluidStackHelper.getFluidStack("molten_copper", 90), FluidStackHelper.getFluidStack("molten_nickel", 90)), FluidStackHelper.getFluidStack("molten_constantan", 180), "constantan", consumer);
        this.createSimpleMixingRecipe(FluidStackHelper.fluidList(FluidStackHelper.getFluidStack("molten_iron", 180), FluidStackHelper.getFluidStack("molten_nickel", 90)), FluidStackHelper.getFluidStack("molten_invar", 270), "invar", consumer);
        this.createSimpleMixingRecipe(FluidStackHelper.fluidList(FluidStackHelper.getFluidStack("molten_end_stone", 1000), FluidStackHelper.getFluidStack("molten_dark_steel", 90), FluidStackHelper.getFluidStack("molten_obsidian", 1000)), FluidStackHelper.getFluidStack("molten_end_steel", 90), "end_steel", consumer);
        this.createSimpleMixingRecipe(FluidStackHelper.fluidList(FluidStackHelper.getFluidStack("molten_copper", 270), FluidStackHelper.getFluidStack("molten_silver", 90), FluidStackHelper.getFluidStack("molten_redstone", 360)), FluidStackHelper.getFluidStack("molten_signalum", 360), "signalum", consumer);
        this.createSimpleMixingRecipe(FluidStackHelper.fluidList(FluidStackHelper.getFluidStack("molten_tin", 270), FluidStackHelper.getFluidStack("molten_silver", 90), FluidStackHelper.getFluidStack("molten_glowstone", 500)), FluidStackHelper.getFluidStack("molten_lumium", 360), "lumium", consumer);
        this.createSimpleMixingRecipe(FluidStackHelper.fluidList(FluidStackHelper.getFluidStack("molten_redstone", 90), FluidStackHelper.getFluidStack("molten_iron", 90), FluidStackHelper.getFluidStack("molten_copper_alloy", 1000)), FluidStackHelper.getFluidStack("molten_conductive_alloy", 90), "conductive_alloy", consumer);
        this.createSimpleMixingRecipe(FluidStackHelper.fluidList(FluidStackHelper.getFluidStack("molten_silicon", 500), FluidStackHelper.getFluidStack("molten_copper", 90)), FluidStackHelper.getFluidStack("molten_copper_alloy", 90), "copper_alloy", consumer);
        this.createSimpleMixingRecipe(FluidStackHelper.fluidList(FluidStackHelper.getFluidStack("molten_gold", 90), FluidStackHelper.getFluidStack("molten_silver", 90)), FluidStackHelper.getFluidStack("molten_electrum", 180), "electrum", consumer);
        this.createSimpleMixingRecipe(FluidStackHelper.fluidList(FluidStackHelper.getFluidStack("molten_redstone", 90), FluidStackHelper.getFluidStack("molten_gold", 90), FluidStackHelper.getFluidStack("molten_glowstone", 250)), FluidStackHelper.getFluidStack("molten_energetic_alloy", 90), "energetic_alloy", consumer);
        this.createSimpleMixingRecipe(FluidStackHelper.fluidList(FluidStackHelper.getFluidStack("molten_debris", 360), FluidStackHelper.getFluidStack("molten_gold", 360)), FluidStackHelper.getFluidStack("molten_netherite", 90), "netherite", consumer);
    }

    public void createSimpleMixingRecipe(NonNullList<FluidStack> fluids, FluidStack output, String recipeID, RecipeOutput consumer) {
        MixingRecipeBuilder.mixingRecipesBuilder(fluids, output).unlockedBy("has_item", CastingRecipeProvider.has(CastingBlocks.MULTIBLOCK_MIXER)).save(consumer, "casting:mixer/" + recipeID);
    }

    public void createSimpleMeltingRecipe(FluidStack output, ItemLike input, int temp, String recipeID, RecipeOutput consumer) {
        MeltingRecipeBuilder.meltingRecipesBuilder(new SizedIngredient(Ingredient.of((ItemLike[])new ItemLike[]{input}), 1), output, temp).unlockedBy("has_item", CastingRecipeProvider.has((ItemLike)input)).save(consumer.withConditions(new ICondition[]{new ItemExistsCondition(String.valueOf(input.asItem()))}), "casting:melting/" + recipeID);
    }

    public void createSimpleMeltingRecipe(FluidStack output, TagKey<Item> input, int temp, String recipeID, RecipeOutput consumer) {
        MeltingRecipeBuilder.meltingRecipesBuilder(new SizedIngredient(Ingredient.of(input), 1), output, temp).unlockedBy("has_item", CastingRecipeProvider.has(input)).save(consumer.withConditions(new ICondition[]{new NotCondition((ICondition)new TagEmptyCondition(input))}), "casting:melting/" + recipeID);
    }

    public void createSimpleSolidifierRecipe(FluidStack output, TagKey<Item> mold, ItemLike input, String recipeID, RecipeOutput consumer) {
        SolidifierRecipeBuilder.solidifierRecipesBuilder(new SizedIngredient(Ingredient.of(mold), 1), new SizedIngredient(Ingredient.of((ItemLike[])new ItemLike[]{input}), 1), output).unlockedBy("has_item", CastingRecipeProvider.has((ItemLike)input)).save(consumer.withConditions(new ICondition[]{new ItemExistsCondition(String.valueOf(input.asItem()))}), "casting:solidifier/" + recipeID);
    }

    public void createSimpleSolidifierRecipe(FluidStack output, TagKey<Item> mold, TagKey<Item> input, String recipeID, RecipeOutput consumer) {
        SolidifierRecipeBuilder.solidifierRecipesBuilder(new SizedIngredient(Ingredient.of(mold), 1), new SizedIngredient(Ingredient.of(input), 1), output).unlockedBy("has_item", CastingRecipeProvider.has(input)).save(consumer.withConditions(new ICondition[]{new NotCondition((ICondition)new TagEmptyCondition(input))}), "casting:solidifier/" + recipeID);
    }

    public void createSimpleSolidifierRecipe(FluidStack output, ItemStack mold, ItemLike input, String recipeID, RecipeOutput consumer) {
        SolidifierRecipeBuilder.solidifierRecipesBuilder(new SizedIngredient(Ingredient.of((ItemStack[])new ItemStack[]{mold}), 1), new SizedIngredient(Ingredient.of((ItemLike[])new ItemLike[]{input}), 1), output).unlockedBy("has_item", CastingRecipeProvider.has((ItemLike)input)).save(consumer.withConditions(new ICondition[]{new ItemExistsCondition(String.valueOf(input.asItem()))}), "casting:solidifier/" + recipeID);
    }

    public void createSimpleSolidifierRecipe(FluidStack output, ItemStack mold, TagKey<Item> input, String recipeID, RecipeOutput consumer) {
        SolidifierRecipeBuilder.solidifierRecipesBuilder(new SizedIngredient(Ingredient.of((ItemStack[])new ItemStack[]{mold}), 1), new SizedIngredient(Ingredient.of(input), 1), output).unlockedBy("has_item", CastingRecipeProvider.has(input)).save(consumer.withConditions(new ICondition[]{new NotCondition((ICondition)new TagEmptyCondition(input))}), "casting:solidifier/" + recipeID);
    }

    public void createCommonMeltingRecipes(String type, RecipeOutput consumer) {
        int temp = FluidData.getTempByName(type);
        Fluid fluid = CastingFluids.FLUIDS_MAP.get("molten_" + type).getFluid();
        for (CommonTags.ResourceType resourceTypes : CommonTags.ResourceType.values()) {
            int amount = MaterialMelting.valueOf(String.valueOf(resourceTypes)).getAmount();
            TagKey tagKey = CommonTags.getTag((String)type, (CommonTags.ResourceType)resourceTypes);
            String resourceName = resourceTypes.toString().toLowerCase(Locale.ROOT);
            if (resourceName.endsWith("s")) {
                resourceName = resourceName.substring(0, resourceName.length() - 1);
            }
            MeltingRecipeBuilder.meltingRecipesBuilder(new SizedIngredient(Ingredient.of((TagKey)tagKey), 1), new FluidStack(fluid, amount), temp).unlockedBy("has_item", CastingRecipeProvider.has((TagKey)tagKey)).save(consumer.withConditions(new ICondition[]{new NotCondition((ICondition)new TagEmptyCondition(tagKey))}), "casting:melting/" + type + "/from_" + resourceName);
        }
    }

    public void createCommonSolidifierRecipes(String type, RecipeOutput consumer) {
        Fluid fluid = CastingFluids.FLUIDS_MAP.get("molten_" + type).getFluid();
        for (CommonTags.ResourceType resourceTypes : CommonTags.ResourceType.values()) {
            TagKey<Item> moldTag;
            int amount = MaterialMelting.valueOf(String.valueOf(resourceTypes)).getAmount();
            TagKey tagKey = CommonTags.getTag((String)type, (CommonTags.ResourceType)resourceTypes);
            String resourceName = resourceTypes.toString().toLowerCase(Locale.ROOT);
            if (resourceName.endsWith("s")) {
                resourceName = resourceName.substring(0, resourceName.length() - 1);
            }
            if ((moldTag = this.getMoldTag(resourceTypes)) == null) continue;
            SolidifierRecipeBuilder.solidifierRecipesBuilder(SizedIngredient.of(moldTag, (int)1), new SizedIngredient(Ingredient.of((TagKey)tagKey), 1), new FluidStack(fluid, amount)).unlockedBy("has_item", CastingRecipeProvider.has((TagKey)tagKey)).save(consumer.withConditions(new ICondition[]{new NotCondition((ICondition)new TagEmptyCondition(tagKey))}), "casting:solidifier/" + type + "/" + resourceName);
        }
    }

    public void createMoldRecipe(ItemLike output, TagKey<Item> input, RecipeOutput consumer) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)1).pattern(" A ").pattern("ABA").pattern(" A ").define(Character.valueOf('A'), (ItemLike)CastingItems.BLACK_BRICK.get()).define(Character.valueOf('B'), input).unlockedBy("has_black_brick", CastingRecipeProvider.has((ItemLike)((ItemLike)CastingItems.BLACK_BRICK.get()))).save(consumer.withConditions(new ICondition[]{new NotCondition((ICondition)new TagEmptyCondition(input))}));
    }

    public void createMoldRecipeWithID(ItemLike output, TagKey<Item> input, RecipeOutput consumer, String id) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)1).pattern(" A ").pattern("ABA").pattern(" A ").define(Character.valueOf('A'), (ItemLike)CastingItems.BLACK_BRICK.get()).define(Character.valueOf('B'), input).unlockedBy("has_black_brick", CastingRecipeProvider.has((ItemLike)((ItemLike)CastingItems.BLACK_BRICK.get()))).save(consumer.withConditions(new ICondition[]{new NotCondition((ICondition)new TagEmptyCondition(input))}), "casting:" + id);
    }

    public void toolModifierRecipes(RecipeOutput consumer, SizedIngredient ingredient, FluidStack fluid, String effect) {
        Object recipeFrom = "";
        if (ingredient == null) {
            recipeFrom = "equipment_modifier/" + effect + "_from_fluid";
        }
        if (fluid == null) {
            recipeFrom = "equipment_modifier/" + effect + "_from_item";
        }
        if (fluid != null && ingredient != null) {
            recipeFrom = "equipment_modifier/" + effect + "_from_fluid_and_item";
        }
        EquipmentModifierRecipeBuilder.ToolModifierRecipesBuilder(ingredient, fluid, effect).unlockedBy("has_item", CastingRecipeProvider.has((ItemLike)((ItemLike)CastingBlocks.EQUIPMENT_MODIFIER.get()))).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"casting", (String)recipeFrom));
    }

    public TagKey<Item> getMoldTag(CommonTags.ResourceType resourceTypes) {
        return switch (resourceTypes) {
            default -> throw new MatchException(null, null);
            case CommonTags.ResourceType.INGOTS -> CastingTags.Items.INGOT_MOLD;
            case CommonTags.ResourceType.NUGGETS -> CastingTags.Items.NUGGET_MOLD;
            case CommonTags.ResourceType.STORAGE_BLOCKS -> CastingTags.Items.BLOCK_MOLD;
            case CommonTags.ResourceType.RAW_STORAGE_BLOCKS, CommonTags.ResourceType.RAW_MATERIALS, CommonTags.ResourceType.ORES -> null;
            case CommonTags.ResourceType.PLATES -> CastingTags.Items.PLATE_MOLD;
            case CommonTags.ResourceType.DUSTS -> CastingTags.Items.DUST_MOLD;
            case CommonTags.ResourceType.GEARS -> CastingTags.Items.GEAR_MOLD;
            case CommonTags.ResourceType.RODS -> CastingTags.Items.ROD_MOLD;
            case CommonTags.ResourceType.GEMS -> CastingTags.Items.GEM_MOLD;
            case CommonTags.ResourceType.WIRES -> CastingTags.Items.WIRE_MOLD;
        };
    }
}

