/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.data;

import com.benbenlaw.casting.fluid.CastingFluids;
import com.benbenlaw.casting.item.CastingItems;
import com.benbenlaw.casting.item.EquipmentModifier;
import com.benbenlaw.core.fluid.FluidRegistryObject;
import java.util.Map;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.loaders.DynamicFluidContainerModelBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;

public class CastingItemModelProvider
extends ItemModelProvider {
    public CastingItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "casting", existingFileHelper);
    }

    protected void registerModels() {
        this.simpleItem(CastingItems.BLACK_BRICK);
        this.simpleItem(CastingItems.FLUID_MOVER);
        this.simpleItem(CastingItems.BLOCK_MOLD);
        this.simpleItem(CastingItems.GEAR_MOLD);
        this.simpleItem(CastingItems.INGOT_MOLD);
        this.simpleItem(CastingItems.NUGGET_MOLD);
        this.simpleItem(CastingItems.PLATE_MOLD);
        this.simpleItem(CastingItems.ROD_MOLD);
        this.simpleItem(CastingItems.GEM_MOLD);
        this.simpleItem(CastingItems.DUST_MOLD);
        this.simpleItem(CastingItems.BALL_MOLD);
        this.simpleItem(CastingItems.WIRE_MOLD);
        this.simpleItem(CastingItems.REPAIRING_MOLD);
        for (EquipmentModifier modifier : EquipmentModifier.values()) {
            this.simpleItem(modifier.item);
        }
        for (Map.Entry entry : CastingFluids.FLUIDS_MAP.entrySet()) {
            String fluidName = (String)entry.getKey();
            FluidRegistryObject fluid = (FluidRegistryObject)entry.getValue();
            this.simpleBucketItem(fluidName + "_bucket", fluid.getFluid());
        }
    }

    private void simpleBucketItem(String name, Fluid fluid) {
        ((DynamicFluidContainerModelBuilder)((ItemModelBuilder)this.withExistingParent(name, ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"item/bucket"))).customLoader(DynamicFluidContainerModelBuilder::begin)).fluid(fluid);
    }

    private void simpleItem(DeferredItem<Item> item) {
        ((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"casting", (String)("item/" + item.getId().getPath())));
    }

    public void simpleItem(DeferredHolder<Item, ?> item) {
        ((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + item.getId().getPath()));
    }

    private ItemModelBuilder simpleBlockItem(DeferredBlock<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"casting", (String)("item/" + item.getId().getPath())));
    }

    public String getName() {
        return "casting Item Models";
    }
}

