/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.block.entity.client;

import com.benbenlaw.casting.block.entity.multiblock.MultiblockControllerBlockEntity;
import com.benbenlaw.casting.util.MultiFluidTankSharedCapacity;
import com.benbenlaw.core.util.RenderUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

public class MultiblockControllerBlockEntityRenderer
implements BlockEntityRenderer<MultiblockControllerBlockEntity> {
    public MultiblockControllerBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(MultiblockControllerBlockEntity entity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        MultiFluidTankSharedCapacity fluidTank = entity.fluidHandler;
        if (!fluidTank.getFluids().isEmpty()) {
            FluidStack fluidStack = fluidTank.getFluids().getFirst();
            VertexConsumer buffer = pBufferSource.getBuffer(Sheets.translucentCullBlockSheet());
            PoseStack.Pose last = pPoseStack.last();
            float fillAmount = (float)fluidStack.getAmount() / (float)fluidTank.getTankCapacity(1);
            MultiblockControllerBlockEntityRenderer.renderFluid(last, buffer, (BlockEntity)entity, fluidStack.getFluid(), fillAmount, pPackedLight);
        }
    }

    private static void renderFluid(PoseStack.Pose pose, VertexConsumer consumer, BlockEntity entity, Fluid fluid, float fillAmount, int packedLight) {
        int color = IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor(fluid.defaultFluidState(), (BlockAndTintGetter)entity.getLevel(), entity.getBlockPos());
        MultiblockControllerBlockEntityRenderer.renderFluid(pose, consumer, fluid, fillAmount, color, packedLight);
    }

    public static void renderFluid(PoseStack.Pose pose, VertexConsumer consumer, Fluid fluid, float fillAmount, int color, int packedLight) {
        IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)fluid);
        TextureAtlasSprite texture = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(props.getStillTexture());
        float tankSize = 3.0f;
        float fluidHeight = fillAmount * tankSize;
        float inset = 0.1f;
        float faceSize = 0.33333334f;
        float moveUp = 4.0f;
        for (int x = 0; x < 3; ++x) {
            for (int z = 0; z < 3; ++z) {
                float posX = inset + (float)x * faceSize;
                float posZ = inset + (float)z * faceSize;
                RenderUtil.renderFace((Direction)Direction.UP, (PoseStack.Pose)pose, (VertexConsumer)consumer, (TextureAtlasSprite)texture, (float)posX, (float)(posZ + moveUp), (float)(inset + fluidHeight), (float)faceSize, (float)faceSize, (int)color, (int)packedLight);
            }
        }
        RenderUtil.renderFace((Direction)Direction.SOUTH, (PoseStack.Pose)pose, (VertexConsumer)consumer, (TextureAtlasSprite)texture, (float)inset, (float)(inset + moveUp), (float)inset, (float)faceSize, (float)fluidHeight, (int)color, (int)packedLight);
        RenderUtil.renderFace((Direction)Direction.NORTH, (PoseStack.Pose)pose, (VertexConsumer)consumer, (TextureAtlasSprite)texture, (float)inset, (float)(inset + moveUp), (float)inset, (float)faceSize, (float)fluidHeight, (int)color, (int)packedLight);
        RenderUtil.renderFace((Direction)Direction.EAST, (PoseStack.Pose)pose, (VertexConsumer)consumer, (TextureAtlasSprite)texture, (float)inset, (float)(inset + moveUp), (float)inset, (float)faceSize, (float)fluidHeight, (int)color, (int)packedLight);
        RenderUtil.renderFace((Direction)Direction.WEST, (PoseStack.Pose)pose, (VertexConsumer)consumer, (TextureAtlasSprite)texture, (float)inset, (float)(inset + moveUp), (float)inset, (float)faceSize, (float)fluidHeight, (int)color, (int)packedLight);
        RenderUtil.renderFace((Direction)Direction.UP, (PoseStack.Pose)pose, (VertexConsumer)consumer, (TextureAtlasSprite)texture, (float)inset, (float)(inset + moveUp), (float)(inset + fluidHeight), (float)faceSize, (float)faceSize, (int)color, (int)packedLight);
        RenderUtil.renderFace((Direction)Direction.DOWN, (PoseStack.Pose)pose, (VertexConsumer)consumer, (TextureAtlasSprite)texture, (float)inset, (float)(inset + moveUp), (float)(1.0f - inset), (float)faceSize, (float)faceSize, (int)color, (int)packedLight);
    }
}

