/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.block.custom;

import com.benbenlaw.casting.block.entity.CastingBlockEntities;
import com.benbenlaw.casting.block.entity.MixerBlockEntity;
import com.benbenlaw.casting.item.CastingDataComponents;
import com.benbenlaw.casting.screen.MixerMenu;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MixerBlock
extends BaseEntityBlock {
    public static final MapCodec<MixerBlock> CODEC = MixerBlock.simpleCodec(MixerBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
    }

    @NotNull
    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING});
    }

    public MixerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (pState.getBlock() != pNewState.getBlock() && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof MixerBlockEntity) {
            ((MixerBlockEntity)blockEntity).drops();
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState blockState, Level level, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull BlockHitResult hit) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        if (!level.isClientSide()) {
            MixerBlockEntity mixerBlockEntity = (MixerBlockEntity)level.getBlockEntity(blockPos);
            if (mixerBlockEntity instanceof MixerBlockEntity) {
                if (mixerBlockEntity.onPlayerUse(player, InteractionHand.MAIN_HAND)) {
                    return InteractionResult.SUCCESS;
                }
                ContainerData data = mixerBlockEntity.data;
                player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new MixerMenu(windowId, playerInventory, blockPos, data), (Component)Component.translatable((String)"block.casting.mixer")), buf -> buf.writeBlockPos(blockPos));
                mixerBlockEntity.sync();
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void setPlacedBy(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity entity, ItemStack itemStack) {
        super.setPlacedBy(level, blockPos, blockState, entity, itemStack);
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof MixerBlockEntity) {
            MixerBlockEntity mixerBlockEntity = (MixerBlockEntity)blockEntity;
            if (itemStack.has(CastingDataComponents.FLUID_TYPE_1) && itemStack.has(CastingDataComponents.FLUID_AMOUNT_1)) {
                String fluidAsString1 = (String)itemStack.get(CastingDataComponents.FLUID_TYPE_1);
                Fluid fluid1 = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)fluidAsString1));
                int fluidAmount1 = (Integer)itemStack.get(CastingDataComponents.FLUID_AMOUNT_1);
                mixerBlockEntity.setFluid1(new FluidStack(fluid1, fluidAmount1));
            }
            if (itemStack.has(CastingDataComponents.FLUID_TYPE_2) && itemStack.has(CastingDataComponents.FLUID_AMOUNT_2)) {
                String fluidAsString2 = (String)itemStack.get(CastingDataComponents.FLUID_TYPE_2);
                Fluid fluid2 = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)fluidAsString2));
                int fluidAmount2 = (Integer)itemStack.get(CastingDataComponents.FLUID_AMOUNT_2);
                mixerBlockEntity.setFluid2(new FluidStack(fluid2, fluidAmount2));
            }
            if (itemStack.has(CastingDataComponents.FLUID_TYPE_3) && itemStack.has(CastingDataComponents.FLUID_AMOUNT_3)) {
                String fluidAsString3 = (String)itemStack.get(CastingDataComponents.FLUID_TYPE_3);
                Fluid fluid3 = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)fluidAsString3));
                int fluidAmount3 = (Integer)itemStack.get(CastingDataComponents.FLUID_AMOUNT_3);
                mixerBlockEntity.setFluid3(new FluidStack(fluid3, fluidAmount3));
            }
            if (itemStack.has(CastingDataComponents.FLUID_TYPE_4) && itemStack.has(CastingDataComponents.FLUID_AMOUNT_4)) {
                String fluidAsString4 = (String)itemStack.get(CastingDataComponents.FLUID_TYPE_4);
                Fluid fluid4 = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)fluidAsString4));
                int fluidAmount4 = (Integer)itemStack.get(CastingDataComponents.FLUID_AMOUNT_4);
                mixerBlockEntity.setFluid4(new FluidStack(fluid4, fluidAmount4));
            }
            if (itemStack.has(CastingDataComponents.FLUID_TYPE_5) && itemStack.has(CastingDataComponents.FLUID_AMOUNT_5)) {
                String fluidAsString5 = (String)itemStack.get(CastingDataComponents.FLUID_TYPE_5);
                Fluid fluid5 = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)fluidAsString5));
                int fluidAmount5 = (Integer)itemStack.get(CastingDataComponents.FLUID_AMOUNT_5);
                mixerBlockEntity.setFluid5(new FluidStack(fluid5, fluidAmount5));
            }
            if (itemStack.has(CastingDataComponents.FLUID_TYPE_6) && itemStack.has(CastingDataComponents.FLUID_AMOUNT_6)) {
                String fluidAsString6 = (String)itemStack.get(CastingDataComponents.FLUID_TYPE_6);
                Fluid fluid6 = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)fluidAsString6));
                int fluidAmount6 = (Integer)itemStack.get(CastingDataComponents.FLUID_AMOUNT_6);
                mixerBlockEntity.setFluid6(new FluidStack(fluid6, fluidAmount6));
            }
            if (itemStack.has(CastingDataComponents.OUTPUT_FLUID_1) && itemStack.has(CastingDataComponents.OUTPUT_FLUID_AMOUNT_1)) {
                String outputFluidAsString = (String)itemStack.get(CastingDataComponents.OUTPUT_FLUID_1);
                Fluid outputFluid = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)outputFluidAsString));
                int outputFluidAmount = (Integer)itemStack.get(CastingDataComponents.OUTPUT_FLUID_AMOUNT_1);
                mixerBlockEntity.setOutputFluid(new FluidStack(outputFluid, outputFluidAmount));
            }
        }
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity entity, ItemStack stack) {
        if (entity instanceof MixerBlockEntity) {
            MixerBlockEntity mixerBlockEntity = (MixerBlockEntity)entity;
            ItemStack itemStackWithFluids = new ItemStack((ItemLike)this);
            if (mixerBlockEntity.getFluidStack1().getFluid() != Fluids.EMPTY && mixerBlockEntity.getFluidStack1().getAmount() > 0) {
                itemStackWithFluids.set(CastingDataComponents.FLUID_TYPE_1, (Object)mixerBlockEntity.getFluidStack1().getFluid().getFluidType().toString());
                itemStackWithFluids.set(CastingDataComponents.FLUID_AMOUNT_1, (Object)mixerBlockEntity.getFluidStack1().getAmount());
            }
            if (mixerBlockEntity.getFluidStack2().getFluid() != Fluids.EMPTY && mixerBlockEntity.getFluidStack2().getAmount() > 0) {
                itemStackWithFluids.set(CastingDataComponents.FLUID_TYPE_2, (Object)mixerBlockEntity.getFluidStack2().getFluid().getFluidType().toString());
                itemStackWithFluids.set(CastingDataComponents.FLUID_AMOUNT_2, (Object)mixerBlockEntity.getFluidStack2().getAmount());
            }
            if (mixerBlockEntity.getFluidStack3().getFluid() != Fluids.EMPTY && mixerBlockEntity.getFluidStack3().getAmount() > 0) {
                itemStackWithFluids.set(CastingDataComponents.FLUID_TYPE_3, (Object)mixerBlockEntity.getFluidStack3().getFluid().getFluidType().toString());
                itemStackWithFluids.set(CastingDataComponents.FLUID_AMOUNT_3, (Object)mixerBlockEntity.getFluidStack3().getAmount());
            }
            if (mixerBlockEntity.getFluidStack4().getFluid() != Fluids.EMPTY && mixerBlockEntity.getFluidStack4().getAmount() > 0) {
                itemStackWithFluids.set(CastingDataComponents.FLUID_TYPE_4, (Object)mixerBlockEntity.getFluidStack4().getFluid().getFluidType().toString());
                itemStackWithFluids.set(CastingDataComponents.FLUID_AMOUNT_4, (Object)mixerBlockEntity.getFluidStack4().getAmount());
            }
            if (mixerBlockEntity.getFluidStack5().getFluid() != Fluids.EMPTY && mixerBlockEntity.getFluidStack5().getAmount() > 0) {
                itemStackWithFluids.set(CastingDataComponents.FLUID_TYPE_5, (Object)mixerBlockEntity.getFluidStack5().getFluid().getFluidType().toString());
                itemStackWithFluids.set(CastingDataComponents.FLUID_AMOUNT_5, (Object)mixerBlockEntity.getFluidStack5().getAmount());
            }
            if (mixerBlockEntity.getFluidStack6().getFluid() != Fluids.EMPTY && mixerBlockEntity.getFluidStack6().getAmount() > 0) {
                itemStackWithFluids.set(CastingDataComponents.FLUID_TYPE_6, (Object)mixerBlockEntity.getFluidStack6().getFluid().getFluidType().toString());
                itemStackWithFluids.set(CastingDataComponents.FLUID_AMOUNT_6, (Object)mixerBlockEntity.getFluidStack6().getAmount());
            }
            if (mixerBlockEntity.getOutputFluid().getFluid() != Fluids.EMPTY && mixerBlockEntity.getOutputFluid().getAmount() > 0) {
                itemStackWithFluids.set(CastingDataComponents.OUTPUT_FLUID_1, (Object)mixerBlockEntity.getOutputFluid().getFluid().getFluidType().toString());
                itemStackWithFluids.set(CastingDataComponents.OUTPUT_FLUID_AMOUNT_1, (Object)mixerBlockEntity.getOutputFluid().getAmount());
            }
            MixerBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)itemStackWithFluids);
        } else {
            MixerBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)this.asItem().getDefaultInstance());
        }
        super.playerDestroy(level, player, pos, state, entity, stack);
    }

    public void appendHoverText(ItemStack itemStack, @NotNull Item.TooltipContext context, @NotNull List<Component> components, @NotNull TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            if (itemStack.has(CastingDataComponents.FLUID_TYPE_1) && itemStack.has(CastingDataComponents.FLUID_AMOUNT_1)) {
                String fluidAsString1 = (String)itemStack.get(CastingDataComponents.FLUID_TYPE_1);
                int fluidAmount1 = (Integer)itemStack.get(CastingDataComponents.FLUID_AMOUNT_1);
                FluidType fluid1 = ((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)fluidAsString1))).getFluidType();
                components.add((Component)Component.literal((String)"Tank 1 Contains: ").append(fluidAmount1 + "mb ").append((Component)Component.translatable((String)fluid1.getDescriptionId())).withStyle(ChatFormatting.GREEN));
            }
            if (itemStack.has(CastingDataComponents.FLUID_TYPE_2) && itemStack.has(CastingDataComponents.FLUID_AMOUNT_2)) {
                String fluidAsString2 = (String)itemStack.get(CastingDataComponents.FLUID_TYPE_2);
                int fluidAmount2 = (Integer)itemStack.get(CastingDataComponents.FLUID_AMOUNT_2);
                FluidType fluid2 = ((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)fluidAsString2))).getFluidType();
                components.add((Component)Component.literal((String)"Tank 2 Contains: ").append(fluidAmount2 + "mb ").append((Component)Component.translatable((String)fluid2.getDescriptionId())).withStyle(ChatFormatting.GREEN));
            }
            if (itemStack.has(CastingDataComponents.FLUID_TYPE_3) && itemStack.has(CastingDataComponents.FLUID_AMOUNT_3)) {
                String fluidAsString3 = (String)itemStack.get(CastingDataComponents.FLUID_TYPE_3);
                int fluidAmount3 = (Integer)itemStack.get(CastingDataComponents.FLUID_AMOUNT_3);
                FluidType fluid3 = ((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)fluidAsString3))).getFluidType();
                components.add((Component)Component.literal((String)"Tank 3 Contains: ").append(fluidAmount3 + "mb ").append((Component)Component.translatable((String)fluid3.getDescriptionId())).withStyle(ChatFormatting.GREEN));
            }
            if (itemStack.has(CastingDataComponents.FLUID_TYPE_4) && itemStack.has(CastingDataComponents.FLUID_AMOUNT_4)) {
                String fluidAsString4 = (String)itemStack.get(CastingDataComponents.FLUID_TYPE_4);
                int fluidAmount4 = (Integer)itemStack.get(CastingDataComponents.FLUID_AMOUNT_4);
                FluidType fluid4 = ((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)fluidAsString4))).getFluidType();
                components.add((Component)Component.literal((String)"Tank 4 Contains: ").append(fluidAmount4 + "mb ").append((Component)Component.translatable((String)fluid4.getDescriptionId())).withStyle(ChatFormatting.GREEN));
            }
            if (itemStack.has(CastingDataComponents.FLUID_TYPE_5) && itemStack.has(CastingDataComponents.FLUID_AMOUNT_5)) {
                String fluidAsString5 = (String)itemStack.get(CastingDataComponents.FLUID_TYPE_5);
                int fluidAmount5 = (Integer)itemStack.get(CastingDataComponents.FLUID_AMOUNT_5);
                FluidType fluid5 = ((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)fluidAsString5))).getFluidType();
                components.add((Component)Component.literal((String)"Tank 5 Contains: ").append(fluidAmount5 + "mb ").append((Component)Component.translatable((String)fluid5.getDescriptionId())).withStyle(ChatFormatting.GREEN));
            }
            if (itemStack.has(CastingDataComponents.FLUID_TYPE_6) && itemStack.has(CastingDataComponents.FLUID_AMOUNT_6)) {
                String fluidAsString6 = (String)itemStack.get(CastingDataComponents.FLUID_TYPE_6);
                int fluidAmount6 = (Integer)itemStack.get(CastingDataComponents.FLUID_AMOUNT_6);
                FluidType fluid6 = ((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)fluidAsString6))).getFluidType();
                components.add((Component)Component.literal((String)"Tank 6 Contains: ").append(fluidAmount6 + "mb ").append((Component)Component.translatable((String)fluid6.getDescriptionId())).withStyle(ChatFormatting.GREEN));
            }
            if (itemStack.has(CastingDataComponents.OUTPUT_FLUID_1) && itemStack.has(CastingDataComponents.OUTPUT_FLUID_AMOUNT_1)) {
                String outputFluidAsString = (String)itemStack.get(CastingDataComponents.OUTPUT_FLUID_1);
                int outputFluidAmount = (Integer)itemStack.get(CastingDataComponents.OUTPUT_FLUID_AMOUNT_1);
                FluidType outputFluid = ((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)outputFluidAsString))).getFluidType();
                components.add((Component)Component.literal((String)"Output Tank Contains: ").append(outputFluidAmount + "mb ").append((Component)Component.translatable((String)outputFluid.getDescriptionId())).withStyle(ChatFormatting.GREEN));
            }
        } else if (itemStack.has(CastingDataComponents.FLUID_TYPE_1)) {
            components.add((Component)Component.translatable((String)"tooltips.bblcore.shift").withStyle(ChatFormatting.YELLOW));
        }
        super.appendHoverText(itemStack, context, components, flag);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new MixerBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> blockEntityType) {
        return MixerBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)CastingBlockEntities.MIXER_BLOCK_ENTITY.get()), (world, blockPos, thisBlockState, blockEntity) -> blockEntity.tick());
    }
}

