/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.network.packet;

import appeng.api.orientation.RelativeSide;
import com.glodblock.github.glodium.network.packet.IMessage;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.pedroksl.advanced_ae.AdvancedAE;
import net.pedroksl.advanced_ae.client.gui.OutputDirectionScreen;

public class OutputDirectionClientUpdatePacket
implements IMessage {
    private final Set<RelativeSide> sides;

    public OutputDirectionClientUpdatePacket(EnumSet<RelativeSide> sides) {
        this.sides = sides;
    }

    public OutputDirectionClientUpdatePacket() {
        this.sides = new HashSet<RelativeSide>();
    }

    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.sides.size());
        for (RelativeSide side : this.sides) {
            buf.writeEnum((Enum)side);
        }
    }

    public void fromBytes(RegistryFriendlyByteBuf buf) {
        int size = buf.readInt();
        for (int x = 0; x < size; ++x) {
            this.sides.add((RelativeSide)buf.readEnum(RelativeSide.class));
        }
    }

    public void onMessage(Player player) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof OutputDirectionScreen) {
            OutputDirectionScreen screen2 = (OutputDirectionScreen)screen;
            screen2.update(this.sides);
        }
    }

    public boolean isClient() {
        return true;
    }

    public ResourceLocation id() {
        return AdvancedAE.makeId("output_direction_update_client");
    }
}

