/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.mixins.cpu;

import appeng.api.config.CpuSelectionMode;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.core.network.ClientboundPacket;
import appeng.core.network.clientbound.CraftingStatusPacket;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.menu.AEBaseMenu;
import appeng.menu.me.common.IncrementalUpdateHelper;
import appeng.menu.me.crafting.CraftingCPUMenu;
import appeng.menu.me.crafting.CraftingStatus;
import appeng.menu.me.crafting.CraftingStatusEntry;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.pedroksl.advanced_ae.common.cluster.AdvCraftingCPU;
import net.pedroksl.advanced_ae.common.cluster.AdvCraftingCPUCluster;
import net.pedroksl.advanced_ae.common.entities.AdvCraftingBlockEntity;
import net.pedroksl.advanced_ae.common.logic.AdvCraftingCPULogic;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CraftingCPUMenu.class}, remap=false)
public class MixinCraftingCPUMenu
extends AEBaseMenu {
    @Final
    @Shadow
    private IncrementalUpdateHelper incrementalUpdateHelper;
    @Shadow
    private CraftingCPUCluster cpu;
    @Unique
    private AdvCraftingCPU advancedAE$advCpu = null;
    @Final
    @Shadow
    private Consumer<AEKey> cpuChangeListener;
    @Shadow
    public CpuSelectionMode schedulingMode;
    @Shadow
    public boolean cantStoreItems;

    @Shadow
    protected void setCPU(ICraftingCPU c) {
    }

    @Inject(method={"<init>(Lnet/minecraft/world/inventory/MenuType;ILnet/minecraft/world/entity/player/Inventory;Ljava/lang/Object;)V"}, at={@At(value="TAIL")})
    private void onInit(MenuType<?> menuType, int id, Inventory ip, Object te, CallbackInfo ci) {
        if (te instanceof AdvCraftingBlockEntity) {
            AdvCraftingBlockEntity advEntity = (AdvCraftingBlockEntity)((Object)te);
            AdvCraftingCPUCluster cluster = advEntity.getCluster();
            if (cluster == null) {
                return;
            }
            List<AdvCraftingCPU> active = cluster.getActiveCPUs();
            if (!active.isEmpty()) {
                this.setCPU(active.getFirst());
            } else {
                this.setCPU(cluster.getRemainingCapacityCPU());
            }
        }
    }

    @Inject(method={"setCPU(Lappeng/api/networking/crafting/ICraftingCPU;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetCPU(ICraftingCPU c, CallbackInfo ci) {
        if (this.advancedAE$advCpu != null) {
            this.advancedAE$advCpu.craftingLogic.removeListener(this.cpuChangeListener);
        }
        if (c instanceof AdvCraftingCPU) {
            AdvCraftingCPU advCPU = (AdvCraftingCPU)c;
            if (this.cpu != null) {
                this.cpu.craftingLogic.removeListener(this.cpuChangeListener);
            }
            this.incrementalUpdateHelper.reset();
            this.advancedAE$advCpu = advCPU;
            KeyCounter allItems = new KeyCounter();
            this.advancedAE$advCpu.craftingLogic.getAllItems(allItems);
            for (Object2LongMap.Entry entry : allItems) {
                this.incrementalUpdateHelper.addChange((AEKey)entry.getKey());
            }
            this.advancedAE$advCpu.craftingLogic.addListener(this.cpuChangeListener);
            ci.cancel();
        } else {
            this.advancedAE$advCpu = null;
        }
    }

    @Inject(method={"cancelCrafting"}, at={@At(value="TAIL")})
    public void onCancelCrafting(CallbackInfo ci) {
        if (!this.isClientSide() && this.advancedAE$advCpu != null) {
            this.advancedAE$advCpu.cancelJob();
        }
    }

    @Inject(method={"removed"}, at={@At(value="TAIL")})
    public void onRemoved(Player player, CallbackInfo ci) {
        if (this.advancedAE$advCpu != null) {
            this.advancedAE$advCpu.craftingLogic.removeListener(this.cpuChangeListener);
        }
    }

    @Inject(method={"broadcastChanges"}, at={@At(value="HEAD")}, remap=true)
    public void onBroadcastChanges(CallbackInfo ci) {
        if (this.isServerSide() && this.advancedAE$advCpu != null) {
            this.schedulingMode = this.advancedAE$advCpu.getSelectionMode();
            this.cantStoreItems = this.advancedAE$advCpu.craftingLogic.isCantStoreItems();
            if (this.incrementalUpdateHelper.hasChanges()) {
                CraftingStatus status = MixinCraftingCPUMenu.advancedAE$create(this.incrementalUpdateHelper, this.advancedAE$advCpu.craftingLogic);
                this.incrementalUpdateHelper.commitChanges();
                this.sendPacketToClient((ClientboundPacket)new CraftingStatusPacket(this.containerId, status));
            }
        }
    }

    @Unique
    private static CraftingStatus advancedAE$create(IncrementalUpdateHelper changes, AdvCraftingCPULogic logic) {
        boolean full = changes.isFullUpdate();
        ImmutableList.Builder newEntries = ImmutableList.builder();
        for (AEKey what : changes) {
            long storedCount = logic.getStored(what);
            long activeCount = logic.getWaitingFor(what);
            long pendingCount = logic.getPendingOutputs(what);
            AEKey sentStack = what;
            if (!full && changes.getSerial(what) != null) {
                sentStack = null;
            }
            CraftingStatusEntry entry = new CraftingStatusEntry(changes.getOrAssignSerial(what), sentStack, storedCount, activeCount, pendingCount);
            newEntries.add((Object)entry);
            if (!entry.isDeleted()) continue;
            changes.removeSerial(what);
        }
        long elapsedTime = logic.getElapsedTimeTracker().getElapsedTime();
        long remainingItems = logic.getElapsedTimeTracker().getRemainingItemCount();
        long startItems = logic.getElapsedTimeTracker().getStartItemCount();
        return new CraftingStatus(full, elapsedTime, remainingItems, startItems, (List)newEntries.build());
    }

    public MixinCraftingCPUMenu(MenuType<?> menuType, int id, Inventory playerInventory, Object host) {
        super(menuType, id, playerInventory, host);
    }
}

