/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.gui;

import appeng.api.orientation.RelativeSide;
import appeng.menu.AEBaseMenu;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuHostLocator;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.pedroksl.advanced_ae.api.IDirectionalOutputHost;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.network.AAENetworkHandler;
import net.pedroksl.advanced_ae.network.packet.OutputDirectionClientUpdatePacket;
import net.pedroksl.advanced_ae.network.packet.UpdateSideStatusPacket;

public class OutputDirectionMenu
extends AEBaseMenu
implements ISubMenu {
    public EnumSet<RelativeSide> allowedOutputs = EnumSet.allOf(RelativeSide.class);
    private final IDirectionalOutputHost host;
    private static final String CLEAR = "clearSides";

    public OutputDirectionMenu(int id, Inventory ip, IDirectionalOutputHost host) {
        this(AAEMenus.OUTPUT_DIRECTION.get(), id, ip, host);
    }

    protected OutputDirectionMenu(MenuType<? extends OutputDirectionMenu> type, int id, Inventory ip, IDirectionalOutputHost host) {
        super(type, id, ip, (Object)host);
        this.host = host;
        this.registerClientAction(CLEAR, this::clearSides);
    }

    public IDirectionalOutputHost getHost() {
        return this.host;
    }

    public static void open(ServerPlayer player, MenuHostLocator locator, EnumSet<RelativeSide> allowedOutputs) {
        MenuOpener.open(AAEMenus.OUTPUT_DIRECTION.get(), (Player)player, (MenuHostLocator)locator);
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof OutputDirectionMenu) {
            OutputDirectionMenu cca = (OutputDirectionMenu)abstractContainerMenu;
            cca.setAllowedOutputs(allowedOutputs);
            cca.broadcastChanges();
        }
    }

    public ItemStack getAdjacentBlock(RelativeSide side) {
        Direction dir = this.host.getOrientation().getSide(side);
        BlockPos blockPos = this.host.getBlockPos().relative(dir);
        Level level = this.getLevel();
        if (level == null) {
            return null;
        }
        BlockState blockState = level.getBlockState(blockPos);
        if (!blockState.isAir()) {
            return blockState.getCloneItemStack((HitResult)new BlockHitResult(blockPos.getCenter().relative(dir.getOpposite(), 0.5), dir.getOpposite(), blockPos, false), (LevelReader)level, blockPos, this.getPlayerInventory().player);
        }
        return ItemStack.EMPTY;
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (this.isServerSide()) {
            AAENetworkHandler.INSTANCE.sendTo(new OutputDirectionClientUpdatePacket(this.allowedOutputs), (ServerPlayer)this.getPlayer());
        }
    }

    public Level getLevel() {
        return this.getPlayerInventory().player.level();
    }

    private void setAllowedOutputs(EnumSet<RelativeSide> allowedOutputs) {
        this.allowedOutputs = allowedOutputs.clone();
    }

    public void clearSides() {
        if (this.isClientSide()) {
            this.sendClientAction(CLEAR);
            return;
        }
        this.allowedOutputs.clear();
        this.getHost().updateOutputSides(this.allowedOutputs);
    }

    public void updateSideStatus(RelativeSide side) {
        if (this.isClientSide()) {
            AAENetworkHandler.INSTANCE.sendToServer(new UpdateSideStatusPacket(side));
            return;
        }
        if (this.allowedOutputs.contains(side)) {
            this.allowedOutputs.remove(side);
        } else {
            this.allowedOutputs.add(side);
        }
        this.getHost().updateOutputSides(this.allowedOutputs);
        AAENetworkHandler.INSTANCE.sendTo(new OutputDirectionClientUpdatePacket(this.allowedOutputs), (ServerPlayer)this.getPlayer());
    }
}

