/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.gui;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.crafting.pattern.AEProcessingPattern;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.slot.OutputSlot;
import appeng.menu.slot.RestrictedInputSlot;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.inventory.AdvPatternEncoderHost;
import net.pedroksl.advanced_ae.common.patterns.AdvPatternDetailsEncoder;
import net.pedroksl.advanced_ae.common.patterns.AdvProcessingPattern;
import net.pedroksl.advanced_ae.network.AAENetworkHandler;
import net.pedroksl.advanced_ae.network.packet.AdvPatternEncoderPacket;

public class AdvPatternEncoderMenu
extends AEBaseMenu {
    private final RestrictedInputSlot inputSlot;
    private final OutputSlot outputSlot;
    private final AdvPatternEncoderHost host;

    public AdvPatternEncoderMenu(int id, Inventory playerInventory, AdvPatternEncoderHost host) {
        super(AAEMenus.ADV_PATTERN_ENCODER.get(), id, playerInventory, (Object)host);
        this.createPlayerInventorySlots(playerInventory);
        this.host = host;
        this.inputSlot = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.ENCODED_PATTERN, (InternalInventory)host.getInventory(), 0);
        this.addSlot((Slot)this.inputSlot, SlotSemantics.ENCODED_PATTERN);
        this.outputSlot = new OutputSlot((InternalInventory)host.getInventory(), 1, null);
        this.addSlot((Slot)this.outputSlot, SlotSemantics.MACHINE_OUTPUT);
        this.host.setInventoryChangedHandler(this::onChangeInventory);
        if (this.inputSlot.hasItem()) {
            this.decodeInputPattern();
        }
    }

    public void onUpdateRequested() {
        if (this.inputSlot.hasItem()) {
            this.decodeInputPattern();
        }
    }

    public void onChangeInventory(InternalInventory inv, int slot) {
        if (inv == this.host.getInventory()) {
            if (slot == 0) {
                if (this.inputSlot.hasItem()) {
                    this.decodeInputPattern();
                } else if (!this.inputSlot.hasItem()) {
                    this.clearDecodedPattern();
                    this.outputSlot.set(ItemStack.EMPTY);
                }
            } else if (slot == 1 && !this.outputSlot.hasItem()) {
                this.clearDecodedPattern();
                this.inputSlot.set(ItemStack.EMPTY);
            }
        }
    }

    private void decodeInputPattern() {
        ItemStack stack = this.inputSlot.getItem();
        IPatternDetails details = PatternDetailsHelper.decodePattern((ItemStack)stack, (Level)this.getPlayer().level());
        if (details == null) {
            return;
        }
        LinkedHashMap<AEKey, Direction> dirMap = new LinkedHashMap();
        if (details instanceof AEProcessingPattern) {
            AEProcessingPattern processingPattern = (AEProcessingPattern)details;
            dirMap = this.decodeProcessingPattern(processingPattern);
        } else if (details instanceof AdvProcessingPattern) {
            AdvProcessingPattern advProcessingPattern = (AdvProcessingPattern)details;
            dirMap = this.decodeAdvProcessingPattern(advProcessingPattern);
        }
        Player player = this.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            AAENetworkHandler.INSTANCE.sendTo(new AdvPatternEncoderPacket(dirMap), sp);
        }
    }

    private LinkedHashMap<AEKey, Direction> decodeProcessingPattern(AEProcessingPattern pattern) {
        List sparseInputs = pattern.getSparseInputs();
        LinkedHashMap<AEKey, Direction> inputMap = new LinkedHashMap<AEKey, Direction>();
        for (GenericStack input : sparseInputs) {
            if (input == null || inputMap.containsKey(input.what())) continue;
            inputMap.put(input.what(), null);
        }
        ItemStack newAdvPattern = AdvPatternDetailsEncoder.encodeProcessingPattern(pattern.getSparseInputs(), pattern.getSparseOutputs(), inputMap);
        this.outputSlot.set(newAdvPattern);
        return inputMap;
    }

    private LinkedHashMap<AEKey, Direction> decodeAdvProcessingPattern(AdvProcessingPattern pattern) {
        this.outputSlot.set(this.inputSlot.getItem().copy());
        return pattern.getDirectionMap();
    }

    private void clearDecodedPattern() {
        Player player = this.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            AAENetworkHandler.INSTANCE.sendTo(new AdvPatternEncoderPacket(), sp);
        }
    }

    public void update(AEKey key, Direction dir) {
        AdvProcessingPattern details;
        if (!this.outputSlot.hasItem()) {
            this.copyItemToOutputSlot();
        }
        if ((details = (AdvProcessingPattern)PatternDetailsHelper.decodePattern((ItemStack)this.outputSlot.getItem(), (Level)this.getPlayer().level())) != null) {
            HashMap dirMap = details.getDirectionMap();
            dirMap.put(key, dir);
            ItemStack newPattern = AdvPatternDetailsEncoder.encodeProcessingPattern(details.getSparseInputs(), details.getSparseOutputs(), dirMap);
            this.outputSlot.set(newPattern);
            Player player = this.getPlayer();
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                AAENetworkHandler.INSTANCE.sendTo(new AdvPatternEncoderPacket((LinkedHashMap<AEKey, Direction>)dirMap), sp);
            }
        }
    }

    public void copyItemToOutputSlot() {
        ItemStack stack = this.inputSlot.getItem();
        IPatternDetails details = PatternDetailsHelper.decodePattern((ItemStack)stack, (Level)this.getPlayer().level());
        if (details == null) {
            return;
        }
        if (details instanceof AEProcessingPattern) {
            AEProcessingPattern processingPattern = (AEProcessingPattern)details;
            this.decodeProcessingPattern(processingPattern);
        } else if (details instanceof AdvProcessingPattern) {
            AdvProcessingPattern advProcessingPattern = (AdvProcessingPattern)details;
            this.decodeAdvProcessingPattern(advProcessingPattern);
        }
    }

    public AdvPatternEncoderHost getHost() {
        return this.host;
    }

    public static interface InventoryChangedHandler {
        public void handleChange(InternalInventory var1, int var2);
    }
}

