/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.events;

import appeng.api.config.Actionable;
import java.util.Random;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;
import net.neoforged.neoforge.event.entity.living.LivingBreatheEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.pedroksl.advanced_ae.common.definitions.AAEConfig;
import net.pedroksl.advanced_ae.common.items.armors.QuantumArmorBase;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;

public class AAELivingEntityEvents {
    @SubscribeEvent
    public static void invulnerability(EntityInvulnerabilityCheckEvent event) {
        Entity target = event.getEntity();
        if (target instanceof Player) {
            Random randomGenerator;
            double chance;
            QuantumArmorBase item;
            ItemStack bootStack;
            Item item2;
            QuantumArmorBase item3;
            Player player = (Player)target;
            ItemStack chestStack = player.getItemBySlot(EquipmentSlot.CHEST);
            Item item4 = chestStack.getItem();
            if (item4 instanceof QuantumArmorBase && (item3 = (QuantumArmorBase)item4).isUpgradeEnabledAndPowered(chestStack, UpgradeType.LAVA_IMMUNITY) && (event.getSource().is(DamageTypes.LAVA) || event.getSource().is(DamageTypes.IN_FIRE) || event.getSource().is(DamageTypes.ON_FIRE))) {
                player.setRemainingFireTicks(0);
                event.setInvulnerable(true);
                item3.consumeEnergy(player, chestStack, UpgradeType.LAVA_IMMUNITY);
            }
            if ((item2 = (bootStack = player.getItemBySlot(EquipmentSlot.FEET)).getItem()) instanceof QuantumArmorBase && (item = (QuantumArmorBase)item2).isUpgradeEnabledAndPowered(bootStack, UpgradeType.EVASION) && (chance = (randomGenerator = new Random()).nextDouble(100.0)) < (double)AAEConfig.instance().getEvasionChance()) {
                event.setInvulnerable(true);
                item.consumeEnergy(player, bootStack, UpgradeType.EVASION);
            }
        }
    }

    @SubscribeEvent
    public static void incomingDamage(LivingIncomingDamageEvent event) {
        LivingEntity target = event.getEntity();
        if (target.isAlive() && event.getAmount() > 0.0f && target instanceof Player) {
            Player player = (Player)target;
            float maxAbsorption = event.getAmount() * (float)AAEConfig.instance().getPercentageDamageAbsorption() / 100.0f;
            float amountPerPiece = maxAbsorption / 4.0f;
            float absorbed = 0.0f;
            for (ItemStack stack : player.getArmorSlots()) {
                Item item;
                if (stack == null || stack.isEmpty() || !((item = stack.getItem()) instanceof QuantumArmorBase)) continue;
                QuantumArmorBase item2 = (QuantumArmorBase)item;
                double extracted = item2.extractAEPower(stack, amountPerPiece * 1000.0f, Actionable.MODULATE);
                absorbed += (float)extracted / 1000.0f;
            }
            if (absorbed > 0.0f) {
                event.setAmount(Math.max(0.0f, event.getAmount() - absorbed));
            }
            if (event.getAmount() < 1.0f) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void breath(LivingBreatheEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            QuantumArmorBase item;
            Level level;
            Player player = (Player)livingEntity;
            ItemStack stack = player.getItemBySlot(EquipmentSlot.HEAD);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                level = serverPlayer.level();
            } else {
                level = null;
            }
            Level level2 = level;
            Item item2 = stack.getItem();
            if (item2 instanceof QuantumArmorBase && (item = (QuantumArmorBase)item2).isUpgradeEnabledAndPowered(stack, UpgradeType.WATER_BREATHING, level2)) {
                event.setCanBreathe(true);
                item.consumeEnergy(player, stack, UpgradeType.WATER_BREATHING);
            }
        }
    }

    @SubscribeEvent
    public static void jumpEvent(LivingEvent.LivingJumpEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            QuantumArmorBase item;
            Level level;
            Player player = (Player)livingEntity;
            ItemStack stack = player.getItemBySlot(EquipmentSlot.FEET);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                level = serverPlayer.level();
            } else {
                level = null;
            }
            Level level2 = level;
            Item item2 = stack.getItem();
            if (item2 instanceof QuantumArmorBase && (item = (QuantumArmorBase)item2).isUpgradeEnabledAndPowered(stack, UpgradeType.JUMP_HEIGHT, level2)) {
                UpgradeType.JUMP_HEIGHT.ability.execute(player.level(), player, stack);
                item.consumeEnergy(player, stack, UpgradeType.JUMP_HEIGHT);
            }
        }
    }

    @SubscribeEvent
    public static void LivingFallDamage(LivingFallEvent event) {
        QuantumArmorBase item;
        ServerPlayer player;
        ItemStack stack;
        Item item2;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && (item2 = (stack = (player = (ServerPlayer)livingEntity).getItemBySlot(EquipmentSlot.FEET)).getItem()) instanceof QuantumArmorBase && (item = (QuantumArmorBase)item2).extractAEPower(stack, 10.0, Actionable.SIMULATE) > 0.0) {
            event.setDistance(0.0f);
        }
    }
}

