/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.patterns;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.crafting.PatternDetailsTooltip;
import appeng.api.ids.AEComponents;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.crafting.pattern.AEProcessingPattern;
import appeng.crafting.pattern.EncodedProcessingPattern;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.pedroksl.advanced_ae.common.definitions.AAEComponents;
import net.pedroksl.advanced_ae.common.helpers.NullableDirection;
import net.pedroksl.advanced_ae.common.patterns.EncodedAdvProcessingPattern;
import net.pedroksl.advanced_ae.common.patterns.IAdvPatternDetails;

public class AdvProcessingPattern
implements IPatternDetails,
IAdvPatternDetails {
    private final AEItemKey definition;
    private final List<GenericStack> sparseInputs;
    private final List<GenericStack> sparseOutputs;
    private final Input[] inputs;
    private final List<GenericStack> condensedOutputs;
    private final LinkedHashMap<AEKey, Direction> dirMap = new LinkedHashMap();

    public AdvProcessingPattern(AEItemKey definition) {
        this.definition = definition;
        EncodedAdvProcessingPattern encodedPattern = (EncodedAdvProcessingPattern)definition.get(AAEComponents.ENCODED_ADV_PROCESSING_PATTERN);
        if (encodedPattern == null) {
            throw new IllegalArgumentException("Given item does not encode an advanced processing pattern: " + String.valueOf(definition));
        }
        if (encodedPattern.containsMissingContent()) {
            throw new IllegalArgumentException("Pattern references missing content");
        }
        this.sparseInputs = encodedPattern.sparseInputs();
        this.sparseOutputs = encodedPattern.sparseOutputs();
        List<GenericStack> condensedInputs = AdvProcessingPattern.condenseStacks(this.sparseInputs);
        this.inputs = new Input[condensedInputs.size()];
        for (int i = 0; i < this.inputs.length; ++i) {
            this.inputs[i] = new Input(condensedInputs.get(i));
        }
        this.condensedOutputs = AdvProcessingPattern.condenseStacks(this.sparseOutputs);
        List<GenericStack> inputs = encodedPattern.sparseInputs();
        List<NullableDirection> directions = encodedPattern.directionList();
        for (int x = 0; x < inputs.size(); ++x) {
            GenericStack input = inputs.get(x);
            NullableDirection direction = directions.get(x);
            if (input == null) continue;
            this.dirMap.put(input.what(), direction.getDirection());
        }
    }

    public static void encode(ItemStack stack, List<GenericStack> sparseInputs, List<GenericStack> sparseOutputs, @Nullable HashMap<AEKey, Direction> dirMap) {
        if (sparseInputs.stream().noneMatch(Objects::nonNull)) {
            throw new IllegalArgumentException("At least one input must be non-null.");
        }
        Objects.requireNonNull(sparseOutputs.getFirst(), "The first (primary) output must be non-null.");
        NullableDirection[] nullDirArray = new NullableDirection[sparseInputs.size()];
        Arrays.fill((Object[])nullDirArray, (Object)NullableDirection.NULLDIR);
        List<NullableDirection> directionList = Arrays.asList(nullDirArray);
        if (dirMap != null) {
            for (int x = 0; x < sparseInputs.size(); ++x) {
                GenericStack input = sparseInputs.get(x);
                if (input == null) continue;
                directionList.set(x, NullableDirection.fromDirection(dirMap.get(input.what())));
            }
        }
        stack.set(AAEComponents.ENCODED_ADV_PROCESSING_PATTERN, (Object)new EncodedAdvProcessingPattern(sparseInputs, sparseOutputs, directionList));
    }

    public AEProcessingPattern getAEProcessingPattern(Level level) {
        ItemStack stack = PatternDetailsHelper.encodeProcessingPattern(this.getSparseInputs(), this.getSparseOutputs());
        if (stack == null) {
            return null;
        }
        IPatternDetails pattern = PatternDetailsHelper.decodePattern((ItemStack)stack, (Level)level);
        if (!(pattern instanceof AEProcessingPattern)) {
            return null;
        }
        AEProcessingPattern aePattern = (AEProcessingPattern)pattern;
        return aePattern;
    }

    public int hashCode() {
        return this.definition.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && ((AdvProcessingPattern)obj).definition.equals((Object)this.definition);
    }

    public AEItemKey getDefinition() {
        return this.definition;
    }

    public IPatternDetails.IInput[] getInputs() {
        return this.inputs;
    }

    public List<GenericStack> getOutputs() {
        return this.condensedOutputs;
    }

    public List<GenericStack> getSparseInputs() {
        return this.sparseInputs;
    }

    public List<GenericStack> getSparseOutputs() {
        return this.sparseOutputs;
    }

    public LinkedHashMap<AEKey, Direction> getDirectionMap() {
        return this.dirMap;
    }

    @Override
    public boolean directionalInputsSet() {
        return !this.dirMap.isEmpty();
    }

    @Override
    public Direction getDirectionSideForInputKey(AEKey key) {
        return this.dirMap.get(key);
    }

    @Override
    public void pushInputsToExternalInventory(KeyCounter[] inputHolder, IPatternDetails.PatternInputSink inputSink) {
        if (this.sparseInputs.size() == this.inputs.length) {
            super.pushInputsToExternalInventory(inputHolder, inputSink);
            return;
        }
        KeyCounter allInputs = new KeyCounter();
        for (KeyCounter counter : inputHolder) {
            allInputs.addAll(counter);
        }
        for (GenericStack sparseInput : this.sparseInputs) {
            if (sparseInput == null) continue;
            AEKey key = sparseInput.what();
            long amount = sparseInput.amount();
            long available = allInputs.get(key);
            if (available < amount) {
                throw new RuntimeException("Expected at least %d of %s when pushing pattern, but only %d available".formatted(amount, key, available));
            }
            inputSink.pushInput(key, amount);
            allInputs.remove(key, amount);
        }
    }

    public static PatternDetailsTooltip getInvalidPatternTooltip(ItemStack stack, Level level, @Nullable Exception cause, TooltipFlag flags) {
        PatternDetailsTooltip tooltip = new PatternDetailsTooltip(PatternDetailsTooltip.OUTPUT_TEXT_PRODUCES);
        EncodedProcessingPattern encodedPattern = (EncodedProcessingPattern)stack.get(AEComponents.ENCODED_PROCESSING_PATTERN);
        if (encodedPattern != null) {
            encodedPattern.sparseInputs().stream().filter(Objects::nonNull).forEach(arg_0 -> ((PatternDetailsTooltip)tooltip).addInput(arg_0));
            encodedPattern.sparseOutputs().stream().filter(Objects::nonNull).forEach(arg_0 -> ((PatternDetailsTooltip)tooltip).addOutput(arg_0));
        }
        return tooltip;
    }

    private static ListTag encodeStackList(GenericStack[] stacks, HolderLookup.Provider registries) {
        ListTag tag = new ListTag();
        boolean foundStack = false;
        for (GenericStack stack : stacks) {
            tag.add((Object)GenericStack.writeTag((HolderLookup.Provider)registries, (GenericStack)stack));
            if (stack == null || stack.amount() <= 0L) continue;
            foundStack = true;
        }
        Preconditions.checkArgument((boolean)foundStack, (Object)"List passed to pattern must contain at least one stack.");
        return tag;
    }

    private static List<GenericStack> condenseStacks(List<GenericStack> sparseInput) {
        LinkedHashMap<AEKey, Long> map = new LinkedHashMap<AEKey, Long>();
        for (GenericStack input : sparseInput) {
            if (input == null) continue;
            map.merge(input.what(), input.amount(), Long::sum);
        }
        if (map.isEmpty()) {
            throw new IllegalStateException("No pattern here!");
        }
        ArrayList<GenericStack> out = new ArrayList<GenericStack>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            out.add(new GenericStack((AEKey)entry.getKey(), ((Long)entry.getValue()).longValue()));
        }
        return out;
    }

    private static class Input
    implements IPatternDetails.IInput {
        private final GenericStack[] template;
        private final long multiplier;

        private Input(GenericStack stack) {
            this.template = new GenericStack[]{new GenericStack(stack.what(), 1L)};
            this.multiplier = stack.amount();
        }

        public GenericStack[] getPossibleInputs() {
            return this.template;
        }

        public long getMultiplier() {
            return this.multiplier;
        }

        public boolean isValid(AEKey input, Level level) {
            return input.matches(this.template[0]);
        }

        @Nullable
        public AEKey getRemainingKey(AEKey template) {
            return null;
        }
    }
}

