/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.helpers;

import appeng.api.AECapabilities;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.me.storage.ExternalStorageFacade;
import appeng.parts.automation.HandlerStrategy;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;

public class SimulatedStorageImportStrategy<T, S> {
    private final BlockCapabilityCache<T, Direction> cache;
    private final BlockCapabilityCache<MEStorage, Direction> meCache;
    private final HandlerStrategy<T, S> conversion;

    public SimulatedStorageImportStrategy(BlockCapability<T, Direction> capability, HandlerStrategy<T, S> conversion, ServerLevel level, BlockPos fromPos, Direction fromSide) {
        this.cache = BlockCapabilityCache.create(capability, (ServerLevel)level, (BlockPos)fromPos, (Object)fromSide);
        this.meCache = BlockCapabilityCache.create((BlockCapability)AECapabilities.ME_STORAGE, (ServerLevel)level, (BlockPos)fromPos, (Object)fromSide);
        this.conversion = conversion;
    }

    public long simulateTransfer(AEKey what, long toImport, IActionSource src) {
        KeyCounter keys;
        if (what.getType() != this.conversion.getKeyType()) {
            return 0L;
        }
        MEStorage meHandler = (MEStorage)this.meCache.getCapability();
        if (meHandler != null && (keys = meHandler.getAvailableStacks()).get(what) > 0L) {
            return keys.get(what);
        }
        Object adjacentHandler = this.cache.getCapability();
        if (adjacentHandler == null) {
            return 0L;
        }
        ExternalStorageFacade adjacentStorage = this.conversion.getFacade(adjacentHandler);
        long amount = adjacentStorage.extract(what, toImport, Actionable.SIMULATE, src);
        if (amount == 0L && adjacentStorage.containsAnyFuzzy(Set.of(what))) {
            KeyCounter stacks = adjacentStorage.getAvailableStacks();
            amount = stacks.get(what);
        }
        return Math.max(0L, amount);
    }
}

