/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.entities;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.ids.AEComponents;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.inventories.ItemTransfer;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.RelativeSide;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.blockentity.grid.AENetworkedPoweredBlockEntity;
import appeng.core.AELog;
import appeng.core.definitions.AEItems;
import appeng.core.localization.PlayerMessages;
import appeng.crafting.pattern.AECraftingPattern;
import appeng.me.helpers.MachineSource;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import appeng.util.SettingsFrom;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.CombinedInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.PlayerInternalInventory;
import appeng.util.inv.filter.AEItemFilters;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.pedroksl.advanced_ae.api.AAESettings;
import net.pedroksl.advanced_ae.api.IDirectionalOutputHost;
import net.pedroksl.advanced_ae.common.blocks.QuantumCrafterBlock;
import net.pedroksl.advanced_ae.common.definitions.AAEBlocks;
import net.pedroksl.advanced_ae.common.definitions.AAEComponents;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.entities.ReactionChamberEntity;
import org.jetbrains.annotations.Nullable;

public class QuantumCrafterEntity
extends AENetworkedPoweredBlockEntity
implements IGridTickable,
IUpgradeableObject,
IConfigurableObject,
IDirectionalOutputHost {
    private static final int PATTERN_SLOTS = 9;
    private static final int MAX_POWER_STORAGE = 8000;
    private static final int MAX_CRAFT_AMOUNT = 1024;
    private static final int MAX_OUTPUT_INV_SIZE = 1024;
    public static final String NBT_SEND_LIST = "sendList";
    private final IUpgradeInventory upgrades;
    private final IConfigManager configManager;
    private final AppEngInternalInventory patternInv = new AppEngInternalInventory((InternalInventoryHost)this, 9, 1);
    private final AppEngInternalInventory outputInv = new AppEngInternalInventory((InternalInventoryHost)this, 18, 1024);
    private final InternalInventory inv = new CombinedInternalInventory(new InternalInventory[]{this.patternInv, this.outputInv});
    private final FilteredInternalInventory inputExposed = new FilteredInternalInventory((InternalInventory)this.patternInv, AEItemFilters.INSERT_ONLY);
    private final FilteredInternalInventory outputExposed = new FilteredInternalInventory((InternalInventory)this.outputInv, AEItemFilters.EXTRACT_ONLY);
    private final InternalInventory invExposed = new CombinedInternalInventory(new InternalInventory[]{this.inputExposed, this.outputExposed});
    private boolean initialized = false;
    private boolean working = false;
    private YesNo lastRedstoneState;
    private final List<GenericStack> sendList = new ArrayList<GenericStack>();
    private final IActionSource mySrc;
    private boolean isActive = false;
    private final List<CraftingJob> craftingJobs = Arrays.asList(new CraftingJob[9]);
    private EnumSet<RelativeSide> allowedOutputs = EnumSet.allOf(RelativeSide.class);
    private final List<Boolean> invalidPatternSlots = Arrays.asList(new Boolean[9]);
    private final List<Boolean> enabledPatternSlots = Arrays.asList(new Boolean[9]);

    public QuantumCrafterEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        this.getMainNode().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL}).setIdlePowerUsage(0.0).addService(IGridTickable.class, (IGridNodeService)this);
        this.setInternalMaxPower(8000.0);
        this.upgrades = UpgradeInventories.forMachine(AAEBlocks.QUANTUM_CRAFTER, (int)5, () -> ((QuantumCrafterEntity)this).saveChanges());
        this.configManager = IConfigManager.builder(this::onConfigChanged).registerSetting(AAESettings.ME_EXPORT, (Enum)YesNo.YES).registerSetting(Settings.REDSTONE_CONTROLLED, (Enum)RedstoneMode.IGNORE).build();
        this.setPowerSides(this.getGridConnectableSides(this.getOrientation()));
        this.mySrc = new MachineSource((IActionHost)this);
        this.lastRedstoneState = YesNo.UNDECIDED;
        Collections.fill(this.invalidPatternSlots, false);
        Collections.fill(this.enabledPatternSlots, false);
    }

    public boolean isWorking() {
        return this.working;
    }

    public void setWorking(boolean working) {
        if (working != this.working) {
            this.updateBlockState(working);
            this.markForUpdate();
        }
        this.working = working;
    }

    private void updateBlockState(boolean working) {
        BlockState newState;
        if (this.level == null || this.notLoaded() || this.isRemoved()) {
            return;
        }
        BlockState current = this.level.getBlockState(this.worldPosition);
        if (current.getBlock() instanceof QuantumCrafterBlock && current != (newState = (BlockState)current.setValue((Property)QuantumCrafterBlock.WORKING, (Comparable)Boolean.valueOf(working)))) {
            this.level.setBlock(this.worldPosition, newState, 2);
        }
    }

    protected void saveVisualState(CompoundTag data) {
        super.saveVisualState(data);
        data.putBoolean("working", this.isWorking());
    }

    protected void loadVisualState(CompoundTag data) {
        super.loadVisualState(data);
        this.setWorking(data.getBoolean("working"));
    }

    public Set<Direction> getGridConnectableSides(BlockOrientation orientation) {
        return EnumSet.allOf(Direction.class);
    }

    public InternalInventory getPatternInventory() {
        return this.patternInv;
    }

    public InternalInventory getOutputInv() {
        return this.outputInv;
    }

    public InternalInventory getInternalInventory() {
        return this.inv;
    }

    @Nullable
    public InternalInventory getSubInventory(ResourceLocation id) {
        if (id.equals((Object)ISegmentedInventory.STORAGE)) {
            return this.getInternalInventory();
        }
        if (id.equals((Object)ISegmentedInventory.UPGRADES)) {
            return this.upgrades;
        }
        return super.getSubInventory(id);
    }

    protected InternalInventory getExposedInventoryForSide(Direction facing) {
        return this.invExposed;
    }

    public IUpgradeInventory getUpgrades() {
        return this.upgrades;
    }

    public void onChangeInventory(AppEngInternalInventory inv, int slot) {
        if (inv == this.patternInv) {
            this.makeCraftingRecipeList();
        }
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
    }

    private void makeCraftingRecipeList() {
        for (int x = 0; x < this.patternInv.size(); ++x) {
            boolean success = false;
            ItemStack is = this.patternInv.getStackInSlot(x);
            if (!is.isEmpty()) {
                IPatternDetails details = PatternDetailsHelper.decodePattern((ItemStack)is, (Level)this.getLevel());
                if (details instanceof AECraftingPattern) {
                    AECraftingPattern craftPattern = (AECraftingPattern)details;
                    if (this.craftingJobs.get(x) != null) {
                        if (this.craftingJobs.get((int)x).pattern == null) {
                            this.craftingJobs.get(x).setPattern(craftPattern);
                            this.setInvalidPattern(x, this.craftingJobs.get((int)x).consumesDurability);
                            continue;
                        }
                        if (this.craftingJobs.get((int)x).pattern.equals((Object)craftPattern)) {
                            this.setInvalidPattern(x, this.craftingJobs.get((int)x).consumesDurability);
                            continue;
                        }
                    }
                    CraftingJob newJob = new CraftingJob(craftPattern);
                    this.craftingJobs.set(x, newJob);
                    this.setInvalidPattern(x, newJob.consumesDurability);
                    success = true;
                }
            } else {
                this.setInvalidPattern(x, false);
            }
            if (success) continue;
            this.craftingJobs.set(x, null);
        }
    }

    private boolean hasAutoExportWork() {
        if (!this.sendList.isEmpty()) {
            return true;
        }
        for (int x = 0; x < this.outputInv.size(); ++x) {
            if (this.outputInv.getStackInSlot(x).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean isExportToMe() {
        return this.configManager.getSetting(AAESettings.ME_EXPORT) == YesNo.YES;
    }

    private boolean hasWork() {
        if (!this.initialized) {
            this.makeCraftingRecipeList();
            this.initialized = true;
        }
        if (this.isEnabled()) {
            return !this.patternInv.isEmpty();
        }
        this.setWorking(false);
        return false;
    }

    private boolean hasCraftWork() {
        if (!this.initialized) {
            this.makeCraftingRecipeList();
            this.initialized = true;
        }
        if (!this.isEnabled()) {
            return false;
        }
        for (int x = 0; x < this.craftingJobs.size(); ++x) {
            CraftingJob job = this.craftingJobs.get(x);
            if (job == null || job.pattern == null || this.invalidPatternSlots.get(x).booleanValue() || !this.enabledPatternSlots.get(x).booleanValue() || this.maximumCraftableAmount(job) <= 0 || !this.hasAvailableOutputStorage(job)) continue;
            return true;
        }
        return false;
    }

    private int maximumCraftableAmount(CraftingJob job) {
        if (this.getGridNode() == null) {
            return 0;
        }
        if (job == null || job.pattern == null) {
            return 0;
        }
        IPatternDetails.IInput[] inputs = job.pattern.getInputs();
        List outputs = job.pattern.getOutputs();
        IGrid grid = this.getGridNode().getGrid();
        int totalCrafts = 1024;
        for (IPatternDetails.IInput input : inputs) {
            long minStock = job.minimumInputToKeep(input);
            boolean success = false;
            for (GenericStack genInput : input.getPossibleInputs()) {
                long inputAmount = input.getMultiplier() * genInput.amount();
                long toExtract = job.requiredInputTotal(genInput, totalCrafts);
                if (job.isInputConsumed(genInput)) {
                    toExtract += minStock;
                }
                long extracted = grid.getStorageService().getInventory().extract(genInput.what(), toExtract, Actionable.SIMULATE, this.mySrc);
                if (!job.isInputConsumed(genInput) && extracted >= toExtract) {
                    success = true;
                    break;
                }
                if (extracted <= minStock) continue;
                success = true;
                if (extracted > Integer.MAX_VALUE) {
                    extracted = Integer.MAX_VALUE;
                }
                int possibleCrafts = (int)Math.floor((double)(extracted - minStock) / (double)inputAmount);
                totalCrafts = Math.min(possibleCrafts, totalCrafts);
                break;
            }
            if (success) continue;
            return 0;
        }
        GenericStack output = (GenericStack)outputs.getFirst();
        long maxStock = job.limitMaxOutput;
        if (maxStock > 0L) {
            long extracted = grid.getStorageService().getInventory().extract(output.what(), maxStock, Actionable.SIMULATE, this.mySrc);
            int amountInOutput = 0;
            for (int x = 0; x < this.outputInv.size(); ++x) {
                ItemStack stack = this.outputInv.getStackInSlot(x);
                if (!stack.is(output.what().wrapForDisplayOrFilter().getItem())) continue;
                amountInOutput += stack.getCount();
            }
            long producedAmount = job.outputAmountPerCraft(output);
            int limitByOutput = (int)Math.floor((double)(maxStock - extracted - (long)amountInOutput) / (double)producedAmount);
            totalCrafts = Math.max(0, Math.min(totalCrafts, limitByOutput));
            if (extracted <= maxStock) {
                return totalCrafts;
            }
            return (int)Math.floor((double)extracted / (double)output.amount());
        }
        return totalCrafts;
    }

    private boolean hasAvailableOutputStorage(CraftingJob job) {
        for (GenericStack output : job.pattern.getOutputs()) {
            AEKey aEKey = output.what();
            if (!(aEKey instanceof AEItemKey)) continue;
            AEItemKey key = (AEItemKey)aEKey;
            ItemStack stack = key.toStack((int)output.amount());
            for (int x = 0; x < this.outputInv.size() && !(stack = this.outputInv.insertItem(x, stack, true)).isEmpty(); ++x) {
            }
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public TickingRequest getTickingRequest(IGridNode iGridNode) {
        return new TickingRequest(1, 20, !this.hasWork());
    }

    public TickRateModulation tickingRequest(IGridNode iGridNode, int i) {
        if (!this.getMainNode().isActive()) {
            this.setWorking(false);
            return TickRateModulation.IDLE;
        }
        if (this.hasCraftWork()) {
            int speedFactor = switch (this.upgrades.getInstalledUpgrades((ItemLike)AEItems.SPEED_CARD)) {
                default -> 1;
                case 1 -> 8;
                case 2 -> 16;
                case 3 -> 32;
                case 4 -> 64;
            };
            this.setWorking(true);
            this.getMainNode().ifPresent(grid -> {
                IEnergyService eg = grid.getEnergyService();
                QuantumCrafterEntity src = this;
                int powerConsumption = 10 * speedFactor;
                double powerThreshold = (double)powerConsumption - 0.01;
                double powerReq = this.extractAEPower(powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
                if (powerReq <= powerThreshold) {
                    src = eg;
                    powerReq = eg.extractAEPower((double)powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
                }
                if (powerReq > powerThreshold) {
                    src.extractAEPower(powerConsumption, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    this.performCrafts(speedFactor);
                }
            });
        } else {
            this.setWorking(false);
        }
        if (this.pushOutResult()) {
            return TickRateModulation.URGENT;
        }
        return this.hasCraftWork() ? TickRateModulation.URGENT : (this.hasAutoExportWork() ? TickRateModulation.SLOWER : TickRateModulation.IDLE);
    }

    private void performCrafts(int maxCrafts) {
        for (int x = 0; x < this.craftingJobs.size(); ++x) {
            CraftingJob job = this.getNextJob(x);
            if (job == null || this.invalidPatternSlots.get(x).booleanValue() || !this.enabledPatternSlots.get(x).booleanValue()) continue;
            int craftAmount = this.maximumCraftableAmount(job);
            int toCraft = Math.min(craftAmount, maxCrafts);
            this.performCraft(job, toCraft);
        }
    }

    private void performCraft(CraftingJob job, int toCraft) {
        if (this.getGridNode() == null) {
            return;
        }
        if (job == null || job.pattern == null) {
            return;
        }
        IPatternDetails.IInput[] inputs = job.pattern.getInputs();
        List outputs = job.pattern.getOutputs();
        ArrayList<Long> requiredPerCraft = new ArrayList<Long>();
        ArrayList<GenericStack> extractedItems = new ArrayList<GenericStack>();
        IGrid grid = this.getGridNode().getGrid();
        IEnergyService energy = grid.getEnergyService();
        IStorageService storage = grid.getStorageService();
        block0: for (IPatternDetails.IInput input : inputs) {
            for (GenericStack genInput : input.getPossibleInputs()) {
                long inputAmount = input.getMultiplier() * genInput.amount();
                long toExtract = job.requiredInputTotal(genInput, toCraft);
                long extracted = StorageHelper.poweredExtraction((IEnergySource)energy, (MEStorage)storage.getInventory(), (AEKey)genInput.what(), (long)toExtract, (IActionSource)this.mySrc);
                if (extracted < inputAmount) continue;
                requiredPerCraft.add(inputAmount);
                extractedItems.add(new GenericStack(genInput.what(), extracted));
                continue block0;
            }
        }
        int completeRecipes = extractedItems.size() == inputs.length ? toCraft : 0;
        for (int x = 0; x < extractedItems.size(); ++x) {
            if (!job.isInputConsumed((GenericStack)extractedItems.get(x))) continue;
            Long required = (Long)requiredPerCraft.get(x);
            long extracted = ((GenericStack)extractedItems.get(x)).amount();
            int recipes = (int)(extracted / required);
            completeRecipes = Math.min(completeRecipes, recipes);
        }
        for (GenericStack output : outputs) {
            AEKey aEKey = output.what();
            if (!(aEKey instanceof AEItemKey)) continue;
            AEItemKey key = (AEItemKey)aEKey;
            ItemStack stack = key.toStack((int)output.amount());
            stack.setCount((int)job.outputAmountPerCraft(output) * completeRecipes);
            for (int x = 0; x < this.outputInv.size() && !(stack = this.outputInv.insertItem(x, stack, Actionable.MODULATE.isSimulate())).isEmpty(); ++x) {
            }
        }
        for (ItemStack stack : job.remainingItems) {
            ItemStack newStack = stack.copy();
            if (job.isStackAnInput(stack)) continue;
            newStack.setCount(stack.getCount() * completeRecipes);
            for (int x = 0; x < this.outputInv.size() && !(newStack = this.outputInv.insertItem(x, newStack, Actionable.MODULATE.isSimulate())).isEmpty(); ++x) {
            }
        }
        for (int x = 0; x < extractedItems.size(); ++x) {
            long successfulReturn;
            Long required = (Long)requiredPerCraft.get(x);
            GenericStack input = (GenericStack)extractedItems.get(x);
            long toReturn = input.amount();
            if (job.isInputConsumed(input)) {
                toReturn -= required * (long)completeRecipes;
            }
            if (toReturn <= 0L || (successfulReturn = storage.getInventory().insert(((GenericStack)extractedItems.get(x)).what(), toReturn, Actionable.MODULATE, this.mySrc)) >= toReturn) continue;
            this.sendList.add(new GenericStack(input.what(), toReturn - successfulReturn));
        }
    }

    @Nullable
    private CraftingJob getNextJob(int jobIndex) {
        try {
            CraftingJob job = this.craftingJobs.get(jobIndex);
            return job == null || job.pattern == null ? null : job;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    private void addToSendList(AEKey what, long amount) {
        if (amount > 0L) {
            this.sendList.add(new GenericStack(what, amount));
            this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().alertDevice(node));
        }
    }

    private boolean pushOutResult() {
        if (!this.hasAutoExportWork()) {
            return false;
        }
        boolean didSomething = false;
        if (!this.sendList.isEmpty()) {
            didSomething = this.exportSendList();
        }
        if (this.isExportToMe()) {
            return didSomething || this.exportToMe();
        }
        return didSomething || this.exportToAdjacentBlocks();
    }

    private boolean exportSendList() {
        if (this.getGridNode() == null) {
            return false;
        }
        IGrid grid = this.getGridNode().getGrid();
        IStorageService storage = grid.getStorageService();
        boolean didSomething = false;
        ListIterator<GenericStack> it = this.sendList.listIterator();
        while (it.hasNext()) {
            GenericStack stack = it.next();
            AEKey what = stack.what();
            long amount = stack.amount();
            long inserted = storage.getInventory().insert(what, amount, Actionable.MODULATE, this.mySrc);
            if (inserted >= amount) {
                it.remove();
                didSomething = true;
                continue;
            }
            if (inserted <= 0L) continue;
            it.set(new GenericStack(what, amount - inserted));
            didSomething = true;
        }
        return didSomething;
    }

    private boolean exportToMe() {
        if (this.getGridNode() == null) {
            return false;
        }
        IStorageService storage = this.getGridNode().getGrid().getStorageService();
        IEnergyService energy = this.getGridNode().getGrid().getEnergyService();
        MEStorage inventory = storage.getInventory();
        boolean success = false;
        for (int x = 0; x < this.outputInv.size(); ++x) {
            ItemStack extractStack = this.outputInv.extractItem(x, 1024, false);
            AEItemKey key = AEItemKey.of((ItemStack)extractStack);
            if (key == null) continue;
            long inserted = StorageHelper.poweredInsert((IEnergySource)energy, (MEStorage)inventory, (AEKey)key, (long)extractStack.getCount(), (IActionSource)this.mySrc);
            extractStack.setCount(extractStack.getCount() - (int)inserted);
            this.outputInv.insertItem(x, extractStack, false);
            if (inserted <= 0L) continue;
            success = true;
        }
        return success;
    }

    private boolean exportToAdjacentBlocks() {
        if (this.level == null) {
            return false;
        }
        BlockOrientation orientation = this.getOrientation();
        ArrayList<ItemTransfer> invMap = new ArrayList<ItemTransfer>();
        for (RelativeSide side : this.allowedOutputs) {
            ItemTransfer target;
            Direction dir = orientation.getSide(side);
            BlockPos targetPos = this.getBlockPos().relative(dir);
            BlockEntity te = this.level.getBlockEntity(targetPos);
            if (te instanceof ReactionChamberEntity || (target = InternalInventory.wrapExternal((Level)this.level, (BlockPos)this.getBlockPos().relative(dir), (Direction)dir.getOpposite())) == null) continue;
            invMap.add(target);
        }
        boolean success = false;
        for (int x = 0; x < this.outputInv.size(); ++x) {
            int endItems;
            int startItems = this.outputInv.getStackInSlot(x).getCount();
            for (ItemTransfer target : invMap) {
                this.outputInv.insertItem(x, target.addItems(this.outputInv.extractItem(x, 1024, false)), false);
                if (this.outputInv.getStackInSlot(x).getCount() != 0) continue;
                break;
            }
            if (startItems == (endItems = this.outputInv.getStackInSlot(x).getCount())) continue;
            success = true;
        }
        return success;
    }

    public IConfigManager getConfigManager() {
        return this.configManager;
    }

    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        super.addAdditionalDrops(level, pos, drops);
        for (ItemStack upgrade : this.upgrades) {
            drops.add(upgrade);
        }
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    public void saveAdditional(CompoundTag data, HolderLookup.Provider registries) {
        super.saveAdditional(data, registries);
        ListTag outputTags = new ListTag();
        for (RelativeSide relativeSide : this.allowedOutputs) {
            outputTags.add((Object)StringTag.valueOf((String)relativeSide.name()));
        }
        data.put("outputSides", (Tag)outputTags);
        ListTag invalidTags = new ListTag();
        for (Boolean bl : this.invalidPatternSlots) {
            invalidTags.add((Object)ByteTag.valueOf((boolean)bl));
        }
        data.put("invalidPatterns", (Tag)invalidTags);
        ListTag listTag = new ListTag();
        for (Boolean value : this.enabledPatternSlots) {
            listTag.add((Object)ByteTag.valueOf((boolean)value));
        }
        data.put("enabledPatterns", (Tag)listTag);
        ListTag listTag2 = this.makeJobsTag(registries);
        if (listTag2 != null) {
            data.put("craftingJobs", (Tag)listTag2);
        }
        this.upgrades.writeToNBT(data, "upgrades", registries);
        this.configManager.writeToNBT(data, registries);
        ListTag sendListTag = new ListTag();
        for (GenericStack toSend : this.sendList) {
            sendListTag.add((Object)GenericStack.writeTag((HolderLookup.Provider)registries, (GenericStack)toSend));
        }
        data.put(NBT_SEND_LIST, (Tag)sendListTag);
    }

    public void loadTag(CompoundTag data, HolderLookup.Provider registries) {
        ListTag enabledTags;
        ListTag invalidTags;
        super.loadTag(data, registries);
        this.allowedOutputs.clear();
        ListTag outputTags = data.getList("outputSides", 8);
        if (!outputTags.isEmpty()) {
            for (int x = 0; x < outputTags.size(); ++x) {
                RelativeSide side = Enum.valueOf(RelativeSide.class, outputTags.getString(x));
                this.allowedOutputs.add(side);
            }
        }
        if (!(invalidTags = data.getList("invalidPatterns", 1)).isEmpty()) {
            for (int x = 0; x < this.invalidPatternSlots.size(); ++x) {
                this.invalidPatternSlots.set(x, ((ByteTag)invalidTags.get(x)).getAsByte() > 0);
            }
        }
        if (!(enabledTags = data.getList("enabledPatterns", 1)).isEmpty()) {
            for (int x = 0; x < this.enabledPatternSlots.size(); ++x) {
                this.enabledPatternSlots.set(x, ((ByteTag)enabledTags.get(x)).getAsByte() > 0);
            }
        }
        if (data.contains("craftingJobs")) {
            this.readJobs(data, registries);
        }
        this.upgrades.readFromNBT(data, "upgrades", registries);
        this.configManager.readFromNBT(data, registries);
        ListTag sendListTag = data.getList(NBT_SEND_LIST, 10);
        for (int i = 0; i < sendListTag.size(); ++i) {
            GenericStack stack = GenericStack.readTag((HolderLookup.Provider)registries, (CompoundTag)sendListTag.getCompound(i));
            if (stack == null) continue;
            this.addToSendList(stack.what(), stack.amount());
        }
    }

    public ListTag makeJobsTag(HolderLookup.Provider registries) {
        try {
            ListTag jobTags = new ListTag();
            for (CraftingJob job : this.craftingJobs) {
                CompoundTag tag = new CompoundTag();
                if (job != null) {
                    job.writeToNBT(tag, registries);
                    jobTags.add((Object)tag);
                    continue;
                }
                jobTags.add((Object)tag);
            }
            return jobTags;
        }
        catch (NullPointerException ignored) {
            return null;
        }
    }

    private void readJobs(CompoundTag data, HolderLookup.Provider registries) {
        ListTag jobTags = data.getList("craftingJobs", 10);
        if (!jobTags.isEmpty()) {
            for (int x = 0; x < jobTags.size(); ++x) {
                CompoundTag tag = (CompoundTag)jobTags.get(x);
                if (tag.isEmpty()) continue;
                this.craftingJobs.set(x, CraftingJob.fromTag(tag, registries));
            }
        }
    }

    protected boolean readFromStream(RegistryFriendlyByteBuf data) {
        boolean c = super.readFromStream(data);
        this.setWorking(data.readBoolean());
        boolean isActive = data.readBoolean();
        c = isActive != this.isActive || c;
        this.isActive = isActive;
        return c;
    }

    protected void writeToStream(RegistryFriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeBoolean(this.isWorking());
        data.writeBoolean(this.isActive());
    }

    public void exportSettings(SettingsFrom mode, DataComponentMap.Builder builder, @Nullable Player player) {
        super.exportSettings(mode, builder, player);
        if (mode == SettingsFrom.MEMORY_CARD) {
            EnumSet<RelativeSide> outputs = this.getAllowedOutputs();
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (RelativeSide output : outputs) {
                list.add(output.getUnrotatedSide().get3DDataValue());
            }
            builder.set(AAEComponents.EXPORTED_ALLOWED_SIDES, list);
            builder.set(AEComponents.EXPORTED_PATTERNS, (Object)this.patternInv.toItemContainerContents());
        }
    }

    public void importSettings(SettingsFrom mode, DataComponentMap input, @Nullable Player player) {
        super.importSettings(mode, input, player);
        if (mode == SettingsFrom.MEMORY_CARD) {
            BlockEntity be;
            Level level;
            List list = (List)input.get(AAEComponents.EXPORTED_ALLOWED_SIDES);
            if (list != null && (level = this.getLevel()) != null && (be = level.getBlockEntity(this.getBlockPos())) instanceof IDirectionalOutputHost) {
                IDirectionalOutputHost host = (IDirectionalOutputHost)be;
                EnumSet<RelativeSide> outputs = EnumSet.noneOf(RelativeSide.class);
                for (Integer item : list) {
                    outputs.add(RelativeSide.fromUnrotatedSide((Direction)Direction.from3DDataValue((int)item)));
                }
                host.updateOutputSides(outputs);
            }
            this.importPatterns(player, input);
        }
    }

    private void importPatterns(@Nullable Player player, DataComponentMap input) {
        ItemContainerContents patterns = (ItemContainerContents)input.getOrDefault(AEComponents.EXPORTED_PATTERNS, (Object)ItemContainerContents.EMPTY);
        if (player != null && !player.level().isClientSide) {
            this.clearPatternInventory(player);
            AppEngInternalInventory desiredPatterns = new AppEngInternalInventory(this.patternInv.size());
            desiredPatterns.fromItemContainerContents(patterns);
            Inventory playerInv = player.getInventory();
            int blankPatternsAvailable = player.getAbilities().instabuild ? Integer.MAX_VALUE : playerInv.countItem(AEItems.BLANK_PATTERN.asItem());
            int blankPatternsUsed = 0;
            for (int i = 0; i < desiredPatterns.size(); ++i) {
                IPatternDetails pattern;
                if (desiredPatterns.getStackInSlot(i).isEmpty() || (pattern = PatternDetailsHelper.decodePattern((ItemStack)desiredPatterns.getStackInSlot(i), (Level)this.getBlockEntity().getLevel())) == null || blankPatternsAvailable < ++blankPatternsUsed || this.patternInv.addItems(pattern.getDefinition().toStack()).isEmpty()) continue;
                AELog.warn((String)"Failed to add pattern to quantum crafter", (Object[])new Object[0]);
                --blankPatternsUsed;
            }
            if (blankPatternsUsed > 0 && !player.getAbilities().instabuild) {
                new PlayerInternalInventory(playerInv).removeItems(blankPatternsUsed, AEItems.BLANK_PATTERN.stack(), null);
            }
            if (blankPatternsUsed > blankPatternsAvailable) {
                player.sendSystemMessage((Component)PlayerMessages.MissingBlankPatterns.text(new Object[]{blankPatternsUsed - blankPatternsAvailable}));
            }
        }
    }

    private void clearPatternInventory(Player player) {
        if (player.getAbilities().instabuild) {
            for (int i = 0; i < this.patternInv.size(); ++i) {
                this.patternInv.setItemDirect(i, ItemStack.EMPTY);
            }
            return;
        }
        Inventory playerInv = player.getInventory();
        int blankPatternCount = 0;
        for (int i = 0; i < this.patternInv.size(); ++i) {
            ItemStack pattern = this.patternInv.getStackInSlot(i);
            if (pattern.is(AEItems.CRAFTING_PATTERN.asItem()) || pattern.is(AEItems.PROCESSING_PATTERN.asItem()) || pattern.is(AEItems.SMITHING_TABLE_PATTERN.asItem()) || pattern.is(AEItems.STONECUTTING_PATTERN.asItem()) || pattern.is(AEItems.BLANK_PATTERN.asItem())) {
                blankPatternCount += pattern.getCount();
            } else {
                playerInv.placeItemBackInInventory(pattern);
            }
            this.patternInv.setItemDirect(i, ItemStack.EMPTY);
        }
        if (blankPatternCount > 0) {
            playerInv.placeItemBackInInventory(AEItems.BLANK_PATTERN.stack(blankPatternCount), false);
        }
    }

    private void onConfigChanged() {
        this.getMainNode().ifPresent((grid, node) -> {
            if (this.hasWork()) {
                grid.getTickManager().wakeDevice(node);
            } else {
                grid.getTickManager().sleepDevice(node);
            }
        });
        this.saveChanges();
    }

    public void updateRedstoneState() {
        YesNo currentState;
        if (this.level == null) {
            return;
        }
        YesNo yesNo = currentState = this.level.getBestNeighborSignal(this.worldPosition) != 0 ? YesNo.YES : YesNo.NO;
        if (this.lastRedstoneState != currentState) {
            this.lastRedstoneState = currentState;
            this.onConfigChanged();
        }
    }

    private boolean getRedstoneState() {
        if (this.lastRedstoneState == YesNo.UNDECIDED) {
            this.updateRedstoneState();
        }
        return this.lastRedstoneState == YesNo.YES;
    }

    private boolean isEnabled() {
        if (!this.upgrades.isInstalled((ItemLike)AEItems.REDSTONE_CARD)) {
            return true;
        }
        RedstoneMode rs = (RedstoneMode)this.configManager.getSetting(Settings.REDSTONE_CONTROLLED);
        if (rs == RedstoneMode.LOW_SIGNAL) {
            return !this.getRedstoneState();
        }
        if (rs == RedstoneMode.HIGH_SIGNAL) {
            return this.getRedstoneState();
        }
        return true;
    }

    public boolean isActive() {
        if (this.level != null && !this.level.isClientSide) {
            return this.getMainNode().isOnline();
        }
        return this.isActive;
    }

    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        if (reason != IGridNodeListener.State.GRID_BOOT) {
            this.markForUpdate();
        }
    }

    @Override
    public EnumSet<RelativeSide> getAllowedOutputs() {
        return this.allowedOutputs;
    }

    @Override
    public void updateOutputSides(EnumSet<RelativeSide> allowedOutputs) {
        this.allowedOutputs = allowedOutputs;
        this.saveChanges();
    }

    public void returnToMainMenu(Player player, ISubMenu iSubMenu) {
        MenuOpener.returnTo(AAEMenus.QUANTUM_CRAFTER.get(), (Player)player, (MenuHostLocator)MenuLocators.forBlockEntity((BlockEntity)this));
    }

    public ItemStack getMainMenuIcon() {
        return new ItemStack((ItemLike)AAEBlocks.QUANTUM_CRAFTER.asItem());
    }

    public List<Boolean> getInvalidPatternSlots() {
        return this.invalidPatternSlots;
    }

    public void setInvalidPattern(int index, boolean value) {
        this.invalidPatternSlots.set(index, value);
    }

    public List<Boolean> getEnabledPatternSlots() {
        return this.enabledPatternSlots;
    }

    public void toggleEnablePattern(int index) {
        if (index >= 0 && index < this.enabledPatternSlots.size()) {
            this.enabledPatternSlots.set(index, this.enabledPatternSlots.get(index) == false);
        }
        this.saveChanges();
    }

    public LinkedHashMap<AEKey, Long> getPatternConfigInputs(int index) {
        LinkedHashMap<AEKey, Long> inputs = new LinkedHashMap<AEKey, Long>();
        try {
            CraftingJob job = this.craftingJobs.get(index);
            if (job == null || job.pattern == null) {
                return null;
            }
            for (IPatternDetails.IInput input : job.pattern.getInputs()) {
                GenericStack genStack = input.getPossibleInputs()[0];
                inputs.put(genStack.what(), job.minimumInputToKeep(input));
            }
            return inputs;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public Pair<AEKey, Long> getPatternConfigOutput(int index) {
        try {
            CraftingJob job = this.craftingJobs.get(index);
            if (job == null || job.pattern == null) {
                return null;
            }
            return new Pair((Object)((GenericStack)job.pattern.getOutputs().getFirst()).what(), (Object)job.limitMaxOutput);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public void setStockAmount(int index, int inputIndex, long amount) {
        try {
            CraftingJob job = this.craftingJobs.get(index);
            job.setMinimumInputToKeep(inputIndex, amount);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void setMaxCrafted(int index, long amount) {
        try {
            CraftingJob job = this.craftingJobs.get(index);
            job.limitMaxOutput = amount;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public static class CraftingJob {
        public static final long DEFAULT_KEEP_INPUT = 0L;
        public static final long DEFAULT_KEEP_OUTPUT = 0L;
        private static final int GRID_SIZE = 3;
        public AECraftingPattern pattern;
        private final List<ItemStack> remainingItems;
        private final List<Long> keepMinInput;
        public long limitMaxOutput;
        public boolean consumesDurability = false;
        public HashMap<AEItemKey, Integer> keysThatConsumeDurability = new HashMap();
        public boolean hasDataChange;

        public CraftingJob(AECraftingPattern pattern) {
            this.pattern = pattern;
            this.remainingItems = this.getRemainingItems();
            this.keepMinInput = this.createNewInputMap();
            this.limitMaxOutput = 0L;
            this.analyzePattern();
        }

        private CraftingJob(AECraftingPattern pattern, List<ItemStack> remainingItems, List<Long> keepMinInput, long limitMaxOutput) {
            this.pattern = pattern;
            this.remainingItems = remainingItems;
            this.keepMinInput = keepMinInput;
            this.limitMaxOutput = limitMaxOutput;
            this.analyzePattern();
        }

        private void analyzePattern() {
            if (this.pattern == null) {
                return;
            }
            for (IPatternDetails.IInput input : this.pattern.getInputs()) {
                ItemStack outputStack;
                int damage;
                ItemStack remainingStack;
                GenericStack in = input.getPossibleInputs()[0];
                AEKey aEKey = in.what();
                if (!(aEKey instanceof AEItemKey)) continue;
                AEItemKey inKey = (AEItemKey)aEKey;
                ItemStack inStack = inKey.toStack();
                if (!this.keysThatConsumeDurability.containsKey(inKey) && (remainingStack = this.findMatchingRemainingItem(in)) != ItemStack.EMPTY && (damage = remainingStack.getDamageValue() - inStack.getDamageValue()) > 0) {
                    this.keysThatConsumeDurability.put(inKey, damage);
                    this.consumesDurability = true;
                    continue;
                }
                if (this.hasDataChange || (outputStack = this.findMatchingOutput(in)) == ItemStack.EMPTY || ItemStack.isSameItemSameComponents((ItemStack)inStack.copyWithCount(outputStack.getCount()), (ItemStack)outputStack)) continue;
                this.hasDataChange = true;
                break;
            }
        }

        public void writeToNBT(CompoundTag data, HolderLookup.Provider registries) {
            ListTag remainingTag = new ListTag();
            for (ItemStack item : this.remainingItems) {
                if (item == null || item.isEmpty()) continue;
                CompoundTag itemTag = new CompoundTag();
                itemTag = (CompoundTag)item.save(registries, (Tag)itemTag);
                remainingTag.add((Object)itemTag);
            }
            data.put("remainingItems", (Tag)remainingTag);
            ListTag listMinTag = new ListTag();
            for (Long value : this.keepMinInput) {
                listMinTag.add((Object)LongTag.valueOf((long)value));
            }
            data.put("listMinInput", (Tag)listMinTag);
            data.putLong("limitMaxOutput", this.limitMaxOutput);
        }

        public static CraftingJob fromTag(CompoundTag data, HolderLookup.Provider registries) {
            ArrayList<ItemStack> remainingItems = new ArrayList();
            if (data.contains("remainingItems")) {
                ListTag remainingTag = data.getList("remainingItems", 10);
                remainingItems = Arrays.asList(new ItemStack[remainingTag.size()]);
                if (!remainingTag.isEmpty()) {
                    for (int x = 0; x < remainingTag.size(); ++x) {
                        remainingItems.set(x, ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)remainingTag.getCompound(x)));
                    }
                }
            }
            ArrayList<Long> keepMinInput = new ArrayList();
            if (data.contains("listMinInput")) {
                ListTag listMinTag = data.getList("listMinInput", 4);
                keepMinInput = Arrays.asList(new Long[listMinTag.size()]);
                if (!listMinTag.isEmpty()) {
                    for (int x = 0; x < listMinTag.size(); ++x) {
                        keepMinInput.set(x, ((LongTag)listMinTag.get(x)).getAsLong());
                    }
                }
            }
            long limitMaxOutput = data.contains("limitMaxOutput") ? data.getLong("limitMaxOutput") : 0L;
            return new CraftingJob(null, remainingItems, keepMinInput, limitMaxOutput);
        }

        public void setPattern(AECraftingPattern pattern) {
            this.pattern = pattern;
            this.analyzePattern();
        }

        public long minimumInputToKeep(IPatternDetails.IInput stack) {
            for (int x = 0; x < this.pattern.getInputs().length; ++x) {
                IPatternDetails.IInput input = this.pattern.getInputs()[x];
                if (!input.equals((Object)stack) || this.keepMinInput.size() <= x) continue;
                return this.keepMinInput.get(x);
            }
            return 0L;
        }

        public void setMinimumInputToKeep(int inputIndex, long value) {
            if (inputIndex >= this.pattern.getInputs().length) {
                return;
            }
            this.keepMinInput.set(inputIndex, value);
        }

        public int requiredDurability(GenericStack input) {
            AEItemKey inputKey;
            AEKey aEKey = input.what();
            if (aEKey instanceof AEItemKey && this.keysThatConsumeDurability.containsKey(inputKey = (AEItemKey)aEKey)) {
                return this.keysThatConsumeDurability.get(inputKey);
            }
            return 0;
        }

        public long requiredInputTotal(GenericStack input, int toCraft) {
            int durability;
            IPatternDetails.IInput i2;
            long multiplier = 0L;
            for (IPatternDetails.IInput i2 : this.pattern.getInputs()) {
                boolean found = false;
                for (GenericStack genInput : i2.getPossibleInputs()) {
                    if (!input.what().matches(genInput)) continue;
                    multiplier = i2.getMultiplier() * input.amount();
                    found = true;
                    break;
                }
                if (found) break;
            }
            if ((durability = this.requiredDurability(input)) > 0) {
                return (long)durability * multiplier * (long)toCraft;
            }
            ItemStack remainingItem = this.findMatchingRemainingItem(input);
            if (input.amount() <= (long)remainingItem.getCount()) {
                return multiplier;
            }
            i2 = input.what();
            if (i2 instanceof AEItemKey) {
                AEItemKey key = (AEItemKey)i2;
                ItemStack stack = key.toStack();
                for (ItemStack item : this.remainingItems) {
                    if (!item.is(stack.getItem())) continue;
                    return multiplier;
                }
                return multiplier * (long)toCraft;
            }
            if (input.what() instanceof AEFluidKey) {
                return multiplier * (long)toCraft;
            }
            return 0L;
        }

        public ItemStack findMatchingOutput(GenericStack input) {
            AEKey aEKey = input.what();
            if (!(aEKey instanceof AEItemKey)) {
                return ItemStack.EMPTY;
            }
            AEItemKey inKey = (AEItemKey)aEKey;
            ItemStack inStack = inKey.toStack();
            for (GenericStack output : this.pattern.getOutputs()) {
                ItemStack outStack = ((AEItemKey)output.what()).toStack((int)output.amount());
                if ((inStack.isComponentsPatchEmpty() || !inStack.getComponentsPatch().equals((Object)outStack.getComponentsPatch())) && !inStack.is(outStack.getItem())) continue;
                return outStack;
            }
            return ItemStack.EMPTY;
        }

        public boolean isInputConsumed(GenericStack input) {
            ItemStack in = this.findMatchingRemainingItem(input);
            if ((long)in.getCount() >= input.amount()) {
                return false;
            }
            ItemStack out = this.findMatchingOutput(input);
            return out.isEmpty() || this.hasDataChange;
        }

        public ItemStack findMatchingRemainingItem(GenericStack input) {
            for (ItemStack item : this.remainingItems) {
                AEItemKey inputKey;
                AEKey aEKey = input.what();
                if (!(aEKey instanceof AEItemKey) || !(inputKey = (AEItemKey)aEKey).is((ItemLike)item.getItem())) continue;
                return item;
            }
            return ItemStack.EMPTY;
        }

        public boolean isStackAnInput(ItemStack stack) {
            for (IPatternDetails.IInput input : this.pattern.getInputs()) {
                for (GenericStack genInput : input.getPossibleInputs()) {
                    if (!genInput.what().wrapForDisplayOrFilter().is(stack.getItem())) continue;
                    return true;
                }
            }
            return false;
        }

        public long outputAmountPerCraft(GenericStack stack) {
            for (IPatternDetails.IInput i : this.pattern.getInputs()) {
                for (GenericStack genInput : i.getPossibleInputs()) {
                    if (!stack.what().matches(genInput)) continue;
                    return stack.amount() - genInput.amount();
                }
            }
            return stack.amount();
        }

        private List<Long> createNewInputMap() {
            ArrayList<Long> list = new ArrayList<Long>();
            for (IPatternDetails.IInput ignored : this.pattern.getInputs()) {
                list.add(0L);
            }
            return list;
        }

        private List<ItemStack> getRemainingItems() {
            ArrayList<ItemStack> craftingInput = new ArrayList<ItemStack>();
            int bucketsToRemove = 0;
            for (int x = 0; x < this.pattern.getSparseInputs().size(); ++x) {
                GenericStack input = (GenericStack)this.pattern.getSparseInputs().get(x);
                if (input == null) {
                    craftingInput.add(ItemStack.EMPTY);
                } else {
                    AEKey aEKey = input.what();
                    if (aEKey instanceof AEItemKey) {
                        Iterator key = (AEItemKey)aEKey;
                        craftingInput.add(key.toStack((int)input.amount()));
                    }
                }
                if (!this.pattern.canSubstituteFluids() || this.pattern.getValidFluid(x) == null) continue;
                ++bucketsToRemove;
            }
            NonNullList itemList = this.pattern.getRemainingItems(CraftingInput.of((int)3, (int)3, craftingInput));
            HashMap<Item, ItemStack> condensedItemList = new HashMap<Item, ItemStack>();
            for (ItemStack item : itemList) {
                if (item == ItemStack.EMPTY) continue;
                if (condensedItemList.containsKey(item.getItem())) {
                    condensedItemList.computeIfPresent(item.getItem(), (k, current) -> item.copyWithCount(current.getCount() + item.getCount()));
                    continue;
                }
                condensedItemList.put(item.getItem(), item);
            }
            ArrayList<ItemStack> finalList = new ArrayList<ItemStack>();
            for (Map.Entry entry : condensedItemList.entrySet()) {
                if (bucketsToRemove > 0 && entry.getKey() == Items.BUCKET) {
                    int bucketCount = Math.max(0, ((ItemStack)entry.getValue()).getCount() - bucketsToRemove);
                    if (bucketCount <= 0) continue;
                    finalList.add(((ItemStack)entry.getValue()).copyWithCount(bucketCount));
                    continue;
                }
                finalList.add(((ItemStack)entry.getValue()).copy());
            }
            return Collections.unmodifiableList(finalList);
        }
    }
}

