/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wut.recipe;

import com.mojang.datafixers.util.Unit;
import de.mari_023.ae2wtlib.api.registration.WTDefinition;
import de.mari_023.ae2wtlib.wut.recipe.CombineSerializer;
import de.mari_023.ae2wtlib.wut.recipe.Common;
import de.mari_023.ae2wtlib.wut.recipe.InputHelper;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class Combine
extends Common {
    public static final CombineSerializer serializer = new CombineSerializer();
    private final Ingredient terminalA;
    private final Ingredient terminalB;
    private final WTDefinition terminalADefinition;
    private final WTDefinition terminalBDefinition;

    public Combine(Ingredient terminalA, Ingredient terminalB, WTDefinition terminalADefinition, WTDefinition terminalBDefinition) {
        this.terminalA = terminalA;
        this.terminalB = terminalB;
        this.terminalADefinition = terminalADefinition;
        this.terminalBDefinition = terminalBDefinition;
        this.outputStack.set(terminalADefinition.componentType(), (Object)Unit.INSTANCE);
        this.outputStack.set(terminalBDefinition.componentType(), (Object)Unit.INSTANCE);
    }

    public Ingredient getTerminalA() {
        return this.terminalA;
    }

    public Ingredient getTerminalB() {
        return this.terminalB;
    }

    public WTDefinition getTerminalADefinition() {
        return this.terminalADefinition;
    }

    public WTDefinition getTerminalBDefinition() {
        return this.terminalBDefinition;
    }

    public boolean matches(CraftingInput inv, Level world) {
        return !InputHelper.getInputStack(inv, this.terminalA).isEmpty() && !InputHelper.getInputStack(inv, this.terminalB).isEmpty() && inv.ingredientCount() == 2;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider provider) {
        ItemStack wut = Combine.mergeTerminal(this.outputStack.copy(), InputHelper.getInputStack(inv, this.terminalA), this.terminalADefinition);
        wut = Combine.mergeTerminal(wut, InputHelper.getInputStack(inv, this.terminalB), this.terminalBDefinition);
        return wut;
    }

    public RecipeSerializer<?> getSerializer() {
        return serializer;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList inputs = NonNullList.create();
        inputs.add((Object)this.terminalA);
        inputs.add((Object)this.terminalB);
        return inputs;
    }
}

