/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.network.task;

import com.buuz135.replication.api.task.IReplicationTask;
import com.buuz135.replication.api.task.ReplicationTask;
import com.buuz135.replication.network.MatterNetwork;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class ReplicationTaskManager
implements INBTSerializable<CompoundTag> {
    private HashMap<String, IReplicationTask> pendingTasks = new LinkedHashMap<String, IReplicationTask>();

    public HashMap<String, IReplicationTask> getPendingTasks() {
        return this.pendingTasks;
    }

    @Nullable
    public IReplicationTask findTaskForReplicator(BlockPos pos, MatterNetwork matterNetwork) {
        int replicatorsAmount = matterNetwork.getReplicators().size();
        int pendingTasksAmount = this.pendingTasks.size();
        if (pendingTasksAmount == 0) {
            pendingTasksAmount = 1;
        }
        for (IReplicationTask value : this.getPendingTasks().values()) {
            if (!value.canAcceptReplicator(pos, (int)Math.max(1.0, Math.ceil((double)replicatorsAmount / (double)pendingTasksAmount)))) continue;
            return value;
        }
        return null;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        this.pendingTasks.forEach((s, task) -> compoundTag.put(s, task.serializeNBT(provider)));
        return compoundTag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag compoundTag) {
        this.pendingTasks = new LinkedHashMap<String, IReplicationTask>();
        compoundTag.getAllKeys().forEach(s -> {
            ReplicationTask task = new ReplicationTask(ItemStack.EMPTY, Integer.MAX_VALUE, IReplicationTask.Mode.SINGLE, null);
            task.deserializeNBT(provider, compoundTag.getCompound(s));
            this.pendingTasks.put((String)s, task);
        });
    }
}

