/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.command;

import com.buuz135.replication.ReplicationAttachments;
import com.buuz135.replication.ReplicationRegistry;
import com.buuz135.replication.api.IMatterType;
import com.buuz135.replication.calculation.MatterCompound;
import com.buuz135.replication.calculation.ReplicationCalculation;
import com.buuz135.replication.calculation.client.ClientReplicationCalculation;
import com.buuz135.replication.recipe.MatterValueRecipe;
import com.hrznstudio.titanium.util.RecipeUtil;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReplicationCommand {
    private static final Logger LOGGER = LogManager.getLogger((String)"REPLICATION-MISSING-DUMP");

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"replication").then(((LiteralArgumentBuilder)Commands.literal((String)"dump-inventory").executes(context -> ReplicationCommand.dumpInventoryItems((CommandContext<CommandSourceStack>)context))).requires(commandSourceStack -> commandSourceStack.hasPermission(4)))).then(((LiteralArgumentBuilder)Commands.literal((String)"dump-missing").executes(context -> ReplicationCommand.dumpMissing((CommandContext<CommandSourceStack>)context))).requires(commandSourceStack -> commandSourceStack.hasPermission(4)))).then(((LiteralArgumentBuilder)Commands.literal((String)"dump-missing-common-tags").executes(context -> ReplicationCommand.dumpMissingCommonTags((CommandContext<CommandSourceStack>)context))).requires(commandSourceStack -> commandSourceStack.hasPermission(4)))).then(Commands.literal((String)"export-to-csv").executes(context -> ReplicationCommand.exportToCSV((CommandContext<CommandSourceStack>)context)))).then(((LiteralArgumentBuilder)Commands.literal((String)"create-blueprint-using-hand").requires(commandSourceStack -> commandSourceStack.hasPermission(4))).then(Commands.argument((String)"progress", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)1.0)).executes(context -> ReplicationCommand.createBlueprint((CommandContext<CommandSourceStack>)context)))));
    }

    public static int dumpMissing(CommandContext<CommandSourceStack> context) {
        List tabs = CreativeModeTabs.tabs();
        CreativeModeTab hotbar = (CreativeModeTab)BuiltInRegistries.CREATIVE_MODE_TAB.get(CreativeModeTabs.HOTBAR);
        CreativeModeTab search = (CreativeModeTab)BuiltInRegistries.CREATIVE_MODE_TAB.get(CreativeModeTabs.SEARCH);
        ArrayList<Item> missingItems = new ArrayList<Item>();
        for (CreativeModeTab tab : tabs) {
            if (tab == hotbar || tab == search) continue;
            LOGGER.info("SCANNING TAB " + tab.getDisplayName().getString());
            Collection list = tab.getDisplayItems();
            List<ItemStack> missing = list.stream().filter(item -> BuiltInRegistries.ITEM.getKey((Object)item.getItem()).getNamespace().equals("minecraft")).filter(itemStack -> !(itemStack.getItem() instanceof SpawnEggItem)).filter(itemStack -> !BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).getPath().contains("_ore")).filter(itemStack -> !BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).getPath().contains("_shulker")).filter(itemStack -> !BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).getPath().contains("raw_")).filter(itemStack -> !BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).getPath().contains("_sherd")).filter(itemStack -> !BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).getPath().contains("_template")).filter(itemStack -> !BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).getPath().contains("_bucket")).filter(itemStack -> !BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).getPath().contains("infested_")).filter(itemStack -> !BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).getPath().contains("_pattern")).filter(item -> ReplicationCalculation.getMatterCompound(item) == null).collect(Collectors.toList());
            missing.forEach(item -> LOGGER.info((Object)BuiltInRegistries.ITEM.getKey((Object)item.getItem())));
            for (ItemStack itemStack2 : missing) {
                if (missingItems.contains(itemStack2.getItem())) continue;
                missingItems.add(itemStack2.getItem());
            }
            LOGGER.info("WE ARE MISSING " + missing.size() + " items");
            LOGGER.info("--------------------------------------------");
        }
        LOGGER.info("WE ARE TOTAL MISSING " + missingItems.size() + " items");
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"Dumped missing items to log"));
        return 1;
    }

    public static int dumpInventoryItems(CommandContext<CommandSourceStack> context) {
        try {
            LOGGER.info(((CommandSourceStack)context.getSource()).getPlayerOrException().getInventory().items.stream().filter(itemStack -> !itemStack.isEmpty()).map(itemStack -> BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).getPath().toUpperCase(Locale.ROOT)).collect(Collectors.joining(", ")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1;
    }

    public static int createBlueprint(CommandContext<CommandSourceStack> context) {
        try {
            ItemStack mainStack = ((CommandSourceStack)context.getSource()).getPlayerOrException().getMainHandItem().copyWithCount(1);
            if (!mainStack.isEmpty()) {
                ItemStack blueprint = new ItemStack((ItemLike)ReplicationRegistry.Items.MATTER_BLUEPRINT.get());
                CompoundTag tag = new CompoundTag();
                tag.put("Item", mainStack.saveOptional((HolderLookup.Provider)((CommandSourceStack)context.getSource()).registryAccess()));
                tag.putDouble("Progress", ((Double)context.getArgument("progress", Double.class)).doubleValue());
                blueprint.set(ReplicationAttachments.BLUEPRINT, (Object)tag);
                ItemHandlerHelper.giveItemToPlayer((Player)((CommandSourceStack)context.getSource()).getPlayerOrException(), (ItemStack)blueprint, (int)0);
            }
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
        return 1;
    }

    public static int dumpMissingCommonTags(CommandContext<CommandSourceStack> context) {
        List recipes = RecipeUtil.getRecipes((Level)((CommandSourceStack)context.getSource()).getLevel(), (RecipeType)((RecipeType)ReplicationRegistry.CustomRecipeTypes.MATTER_VALUE_RECIPE_TYPE.get()));
        ArrayList<String> availableTags = new ArrayList<String>();
        for (MatterValueRecipe recipe : recipes) {
            TagKey tag;
            if (recipe.input.getValues().length <= 0 || !(recipe.input.getValues()[0] instanceof Ingredient.TagValue) || !(tag = ((Ingredient.TagValue)recipe.input.getValues()[0]).tag()).location().getNamespace().equals("c")) continue;
            availableTags.add(tag.toString());
        }
        LOGGER.info("MISSING COMMON TAGS");
        BuiltInRegistries.ITEM.getTagNames().forEach(itemTagKey -> {
            ResourceLocation name = itemTagKey.location();
            if (name.getNamespace().equals("c") && !availableTags.contains(name.toString())) {
                LOGGER.info(name.toString());
            }
        });
        LOGGER.info("--------------------------------------------");
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"Dumped missing common tags to log"));
        return 1;
    }

    public static int exportToCSV(CommandContext<CommandSourceStack> context) {
        new Thread(() -> {
            try {
                File csvFile = new File("replication-matter-data.csv");
                csvFile.createNewFile();
                try (PrintWriter pw = new PrintWriter(csvFile);){
                    ArrayList<String> headers = new ArrayList<String>();
                    for (IMatterType iMatterType : ReplicationRegistry.MATTER_TYPES_REGISTRY) {
                        headers.add(iMatterType.equals(ReplicationRegistry.Matter.EMPTY.get()) ? "" : iMatterType.toString());
                    }
                    pw.println(ReplicationCommand.convertToCSV(headers.toArray(new String[0])));
                    for (String s : ClientReplicationCalculation.DEFAULT_MATTER_COMPOUND.keySet()) {
                        ArrayList<Object> line = new ArrayList<Object>();
                        line.add(s);
                        MatterCompound matter = ClientReplicationCalculation.DEFAULT_MATTER_COMPOUND.get(s);
                        for (IMatterType iMatterType : ReplicationRegistry.MATTER_TYPES_REGISTRY) {
                            if (iMatterType.equals(ReplicationRegistry.Matter.EMPTY.get())) continue;
                            if (matter.getValues().containsKey(iMatterType)) {
                                line.add("" + matter.getValues().get(iMatterType).getAmount());
                                continue;
                            }
                            line.add("0.0");
                        }
                        pw.println(ReplicationCommand.convertToCSV(line.toArray(new String[0])));
                    }
                }
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"Exported to file replication-matter-data.csv in your instance folder"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).start();
        return 1;
    }

    public static String convertToCSV(String[] data) {
        return Stream.of(data).map(ReplicationCommand::escapeSpecialCharacters).collect(Collectors.joining(","));
    }

    public static String escapeSpecialCharacters(String data) {
        if (data == null) {
            throw new IllegalArgumentException("Input data cannot be null");
        }
        Object escapedData = data.replaceAll("\\R", " ");
        if (data.contains(",") || data.contains("\"") || data.contains("'")) {
            data = data.replace("\"", "\"\"");
            escapedData = "\"" + data + "\"";
        }
        return escapedData;
    }
}

