/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.client.gui.addons;

import com.buuz135.replication.api.IMatterType;
import com.buuz135.replication.api.pattern.MatterPattern;
import com.buuz135.replication.calculation.MatterCompound;
import com.buuz135.replication.calculation.MatterValue;
import com.buuz135.replication.calculation.client.ClientReplicationCalculation;
import com.buuz135.replication.packet.MatterFluidSyncPacket;
import com.buuz135.replication.util.NumberUtils;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;

public final class MatterPatternButton {
    private final MatterPattern pattern;
    private int cachedAmount;
    private long createdWhen;
    private boolean shouldDisplayAnimation;

    public MatterPatternButton(MatterPattern pattern, int cachedAmount, long createdWhen, String network) {
        this.pattern = pattern;
        this.cachedAmount = cachedAmount;
        this.createdWhen = createdWhen;
        this.shouldDisplayAnimation = true;
        this.recalculateAmount(network);
    }

    public void render(GuiGraphics guiGraphics, int x, int y, double mouseX, double mouseY) {
        guiGraphics.renderItem(this.pattern.getStack(), x, y);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
        if (this.shouldDisplayAnimation) {
            int speed = 3;
            guiGraphics.drawString(Minecraft.getInstance().font, (Minecraft.getInstance().level.getGameTime() / (long)speed % 3L == 0L ? "\u00b7" : ".") + (Minecraft.getInstance().level.getGameTime() / (long)speed % 3L == 1L ? "\u00b7" : ".") + (Minecraft.getInstance().level.getGameTime() / (long)speed % 3L == 2L ? "\u00b7" : "."), x + 10, y + 8, 0xFFFFFF, true);
        } else {
            float scale = 0.5f;
            String display = NumberUtils.getFormatedBigNumber(this.cachedAmount);
            guiGraphics.pose().scale(scale, scale, scale);
            guiGraphics.drawString(Minecraft.getInstance().font, display, (float)(x + 16) / scale - (float)Minecraft.getInstance().font.width(display), (float)(y + 12) / scale, 0xFFFFFF, true);
        }
        guiGraphics.pose().popPose();
        if (mouseX > (double)(x - 1) && mouseX < (double)(x + 17) && mouseY > (double)(y - 1) && mouseY < (double)(y + 17)) {
            AbstractContainerScreen.renderSlotHighlight((GuiGraphics)guiGraphics, (int)x, (int)y, (int)1);
            guiGraphics.renderTooltip(Minecraft.getInstance().font, this.pattern.getStack(), (int)mouseX, (int)mouseY);
        }
    }

    public void recalculateAmount(String network) {
        MatterCompound matterCompound = ClientReplicationCalculation.getMatterCompound(this.pattern.getStack());
        if (matterCompound == null) {
            this.cachedAmount = 0;
        } else {
            this.cachedAmount = Integer.MAX_VALUE;
            HashMap<IMatterType, Long> networkValues = MatterFluidSyncPacket.CLIENT_MATTER_STORAGE.get(network);
            if (networkValues != null) {
                for (MatterValue matterValue : matterCompound.getValues().values()) {
                    IMatterType matterType = matterValue.getMatter();
                    double amount = matterValue.getAmount();
                    this.cachedAmount = (int)Math.min((double)this.cachedAmount, Math.min(2.147483647E9, (double)networkValues.getOrDefault(matterType, 0L).longValue() / amount));
                }
            }
        }
    }

    public void setShouldDisplayAnimation(boolean shouldDisplayAnimation) {
        this.shouldDisplayAnimation = shouldDisplayAnimation;
    }

    public MatterPattern pattern() {
        return this.pattern;
    }

    public int cachedAmount() {
        return this.cachedAmount;
    }

    public long createdWhen() {
        return this.createdWhen;
    }

    public void setCachedAmount(int cachedAmount) {
        this.cachedAmount = cachedAmount;
    }

    public void setCreatedWhen(long createdWhen) {
        this.createdWhen = createdWhen;
    }

    public boolean isShouldDisplayAnimation() {
        return this.shouldDisplayAnimation;
    }
}

