/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.client.gui;

import com.buuz135.replication.Replication;
import com.buuz135.replication.ReplicationRegistry;
import com.buuz135.replication.api.task.IReplicationTask;
import com.buuz135.replication.client.gui.ReplicationTerminalScreen;
import com.buuz135.replication.client.gui.button.ReplicationTerminalTexturedButton;
import com.buuz135.replication.container.ReplicationTerminalContainer;
import com.buuz135.replication.packet.TaskCancelPacket;
import com.buuz135.replication.packet.TaskSyncPacket;
import com.buuz135.replication.util.NumberUtils;
import com.hrznstudio.titanium.network.Message;
import com.hrznstudio.titanium.util.LangUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;

public class ReplicationTaskWidget
extends AbstractWidget
implements Renderable {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)Replication.MOD_ID, (String)"textures/gui/task_window.png");
    private static final ResourceLocation EXTRAS = ResourceLocation.fromNamespaceAndPath((String)Replication.MOD_ID, (String)"textures/gui/replication_terminal_extras.png");
    private final ReplicationTerminalScreen replicationTerminalScreen;
    private final ReplicationTerminalTexturedButton closeButton;
    private final List<AbstractWidget> widgets;
    private float scrollOffs;
    private boolean scrolling;
    private final int scrollBarX;
    private final int scrollBarY;
    private final int scrollBarWidth;
    private final int scrollBarHeight;
    private final CraftingMenu craftingMenu;

    public ReplicationTaskWidget(int pX, int pY, int pWidth, int pHeight, Component pMessage, ReplicationTerminalScreen replicationTerminalContainer) {
        super(pX, pY, pWidth, pHeight, pMessage);
        this.replicationTerminalScreen = replicationTerminalContainer;
        this.widgets = new ArrayList<AbstractWidget>();
        this.closeButton = new ReplicationTerminalTexturedButton(this.getX() + 239, this.getY() + 8, 9, 9, (Component)Component.empty(), EXTRAS, Component.translatable((String)"tooltip.replication.close").getString(), 247, 50, 238, 50, button -> this.replicationTerminalScreen.disableTask());
        this.widgets.add((AbstractWidget)this.closeButton);
        this.scrollOffs = 0.0f;
        this.scrolling = false;
        this.craftingMenu = new CraftingMenu(this);
        this.scrollBarX = this.getX() + this.width;
        this.scrollBarY = this.getY() + 23;
        this.scrollBarHeight = 88;
        this.scrollBarWidth = 9;
        this.refreshTasks();
    }

    public List<AbstractWidget> getWidgets() {
        return this.widgets;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        guiGraphics.blit(TEXTURE, this.getX(), this.getY(), 0, 0, 256, 256);
        guiGraphics.drawString(Minecraft.getInstance().font, this.getMessage(), this.getX() + 10, this.getY() + 10, 7529831, false);
        guiGraphics.blit(EXTRAS, this.scrollBarX, this.scrollBarY, 27, 0, 20, 108);
        int j = this.scrollBarX;
        int k = this.scrollBarY;
        int y = k + this.scrollBarHeight;
        guiGraphics.blit(EXTRAS, j + 1, k + (int)((float)(y - k - 5) * this.scrollOffs) + 1 + 9, 245, 0, 11, 5);
        for (AbstractWidget abstractWidget : this.widgets) {
            if (abstractWidget instanceof Checkbox) {
                guiGraphics.pose().pushPose();
                guiGraphics.pose().scale(0.5f, 0.5f, 0.5f);
                guiGraphics.pose().translate((float)(this.getX() + 20), (float)(this.getY() + 86), 0.0f);
                abstractWidget.render(guiGraphics, mouseX, mouseY, v);
                guiGraphics.pose().popPose();
                continue;
            }
            abstractWidget.render(guiGraphics, mouseX, mouseY, v);
        }
        for (int i = 0; i < this.craftingMenu.visibleButtons.size(); ++i) {
            TaskDisplay taskDisplay = this.craftingMenu.visibleButtons.get(i);
            taskDisplay.render(guiGraphics, this.getX() + 8 + i % 3 * 81, this.getY() + 25 + i / 3 * 25, mouseX, mouseY, v);
        }
    }

    protected boolean insideScrollbar(double p_98524_, double p_98525_) {
        int k = this.scrollBarX;
        int l = this.scrollBarY;
        int i1 = k + this.scrollBarWidth;
        int j1 = l + this.scrollBarHeight;
        return p_98524_ >= (double)k && p_98525_ >= (double)l && p_98524_ < (double)i1 && p_98525_ < (double)j1;
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling) {
            int i = this.scrollBarY + 1;
            int j = i + this.scrollBarHeight - 2;
            this.scrollOffs = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = Mth.clamp((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.craftingMenu.scrollTo(this.scrollOffs);
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double p_98527_, double p_98528_, double p_98529_, double scrollY) {
        if (!this.canScroll()) {
            return false;
        }
        this.scrollOffs = this.craftingMenu.subtractInputFromScroll(this.scrollOffs, p_98529_);
        this.craftingMenu.scrollTo(this.scrollOffs);
        return true;
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0) {
            this.scrolling = false;
        }
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }

    private boolean canScroll() {
        return this.craftingMenu.canScroll();
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0) {
            if (this.insideScrollbar(pMouseX, pMouseY)) {
                this.scrolling = this.canScroll();
                int i = this.scrollBarY + 1;
                int j = i + this.scrollBarHeight - 2;
                this.scrollOffs = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
                this.scrollOffs = Mth.clamp((float)this.scrollOffs, (float)0.0f, (float)1.0f);
                this.craftingMenu.scrollTo(this.scrollOffs);
                return true;
            }
            if (this.closeButton.isHovered()) {
                this.closeButton.mouseClicked(pMouseX, pMouseY, pButton);
            }
            if (this.craftingMenu.mouseClicked(pMouseX, pMouseY, pButton)) {
                return true;
            }
        }
        return false;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public void refreshTasks() {
        int originalSize = this.craftingMenu.taskDisplayList.size();
        this.craftingMenu.taskDisplayList.clear();
        HashMap tasks = TaskSyncPacket.CLIENT_TASK_STORAGE.getOrDefault(((ReplicationTerminalContainer)this.replicationTerminalScreen.getMenu()).getNetwork(), new HashMap());
        IReplicationTask[] tastValues = tasks.values().toArray(new IReplicationTask[0]);
        for (int i = 0; i < tastValues.length; ++i) {
            this.craftingMenu.taskDisplayList.add(new TaskDisplay(tastValues[i]));
        }
        if (this.craftingMenu.taskDisplayList.size() != originalSize) {
            this.craftingMenu.scrollTo(this.scrollOffs);
        }
    }

    public class CraftingMenu {
        public List<TaskDisplay> taskDisplayList = new ArrayList<TaskDisplay>();
        public List<TaskDisplay> visibleButtons = new ArrayList<TaskDisplay>();

        public CraftingMenu(ReplicationTaskWidget this$0) {
            this.scrollTo(0.0f);
        }

        protected int calculateRowCount() {
            return Mth.positiveCeilDiv((int)this.getFilteredPatterns().size(), (int)3) - 9;
        }

        protected int getRowIndexForScroll(float p_259664_) {
            return Math.max((int)((double)(p_259664_ * (float)this.calculateRowCount()) + 0.5), 0);
        }

        protected float getScrollForRowIndex(int p_259315_) {
            return Mth.clamp((float)((float)p_259315_ / (float)this.calculateRowCount()), (float)0.0f, (float)1.0f);
        }

        protected float subtractInputFromScroll(float p_259841_, double p_260358_) {
            return Mth.clamp((float)(p_259841_ - (float)(p_260358_ / (double)this.calculateRowCount())), (float)0.0f, (float)1.0f);
        }

        public void scrollTo(float p_98643_) {
            int i = this.getRowIndexForScroll(p_98643_);
            this.visibleButtons = new ArrayList<TaskDisplay>();
            List<TaskDisplay> filtered = this.getFilteredPatterns();
            for (int j = 0; j < 9; ++j) {
                for (int k = 0; k < 3; ++k) {
                    int l = k + (j + i) * 3;
                    if (l < 0 || l >= filtered.size()) continue;
                    this.visibleButtons.add(filtered.get(l));
                }
            }
        }

        public boolean canScroll() {
            return this.getFilteredPatterns().size() > 27;
        }

        private List<TaskDisplay> getFilteredPatterns() {
            return this.taskDisplayList;
        }

        public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
            for (TaskDisplay patternButton : this.visibleButtons) {
                if (!patternButton.cancelButton.isHovered() || !Screen.hasShiftDown()) continue;
                patternButton.cancelButton.mouseClicked(pMouseX, pMouseY, pButton);
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)ReplicationRegistry.Sounds.TERMINAL_BUTTON.get()), (float)1.0f));
                return true;
            }
            return false;
        }
    }

    public final class TaskDisplay {
        private final IReplicationTask task;
        private final ReplicationTerminalTexturedButton cancelButton;

        public TaskDisplay(IReplicationTask task) {
            this.task = task;
            this.cancelButton = new ReplicationTerminalTexturedButton(72, 1, 5, 5, (Component)Component.empty(), EXTRAS, Component.translatable((String)"tooltip.replication.terminal.cancel_task").getString(), 251, 59, 246, 59, button -> Replication.NETWORK.sendToServer((Message)new TaskCancelPacket(task.getUuid().toString(), ((ReplicationTerminalContainer)ReplicationTaskWidget.this.replicationTerminalScreen.getMenu()).getNetwork())));
        }

        public void render(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, float v) {
            guiGraphics.renderItem(this.task.getReplicatingStack(), x + 2, y + 2);
            this.cancelButton.setX(x + 72);
            this.cancelButton.setY(y + 1);
            this.cancelButton.render(guiGraphics, mouseX, mouseY, v);
            guiGraphics.pose().pushPose();
            float scale = 0.6f;
            guiGraphics.pose().scale(scale, scale, scale);
            int textY = 3;
            String display = LangUtil.getString((String)"tooltip.replication.terminal.amount", (Object[])new Object[0]) + NumberUtils.getFormatedBigNumber(this.task.getCurrentAmount()) + "/" + NumberUtils.getFormatedBigNumber(this.task.getTotalAmount());
            guiGraphics.drawString(Minecraft.getInstance().font, display, (float)(x + 16 + 13) / scale, (float)(y + textY) / scale, 7529831, false);
            display = LangUtil.getString((String)"tooltip.replication.terminal.workers", (Object[])new Object[0]) + NumberUtils.getFormatedBigNumber(this.task.getReplicatorsOnTask().size());
            guiGraphics.drawString(Minecraft.getInstance().font, display, (float)(x + 16 + 13) / scale, (float)(y + textY + 6) / scale, 7529831, false);
            display = LangUtil.getString((String)"tooltip.replication.terminal.mode", (Object[])new Object[0]) + LangUtil.getString((String)("tooltip.replication.terminal." + this.task.getMode().name().toLowerCase()), (Object[])new Object[0]);
            guiGraphics.drawString(Minecraft.getInstance().font, display, (float)(x + 16 + 13) / scale, (float)(y + textY + 12) / scale, 7529831, false);
            guiGraphics.pose().popPose();
            if (mouseX > x + 2 && mouseX < x + 19 && mouseY > y + 2 && mouseY < y + 19) {
                guiGraphics.renderTooltip(Minecraft.getInstance().font, this.task.getReplicatingStack(), mouseX, mouseY);
            }
        }

        public IReplicationTask task() {
            return this.task;
        }
    }
}

