/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.coolcatlib.internal.core.neoforge;

import net.ixdarklord.coolcatlib.api.brewing.BrewingRecipe;
import net.ixdarklord.coolcatlib.api.brewing.neoforge.NeoForgeBrewingRecipe;
import net.ixdarklord.coolcatlib.api.event.v1.server.RegisterBrewingRecipesEvent;
import net.ixdarklord.coolcatlib.api.hooks.ServerLifecycleHooks;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import org.jetbrains.annotations.NotNull;

@Mod(value="coolcatlib")
public class NeoForgeSetup {
    public NeoForgeSetup(IEventBus modEventBus) {
        IEventBus eventBus = NeoForge.EVENT_BUS;
        eventBus.addListener(NeoForgeSetup::onRegisterBrewingRecipes);
        eventBus.addListener(event -> ServerLifecycleHooks.updateServerState(event.getServer()));
        eventBus.addListener(event -> ServerLifecycleHooks.updateServerState(null));
    }

    private static void onRegisterBrewingRecipes(net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent event) {
        RegisterBrewingRecipesEvent invokeEvent = RegisterBrewingRecipesEvent.invokeEvent(event.getBuilder());
        for (final net.ixdarklord.coolcatlib.api.brewing.IBrewingRecipe recipe : invokeEvent.getBuilder().getBrewingRecipes()) {
            if (recipe instanceof BrewingRecipe) {
                BrewingRecipe brewingRecipe = (BrewingRecipe)recipe;
                event.getBuilder().addRecipe((IBrewingRecipe)new NeoForgeBrewingRecipe(brewingRecipe));
                continue;
            }
            event.getBuilder().addRecipe(new IBrewingRecipe(){

                public boolean isInput(@NotNull ItemStack arg) {
                    return recipe.isInput(arg);
                }

                public boolean isIngredient(@NotNull ItemStack arg) {
                    return recipe.isIngredient(arg);
                }

                @NotNull
                public ItemStack getOutput(@NotNull ItemStack arg, @NotNull ItemStack arg2) {
                    return recipe.getOutput(arg, arg2);
                }
            });
        }
    }
}

