/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.coolcatlib.api.util;

import java.util.function.Function;

public class ValueConverter<T> {
    private final Function<String, T> parser;
    private final Function<T, String> toStringConverter;
    public static final ValueConverter<String> STRING = new ValueConverter<String>(s -> s, s -> s);
    public static final ValueConverter<Integer> INTEGER = new ValueConverter<Integer>(Integer::parseInt, Object::toString);
    public static final ValueConverter<Double> DOUBLE = new ValueConverter<Double>(Double::parseDouble, Object::toString);
    public static final ValueConverter<Boolean> BOOLEAN = new ValueConverter<Boolean>(Boolean::parseBoolean, Object::toString);

    public static <E extends Enum<E>> ValueConverter<E> forEnum(Class<E> enumClass) {
        return new ValueConverter<Enum>(s -> Enum.valueOf(enumClass, s), Enum::name);
    }

    private ValueConverter(Function<String, T> parser, Function<T, String> toStringConverter) {
        this.parser = parser;
        this.toStringConverter = toStringConverter;
    }

    public static <T> ValueConverter<T> of(Function<String, T> parser, Function<T, String> toStringConverter) {
        return new ValueConverter<T>(parser, toStringConverter);
    }

    public T parse(String input) {
        try {
            return this.parser.apply(input);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid value: " + input, e);
        }
    }

    public String toString(T value) {
        return this.toStringConverter.apply(value);
    }
}

