/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.coolcatlib.api.util;

import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SlotReference<T> {
    public static final SlotReference<?> EMPTY = new SlotReference<Object>(null, -1){

        @Override
        @NotNull
        public ItemStack getItem() {
            return ItemStack.EMPTY;
        }

        @Override
        public boolean setItem(ItemStack item) {
            return false;
        }

        @Override
        public boolean removeItem() {
            return false;
        }
    };
    protected final T owner;
    protected final int index;

    public SlotReference(@Nullable T owner, int index) {
        this.owner = owner;
        this.index = index;
    }

    @Nullable
    public T getOwner() {
        return this.owner;
    }

    public int getIndex() {
        return this.index;
    }

    @NotNull
    public abstract ItemStack getItem();

    public abstract boolean setItem(ItemStack var1);

    public boolean removeItem() {
        if (this.getItem().isEmpty()) {
            return false;
        }
        return this.setItem(ItemStack.EMPTY);
    }

    public static class Container
    extends SlotReference<net.minecraft.world.Container> {
        public Container(@Nullable net.minecraft.world.Container container, int index) {
            super(container, index);
        }

        @Override
        @NotNull
        public ItemStack getItem() {
            if (this.owner == null) {
                throw new IllegalStateException("Cannot retrieve item: Slot owner is null.");
            }
            return ((net.minecraft.world.Container)this.owner).getItem(this.index);
        }

        @Override
        public boolean setItem(ItemStack stack) {
            if (this.owner == null) {
                throw new IllegalStateException("Cannot set item: Slot owner is null.");
            }
            if (ItemStack.matches((ItemStack)this.getItem(), (ItemStack)stack)) {
                return false;
            }
            ((net.minecraft.world.Container)this.owner).setItem(this.index, stack);
            return true;
        }
    }

    public static class Player
    extends SlotReference<net.minecraft.world.entity.player.Player> {
        public Player(@NotNull net.minecraft.world.entity.player.Player player, int index) {
            super(player, index);
        }

        @Override
        @NotNull
        public ItemStack getItem() {
            if (this.owner == null) {
                throw new IllegalStateException("Cannot retrieve item: Slot owner is null.");
            }
            return ((net.minecraft.world.entity.player.Player)this.owner).getSlot(this.index).get();
        }

        @Override
        public boolean setItem(ItemStack stack) {
            if (this.owner == null) {
                throw new IllegalStateException("Cannot set item: Slot owner is null.");
            }
            if (ItemStack.matches((ItemStack)this.getItem(), (ItemStack)stack)) {
                return false;
            }
            ((net.minecraft.world.entity.player.Player)this.owner).getSlot(this.index).set(stack);
            return true;
        }
    }
}

