/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.coolcatlib.api.util;

import java.awt.Color;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class RenderUtils {
    private static final String RECTANGLE_THROW = "Border must not fill the entire rectangle. [B: %s * 2 = %s || Rect: w:%s, h:%s]";
    public static Rect2i EMPTY_RECT2I = new Rect2i(0, 0, 0, 0);
    public static final RenderStateShard.TransparencyStateShard TRANSLUCENT_TRANSPARENCY = RenderStateShard.TRANSLUCENT_TRANSPARENCY;

    public static Rect2i createRect2i(GuiEventListener listener) {
        if (listener == null) {
            return EMPTY_RECT2I;
        }
        return new Rect2i(listener.getRectangle().left(), listener.getRectangle().top(), listener.getRectangle().width(), listener.getRectangle().height());
    }

    public static void renderDebugGradient(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        RenderUtils.renderDiagonalGradient(guiGraphics, x, y, width, height, Color.RED.getRGB(), Color.GREEN.getRGB());
    }

    public static void renderDiagonalGradient(GuiGraphics guiGraphics, int x, int y, int width, int height, int color1, int color2) {
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                float factor = Mth.clamp((float)((float)(i + j) / (float)(width + height)), (float)0.0f, (float)1.0f);
                int color = FastColor.ARGB32.lerp((float)factor, (int)color1, (int)color2);
                guiGraphics.fill(x + i, y + j, x + i + 1, y + j + 1, color);
            }
        }
    }

    public static void renderInRectangle(GuiGraphics guiGraphics, @NotNull ScreenRectangle rectangle, boolean shouldScissor, Runnable render) {
        if (shouldScissor) {
            guiGraphics.enableScissor(rectangle.left(), rectangle.top(), rectangle.right(), rectangle.bottom());
            render.run();
            guiGraphics.disableScissor();
        } else {
            render.run();
        }
    }

    public static void renderHollowRectangleOrThrow(GuiGraphics guiGraphics, ScreenRectangle rectangle, int border, int color) {
        if (!RenderUtils.renderHollowRectangle(guiGraphics, rectangle, border, color)) {
            throw new IllegalArgumentException(RECTANGLE_THROW.formatted(border, 2 * border, rectangle.width(), rectangle.height()));
        }
    }

    public static void renderHollowRectangleOrThrow(GuiGraphics guiGraphics, ScreenRectangle rectangle, int border, boolean outer, int color) {
        if (!RenderUtils.renderHollowRectangle(guiGraphics, rectangle, border, outer, color)) {
            throw new IllegalArgumentException(RECTANGLE_THROW.formatted(border, 2 * border, rectangle.width(), rectangle.height()));
        }
    }

    public static boolean renderHollowRectangle(GuiGraphics guiGraphics, ScreenRectangle rectangle, int border, int color) {
        return RenderUtils.renderHollowRectangle(guiGraphics, rectangle, border, false, color);
    }

    public static boolean renderHollowRectangle(GuiGraphics guiGraphics, ScreenRectangle rectangle, int border, boolean outer, int color) throws IllegalArgumentException {
        ScreenRectangle rect;
        ScreenRectangle screenRectangle = rect = outer ? new ScreenRectangle(rectangle.left() - border, rectangle.top() - border, rectangle.width() + border * 2, rectangle.height() + border * 2) : rectangle;
        if (outer || rect.width() - 2 * border > 0 && rect.height() - 2 * border > 0) {
            guiGraphics.fill(rect.left(), rect.top(), rect.left() + border, rect.bottom(), color);
            guiGraphics.fill(rect.right() - border, rect.top(), rect.right(), rect.bottom(), color);
            guiGraphics.fill(rect.left() + border, rect.top(), rect.right() - border, rect.top() + border, color);
            guiGraphics.fill(rect.left() + border, rect.bottom() - border, rect.right() - border, rect.bottom(), color);
            return true;
        }
        return false;
    }

    public static void renderScrollingString(GuiGraphics guiGraphics, int currentTick, Font font, Component component, boolean center, int minX, int minY, int maxX, int maxY, int width, int color) {
        RenderUtils.renderScrollingString(guiGraphics, currentTick, font, component.getVisualOrderText(), center, minX, minY, maxX, maxY, width, color);
    }

    public static void renderScrollingString(GuiGraphics guiGraphics, int currentTick, Font font, FormattedCharSequence sequence, boolean center, int minX, int minY, int maxX, int maxY, int width, int color) {
        int i = minX + width;
        int j = minX + maxX - width;
        RenderUtils.renderScrollingString(guiGraphics, currentTick, font, sequence, center, i, minY, j, minY + maxY, color);
    }

    private static void renderScrollingString(GuiGraphics guiGraphics, int currentTick, Font font, FormattedCharSequence sequence, boolean center, int minX, int minY, int maxX, int maxY, int color) {
        int i = font.width(sequence);
        int j = (minY + maxY - 9) / 2 + 1;
        int k = maxX - minX;
        if (i > k) {
            int l = i - k;
            double d0 = (double)currentTick / 70.0;
            double d1 = Math.max((double)l * 0.5, 3.0);
            double d2 = Math.sin(1.57 * Math.cos(6.28 * d0 / d1)) / 2.0 + 0.5;
            double d3 = Mth.lerp((double)d2, (double)0.0, (double)l);
            guiGraphics.enableScissor(minX, minY, maxX, maxY);
            guiGraphics.drawString(font, sequence, minX - (int)d3, j, color);
            guiGraphics.disableScissor();
        } else if (center) {
            guiGraphics.drawCenteredString(font, sequence, (minX + maxX) / 2, j, color);
        } else {
            guiGraphics.drawString(font, sequence, minX, j, color);
        }
    }
}

