/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.coolcatlib.api.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.ixdarklord.coolcatlib.api.util.SlotReference;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class InventoryHelper {
    public static boolean hasContainerMatchingItem(Container container, Item item) {
        for (int i = 0; i < container.getContainerSize(); ++i) {
            ItemStack stack = container.getItem(i);
            if (stack.isEmpty() || !stack.is(item)) continue;
            return true;
        }
        return false;
    }

    public static int findSlotMatchingItem(Container container, Item item) {
        for (int i = 0; i < container.getContainerSize(); ++i) {
            ItemStack stack = container.getItem(i);
            if (stack.isEmpty() || !stack.is(item)) continue;
            return i;
        }
        return -1;
    }

    public static List<ItemStack> listMatchingItem(Container container, Item item) {
        return InventoryHelper.listMatchingItem(container, (ItemStack stack) -> stack.is(item));
    }

    public static List<ItemStack> listMatchingItem(Container container, Predicate<ItemStack> predicate) {
        return InventoryHelper.listMatchingItemSlot(container, predicate).stream().map(SlotReference::getItem).toList();
    }

    public static List<SlotReference.Container> listMatchingItemSlot(Container container, Item item) {
        return InventoryHelper.listMatchingItemSlot(container, (ItemStack stack) -> stack.is(item));
    }

    public static List<SlotReference.Container> listMatchingItemSlot(Container container, Predicate<ItemStack> predicate) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < container.getContainerSize(); ++i) {
            ItemStack stack = container.getItem(i);
            if (!predicate.test(stack)) continue;
            list.add(new SlotReference.Container(container, i));
        }
        return Collections.unmodifiableList(list);
    }
}

