/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.coolcatlib.api.util;

import java.util.List;
import java.util.stream.Collectors;
import net.ixdarklord.coolcatlib.internal.chat.FormattedContentSink;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class ComponentHelper {
    public static Component toComponent(FormattedText formattedText) {
        return new FormattedContentSink(formattedText).getComponent();
    }

    public static Component toComponent(FormattedCharSequence formattedCharSequence) {
        return new FormattedContentSink(formattedCharSequence).getComponent();
    }

    public static String toString(FormattedText formattedText) {
        return new FormattedContentSink(formattedText).getString();
    }

    public static String toString(FormattedCharSequence formattedCharSequence) {
        return new FormattedContentSink(formattedCharSequence).getString();
    }

    public static Component limitComponent(Component component, int maxWidth) {
        String text = component.getString(maxWidth);
        return component.getString().length() >= maxWidth ? Component.literal((String)(text.substring(0, text.length() - 3) + "...")).withStyle(component.getStyle()) : component;
    }

    public static List<Component> splitComponent(Component component, int maxWidth) {
        Font font = Minecraft.getInstance().font;
        return font.getSplitter().splitLines((FormattedText)component, maxWidth, component.getStyle()).stream().map(text -> Component.literal((String)text.getString()).withStyle(component.getStyle())).collect(Collectors.toList());
    }
}

