/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.coolcatlib.api.util;

import java.awt.Color;
import net.minecraft.util.Mth;

public class ColorUtils {
    private final int rgb;

    public ColorUtils(int rgb) {
        this.rgb = rgb;
    }

    public float getAlpha() {
        return (float)(this.rgb >> 24 & 0xFF) / 255.0f;
    }

    public float getRed() {
        return (float)(this.rgb >> 16 & 0xFF) / 255.0f;
    }

    public float getGreen() {
        return (float)(this.rgb >> 8 & 0xFF) / 255.0f;
    }

    public float getBlue() {
        return (float)(this.rgb & 0xFF) / 255.0f;
    }

    public static void printColor(Color color) {
        System.out.printf("RGBA: %s,%s,%s,%s%n", color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public static int RGBToRGBA(int rgb, float alpha) {
        int channel = (int)Mth.lerp((float)Mth.clamp((float)alpha, (float)0.0f, (float)1.0f), (float)0.0f, (float)255.0f);
        channel = Math.min(255, Math.max(0, channel));
        return channel << 24 | rgb & 0xFFFFFF;
    }

    public static Color blendColors(Color color1, Color color2, double ratio) {
        int r = (int)((double)color1.getRed() * ratio + (double)color2.getRed() * (1.0 - ratio));
        int g = (int)((double)color1.getGreen() * ratio + (double)color2.getGreen() * (1.0 - ratio));
        int b = (int)((double)color1.getBlue() * ratio + (double)color2.getBlue() * (1.0 - ratio));
        return new Color(r, g, b);
    }
}

