/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.coolcatlib.api.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public class ComponentItem
extends Item {
    private final ResourceLocation itemID = BuiltInRegistries.ITEM.getKey((Object)this);
    private final ComponentType componentType;

    public ComponentItem(Item.Properties properties, ComponentType componentType) {
        super(properties);
        this.componentType = componentType;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (this.componentType.get() != null) {
            if (this.appendToName()) {
                MutableComponent name = tooltipComponents.getFirst().copy().append((Component)Component.literal((String)" | ").withStyle(ChatFormatting.DARK_GRAY).append(this.componentType.get()));
                tooltipComponents.set(0, (Component)name);
            } else {
                tooltipComponents.add((Component)Component.literal((String)"| ").withStyle(ChatFormatting.DARK_GRAY).append(this.componentType.get()));
            }
        }
    }

    public boolean appendToName() {
        return false;
    }

    public int getSplitterLength() {
        return Math.max(200, this.itemID.toString().length());
    }

    public boolean isShiftButtonNotPressed(@Nullable List<Component> tooltipComponents) {
        if (!Screen.hasShiftDown()) {
            if (tooltipComponents != null) {
                tooltipComponents.add((Component)Component.literal((String)"\u27a4 ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.translatable((String)"tooltip.coolcat_lib.press.shift").withStyle(ChatFormatting.GRAY)));
            }
            return true;
        }
        return false;
    }

    public static class ComponentType {
        public static ComponentType CRAFTING = new ComponentType((Component)Component.translatable((String)"tooltip.coolcat_lib.component.crafting").withStyle(ChatFormatting.DARK_PURPLE));
        public static ComponentType TOOLS = new ComponentType((Component)Component.translatable((String)"tooltip.coolcat_lib.component.tools").withStyle(ChatFormatting.DARK_PURPLE));
        public static ComponentType ABILITY = new ComponentType((Component)Component.translatable((String)"tooltip.coolcat_lib.component.ability").withStyle(ChatFormatting.DARK_PURPLE));
        private final Component component;

        public ComponentType(Component component) {
            this.component = component;
        }

        public Component get() {
            return this.component;
        }
    }
}

