/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.coolcatlib.api.event.v2.core;

import java.util.function.BiConsumer;
import net.ixdarklord.coolcatlib.internal.core.CoolCatLib;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public record EventPhase(ResourceLocation identifier, EventPhase parent, Ordering ordering) {
    static EventPhase DEFAULT = new EventPhase(ResourceLocation.fromNamespaceAndPath((String)"fabric", (String)"default"), null, null);
    static EventPhase BEFORE = new EventPhase(CoolCatLib.rl("before"), DEFAULT, Ordering.BEFORE);
    static EventPhase AFTER = new EventPhase(CoolCatLib.rl("after"), DEFAULT, Ordering.AFTER);
    static EventPhase FIRST = new EventPhase(CoolCatLib.rl("first"), BEFORE, Ordering.BEFORE);
    static EventPhase LAST = new EventPhase(CoolCatLib.rl("last"), AFTER, Ordering.AFTER);

    public void applyOrdering(BiConsumer<ResourceLocation, ResourceLocation> consumer) {
        this.ordering().apply(consumer, this.identifier(), this.parent().identifier());
    }

    static EventPhase early(EventPhase eventPhase) {
        return new EventPhase(CoolCatLib.rl("early_" + eventPhase.identifier().getPath()), eventPhase, Ordering.BEFORE);
    }

    static EventPhase late(EventPhase eventPhase) {
        return new EventPhase(CoolCatLib.rl("late_" + eventPhase.identifier().getPath()), eventPhase, Ordering.AFTER);
    }

    public static interface Ordering {
        public static final Ordering BEFORE = BiConsumer::accept;
        public static final Ordering AFTER = (consumer, first, second) -> consumer.accept(second, first);

        public void apply(BiConsumer<ResourceLocation, ResourceLocation> var1, ResourceLocation var2, ResourceLocation var3);
    }
}

