/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.coolcatlib.api.event.v2.core;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import net.ixdarklord.coolcatlib.api.event.v2.core.EventPhase;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface EventInvoker<T> {
    public static final Map<Class<?>, EventInvokerLike<?>> EVENT_INVOKER_LOOKUP = Collections.synchronizedMap(Maps.newIdentityHashMap());
    public static final Queue<Runnable> DEFERRED_INVOKER_REGISTRATIONS = Queues.newConcurrentLinkedQueue();
    public static final boolean initialized = false;

    public static <T> EventInvoker<T> lookup(Class<T> clazz) {
        return EventInvoker.lookup(clazz, null);
    }

    public static <T> EventInvoker<T> lookup(Class<T> clazz, @Nullable Object context) {
        return EventInvoker.softLookup(clazz, context);
    }

    public static <T> EventInvoker<T> softLookup(Class<T> clazz, @Nullable Object context) {
        Objects.requireNonNull(clazz, "type is null");
        Supplier invoker = Suppliers.memoize(() -> EventInvoker.lookupInvoker(clazz, context));
        return (arg_0, arg_1) -> EventInvoker.lambda$softLookup$2(clazz, (java.util.function.Supplier)invoker, arg_0, arg_1);
    }

    private static <T> EventInvoker<T> lookupInvoker(Class<T> clazz, @Nullable Object context) {
        Objects.requireNonNull(clazz, "type is null");
        EventInvokerLike<?> invokerLike = EVENT_INVOKER_LOOKUP.get(clazz);
        Objects.requireNonNull(invokerLike, "invoker is null for type " + String.valueOf(clazz));
        EventInvoker<?> invoker = invokerLike.asEventInvoker(context);
        Objects.requireNonNull(invoker, "invoker is null for type " + String.valueOf(clazz));
        return invoker;
    }

    public static <T> void register(Class<T> clazz, EventInvokerLike<T> invoker, boolean joinInvokers) {
        EventInvokerLike<?> other = EVENT_INVOKER_LOOKUP.get(clazz);
        if (other != null) {
            if (joinInvokers) {
                invoker = EventInvoker.join(invoker, other);
            } else {
                throw new IllegalArgumentException("Duplicate event invoker for type " + String.valueOf(clazz));
            }
        }
        EVENT_INVOKER_LOOKUP.put(clazz, invoker);
    }

    private static <T> EventInvokerLike<T> join(EventInvokerLike<T> invoker, EventInvokerLike<T> other) {
        return context -> (phase, callback) -> {
            invoker.asEventInvoker(context).register(phase, callback);
            other.asEventInvoker(context).register(phase, callback);
        };
    }

    default public void register(T callback) {
        this.register(EventPhase.DEFAULT, callback);
    }

    public void register(EventPhase var1, T var2);

    private static /* synthetic */ void lambda$softLookup$2(Class clazz, java.util.function.Supplier invoker, EventPhase phase, Object callback) {
        if (!EVENT_INVOKER_LOOKUP.containsKey(clazz)) {
            DEFERRED_INVOKER_REGISTRATIONS.offer(() -> EventInvoker.lambda$softLookup$1((java.util.function.Supplier)invoker, phase, callback));
        } else {
            ((EventInvoker)invoker.get()).register(phase, callback);
        }
    }

    private static /* synthetic */ void lambda$softLookup$1(java.util.function.Supplier invoker, EventPhase phase, Object callback) {
        ((EventInvoker)invoker.get()).register(phase, callback);
    }

    @FunctionalInterface
    public static interface EventInvokerLike<T> {
        public EventInvoker<T> asEventInvoker(@Nullable Object var1);
    }
}

