/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.coolcatlib.api.config;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class TomlConfigReader {
    private final Map<String, String> configMap = new HashMap<String, String>();
    private FileErrorState fileErrorState = FileErrorState.NO_ERROR;

    public TomlConfigReader(String modName, String filePath) {
        this.parseTOMLFile(filePath);
    }

    private void parseTOMLFile(String filePath) {
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String line;
            String currentSection = "";
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                if (line.startsWith("[")) {
                    Matcher matcher = Pattern.compile("\\[(.*?)]").matcher(line);
                    if (!matcher.find()) continue;
                    currentSection = matcher.group(1);
                    continue;
                }
                String[] parts = line.split("=", 2);
                if (parts.length != 2) continue;
                String key = currentSection + "." + parts[0].trim();
                String value = parts[1].trim();
                this.configMap.put(key, value);
            }
        }
        catch (FileNotFoundException e) {
            this.fileErrorState = FileErrorState.FILE_NOT_FOUND;
        }
        catch (IOException e) {
            this.fileErrorState = FileErrorState.UNABLE_TO_READ;
        }
        catch (Exception e) {
            this.fileErrorState = FileErrorState.UNEXPECTED_ERROR;
        }
    }

    @Nullable
    public String getResult(String key) {
        if (this.fileErrorState != FileErrorState.NO_ERROR) {
            return null;
        }
        return this.configMap.get(key);
    }

    public Map<String, String> getConfigMap() {
        return this.configMap;
    }

    public boolean hasErrorOccurred() {
        return this.fileErrorState != FileErrorState.NO_ERROR;
    }

    public FileErrorState getFileErrorState() {
        return this.fileErrorState;
    }

    public static enum FileErrorState {
        NO_ERROR,
        FILE_NOT_FOUND,
        UNABLE_TO_READ,
        UNEXPECTED_ERROR;

    }
}

