/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.coolcatlib.api.client.gui.components;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.ixdarklord.coolcatlib.api.util.ColorUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class TextScreen
extends GuiGraphics {
    private final List<ScreenComponent> componentList;
    private final Font font;
    private final int posX;
    private final int posY;
    private int width;
    private int height;
    private final boolean drawShadow;
    private int widthOld = -1;
    private int heightOld = -1;
    private int screenIndex;

    private TextScreen(boolean drawShadow, int posX, int posY, int width, int height, List<ScreenComponent> componentList) {
        super(Minecraft.getInstance(), MultiBufferSource.immediate((ByteBufferBuilder)new ByteBufferBuilder(256)));
        this.posX = posX;
        this.posY = posY;
        this.width = width;
        this.height = height;
        this.componentList = componentList;
        this.drawShadow = drawShadow;
        this.font = Minecraft.getInstance().font;
        this.screenIndex = -1;
    }

    public static TextScreen build(int posX, int posY, int width, int height, boolean drawShadow, int amountOfScreens) {
        ArrayList components = Lists.newArrayList();
        for (int i = 0; i < amountOfScreens; ++i) {
            components.add(new ScreenComponent(Lists.newArrayList(), false, i == 0));
        }
        return new TextScreen(drawShadow, posX, posY, width, height, Collections.unmodifiableList(components)).selectScreen(0);
    }

    public TextScreen selectScreen(int index) {
        if (index >= this.componentList.size() || index < 0) {
            throw new IllegalArgumentException("Theres is no such a screen with index: " + index);
        }
        this.screenIndex = index;
        return this;
    }

    public TextScreen selectLastScreen(boolean shouldBeRendered) {
        this.screenIndex = Math.max(0, this.componentList.stream().filter(component -> !shouldBeRendered || component.render).toList().size() - 1);
        return this;
    }

    public TextScreen shouldRender(boolean value) {
        if (this.screenIndex == -1) {
            throw new IllegalArgumentException("There is no selected box.");
        }
        this.componentList.get((int)this.screenIndex).render = value;
        return this;
    }

    public TextScreen alignToCenter(boolean value) {
        if (this.screenIndex == -1) {
            throw new IllegalArgumentException("There is no selected box.");
        }
        this.componentList.get((int)this.screenIndex).centered = value;
        return this;
    }

    public TextScreen backgroundColor(Color colorRGBA) {
        if (this.screenIndex == -1) {
            throw new IllegalArgumentException("There is no selected box.");
        }
        this.componentList.get((int)this.screenIndex).backgroundColor = colorRGBA;
        return this;
    }

    public void renderAllBoxes(GuiGraphics guiGraphics, int backgroundColor, Color shaderColor) {
        if (this.componentList.isEmpty()) {
            throw new IllegalArgumentException("There is no screens created.");
        }
        for (int i = 0; i < this.componentList.size(); ++i) {
            ScreenComponent screen = this.componentList.get(i);
            if (!screen.render) continue;
            this.renderScreen(i, guiGraphics);
            int renderEnabledScreens = this.componentList.stream().filter(box -> box.render).toList().size();
            if (renderEnabledScreens <= 1 || i >= this.componentList.size() - 1) continue;
            Color bgColor = this.componentList.get((int)(i + 1)).backgroundColor;
            int color = bgColor != null ? ColorUtils.RGBToRGBA(bgColor.getRGB(), (float)bgColor.getAlpha() / 255.0f) : ColorUtils.RGBToRGBA(backgroundColor, 0.85f);
            int width = this.widthOld > 1 ? this.widthOld : this.width;
            int height = this.heightOld > 1 ? this.heightOld : this.height;
            RenderSystem.setShaderColor((float)((float)shaderColor.getRed() / 255.0f), (float)((float)shaderColor.getGreen() / 255.0f), (float)((float)shaderColor.getBlue() / 255.0f), (float)((float)shaderColor.getAlpha() / 255.0f));
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 1.0f * (float)(i + 1));
            this.fill(RenderType.guiOverlay(), this.posX - 1, this.posY - 1, this.posX + width, this.posY + height, color);
            guiGraphics.pose().popPose();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void renderScreen(GuiGraphics guiGraphics) {
        this.renderScreen(this.screenIndex, guiGraphics);
    }

    public void renderScreen(int screenIndex, GuiGraphics guiGraphics) {
        if (screenIndex == -1) {
            throw new IllegalArgumentException("Invalid Selected Screen! Index: " + screenIndex);
        }
        ScreenComponent screen = this.componentList.get(screenIndex);
        if (!screen.render) {
            return;
        }
        List<FormattedCharSequence> selected = screen.sequences;
        int scrollOffset = screen.scrollOffset;
        int length = this.getScreenLinesLength(screenIndex);
        screen.scrollOffset = Mth.clamp((int)screen.scrollOffset, (int)0, (int)(selected.size() - length));
        for (int m = 0; m < length; ++m) {
            FormattedCharSequence sequences = selected.get(Math.min(m + scrollOffset, selected.size() - 1));
            float posX = this.posX;
            float posY = this.posY;
            int color = Objects.requireNonNull(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.WHITE)).getValue();
            guiGraphics.pose().pushPose();
            if (screen.centered) {
                posY += (float)this.height / 2.0f;
                float k = (float)this.font.width(sequences) / 2.0f;
                float j = (float)selected.size() * 7.35f / 2.0f;
                int n = (int)((posX += (float)this.width / 2.0f) - k);
                Objects.requireNonNull(this.font);
                this.drawString(this.font, sequences, n, (int)(posY - j + (float)(9 * m)), color, this.drawShadow);
            } else {
                int n = (int)posX;
                Objects.requireNonNull(this.font);
                this.drawString(this.font, sequences, n, (int)(posY + (float)(m * 9)), color, this.drawShadow);
            }
            guiGraphics.pose().popPose();
        }
    }

    public void scrollTo(int pos, boolean replace) {
        this.scrollTo(this.screenIndex, pos, replace);
    }

    public void scrollTo(int screenIndex, int pos, boolean replace) {
        if (screenIndex == -1) {
            throw new IllegalArgumentException("Invalid Selected Screen! Index: " + screenIndex);
        }
        List<FormattedCharSequence> selected = this.componentList.get((int)screenIndex).sequences;
        this.componentList.get((int)screenIndex).scrollOffset = replace ? pos : this.componentList.get((int)screenIndex).scrollOffset + pos;
        this.componentList.get((int)screenIndex).scrollOffset = Mth.clamp((int)this.componentList.get((int)screenIndex).scrollOffset, (int)0, (int)(selected.size() - this.getScreenLinesLength()));
    }

    public Style getComponentStyleAt(double mouseX, double mouseY) {
        return this.getComponentStyleAt(this.screenIndex, mouseX, mouseY);
    }

    public Style getComponentStyleAt(int screenIndex, double mouseX, double mouseY) {
        int linePos;
        if (screenIndex == -1) {
            throw new IllegalArgumentException("Invalid Selected Screen! Index: " + screenIndex);
        }
        List<FormattedCharSequence> selected = this.componentList.get((int)screenIndex).sequences;
        int offset = this.componentList.get((int)screenIndex).scrollOffset;
        if (selected.isEmpty()) {
            return null;
        }
        int i = Mth.floor((double)(mouseX - (double)this.posX));
        int j = Mth.floor((double)(mouseY - (double)this.posY));
        if (i < 0 || j < 0) {
            return null;
        }
        if (i > this.width || j > this.height) {
            return null;
        }
        if (this.componentList.get((int)screenIndex).centered) {
            int textBoxHeight = this.height;
            Objects.requireNonNull(this.font);
            int lineHeight = 9;
            int totalLines = selected.size();
            int centerOffset = (textBoxHeight - totalLines * lineHeight) / 2;
            if ((j -= 2) < centerOffset || j > centerOffset + totalLines * lineHeight) {
                return null;
            }
            linePos = (j - centerOffset) / lineHeight;
        } else {
            Objects.requireNonNull(this.font);
            Objects.requireNonNull(this.font);
            if (j >= 9 * Math.min(this.height / 9, selected.size())) {
                return null;
            }
            Objects.requireNonNull(this.font);
            linePos = j / 9;
        }
        if (linePos >= selected.size()) {
            return null;
        }
        FormattedCharSequence sequence = selected.get(Math.min(linePos + offset, selected.size() - 1));
        if (this.componentList.get((int)screenIndex).centered) {
            int textBoxWidth = this.width / 2;
            int lineWidth = this.font.width(sequence) / 2;
            i -= textBoxWidth - lineWidth;
        }
        return this.font.getSplitter().componentStyleAtWidth(sequence, i);
    }

    public boolean canScroll() {
        return this.canScroll(this.screenIndex);
    }

    public boolean canScroll(int screenIndex) {
        if (screenIndex == -1) {
            throw new IllegalArgumentException("Invalid Selected Screen! Index: " + screenIndex);
        }
        Objects.requireNonNull(this.font);
        return this.height / 9 < this.componentList.get((int)screenIndex).sequences.size();
    }

    public boolean isEmpty() {
        if (this.screenIndex == -1) {
            throw new IllegalArgumentException("Invalid Selected Screen! Index: " + this.screenIndex);
        }
        return this.componentList.get((int)this.screenIndex).sequences.isEmpty();
    }

    public TextScreen create(String text, ChatFormatting ... formats) {
        return this.create((Component)Component.literal((String)text), formats);
    }

    public TextScreen create(Component text, ChatFormatting ... formats) {
        return this.create(text, (Component)null, formats);
    }

    public TextScreen create(Component title, Component description, ChatFormatting ... formats) {
        if (this.screenIndex == -1) {
            throw new IllegalArgumentException("Invalid Selected Screen! Index: " + this.screenIndex);
        }
        ArrayList result = Lists.newArrayList();
        result.addAll(Language.getInstance().getVisualOrder(this.font.getSplitter().splitLines((FormattedText)title, this.width, Style.EMPTY.applyFormats(formats))));
        if (description != null) {
            result.addAll(Language.getInstance().getVisualOrder(this.font.getSplitter().splitLines((FormattedText)description, this.width, Style.EMPTY.applyFormats(formats))));
        }
        if (!this.componentList.get((int)this.screenIndex).sequences.isEmpty()) {
            return this.add(FormattedCharSequence.EMPTY).addAll(result);
        }
        return this.addAll(result);
    }

    public TextScreen add(FormattedCharSequence formattedCharSequence) {
        if (this.screenIndex == -1) {
            throw new IllegalArgumentException("Invalid Selected Screen! Index: " + this.screenIndex);
        }
        this.componentList.get((int)this.screenIndex).sequences.add(formattedCharSequence);
        return this;
    }

    public TextScreen addAll(List<FormattedCharSequence> formattedCharSequences) {
        if (this.screenIndex == -1) {
            throw new IllegalArgumentException("Invalid Selected Screen! Index: " + this.screenIndex);
        }
        this.componentList.get((int)this.screenIndex).sequences.addAll(formattedCharSequences);
        return this;
    }

    public void clear() {
        this.componentList.forEach(component -> {
            component.sequences.clear();
            component.backgroundColor = null;
        });
    }

    public boolean canRender() {
        return this.componentList.get((int)this.screenIndex).render;
    }

    public int getScreenLinesLength() {
        return this.getScreenLinesLength(this.screenIndex);
    }

    public int getScreenLinesLength(int screenIndex) {
        if (screenIndex == -1) {
            throw new IllegalArgumentException("Invalid Selected Screen! Index: " + screenIndex);
        }
        Objects.requireNonNull(this.font);
        return Math.min(this.height / 9, this.componentList.get((int)screenIndex).sequences.size());
    }

    public int getRemainingLines() {
        return this.getRemainingLines(this.screenIndex);
    }

    public int getRemainingLines(int screenIndex) {
        if (screenIndex == -1) {
            throw new IllegalArgumentException("Invalid Selected Screen! Index: " + screenIndex);
        }
        return this.componentList.get((int)screenIndex).sequences.size() - this.getScreenLinesLength();
    }

    public int getScrollOffset() {
        return this.getScrollOffset(this.screenIndex);
    }

    public int getScrollOffset(int screenIndex) {
        if (screenIndex == -1) {
            throw new IllegalArgumentException("Invalid Selected Screen! Index: " + screenIndex);
        }
        return this.componentList.get((int)screenIndex).scrollOffset;
    }

    public List<ScreenComponent> getComponentList() {
        return this.componentList;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setWidth(int size, boolean cacheFirstValue) {
        if (cacheFirstValue && this.widthOld == -1) {
            this.widthOld = this.width;
        }
        this.width = size;
    }

    public void setHeight(int size, boolean cacheFirstValue) {
        if (cacheFirstValue && this.heightOld == -1) {
            this.heightOld = this.height;
        }
        this.height = size;
    }

    public static class ScreenComponent {
        private final List<FormattedCharSequence> sequences;
        private boolean centered;
        private boolean render;
        private Color backgroundColor;
        private int scrollOffset;

        private ScreenComponent(List<FormattedCharSequence> sequences, boolean centered, boolean render) {
            this.sequences = sequences;
            this.centered = centered;
            this.render = render;
        }
    }
}

