/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.init;

import codechicken.enderstorage.client.render.item.EnderChestItemRender;
import codechicken.enderstorage.client.render.item.EnderTankItemRender;
import codechicken.enderstorage.init.EnderStorageModContent;
import codechicken.enderstorage.recipe.CreateRecipe;
import codechicken.enderstorage.recipe.ReColourRecipe;
import codechicken.lib.colour.EnumColour;
import codechicken.lib.datagen.ItemModelProvider;
import codechicken.lib.datagen.recipe.RecipeProvider;
import codechicken.lib.util.CCLTags;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.Nullable;

public class DataGenerators {
    private static final CrashLock LOCK = new CrashLock("Already Initialized.");

    public static void init(IEventBus modBus) {
        LOCK.lock();
        modBus.addListener(DataGenerators::gatherDataGenerators);
    }

    private static void gatherDataGenerators(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        ExistingFileHelper files = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        gen.addProvider(event.includeClient(), (DataProvider)new BlockStates(output, files));
        gen.addProvider(event.includeClient(), (DataProvider)new ItemModels(output, files));
        gen.addProvider(event.includeServer(), (DataProvider)new BlockTagGen(output, lookupProvider, files));
        gen.addProvider(event.includeServer(), (DataProvider)new Recipes(lookupProvider, output));
    }

    private static class BlockStates
    extends BlockStateProvider {
        public BlockStates(PackOutput output, ExistingFileHelper exFileHelper) {
            super(output, "enderstorage", exFileHelper);
        }

        protected void registerStatesAndModels() {
            ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent("dummy", "block")).texture("particle", "minecraft:block/obsidian");
            this.simpleBlock((Block)EnderStorageModContent.ENDER_CHEST_BLOCK.get(), (ModelFile)model);
            this.simpleBlock((Block)EnderStorageModContent.ENDER_TANK_BLOCK.get(), (ModelFile)model);
        }
    }

    private static class ItemModels
    extends ItemModelProvider {
        public ItemModels(PackOutput output, ExistingFileHelper existingFileHelper) {
            super(output, "enderstorage", existingFileHelper);
        }

        protected void registerModels() {
            this.clazz((Supplier)EnderStorageModContent.ENDER_CHEST_ITEM, EnderChestItemRender.class);
            this.clazz((Supplier)EnderStorageModContent.ENDER_TANK_ITEM, EnderTankItemRender.class);
            ItemModelProvider.CompositeLoaderBuilder bag = ((ItemModelProvider.CompositeLoaderBuilder)this.generated((Supplier)EnderStorageModContent.ENDER_POUCH).noTexture().customLoader(ItemModelProvider.CompositeLoaderBuilder::ccl)).nested("bag", e -> {
                e.parent((ModelFile)GENERATED).noTexture();
                e.override(o -> {
                    o.predicate(this.modLoc("open"), 0.0f);
                    o.predicate(this.modLoc("owned"), 0.0f);
                    o.model("ender_pouch_closed", m -> m.parent((ModelFile)GENERATED).texture("layer0", this.modLoc("item/pouch/closed")));
                });
                e.override(o -> {
                    o.predicate(this.modLoc("open"), 1.0f);
                    o.predicate(this.modLoc("owned"), 0.0f);
                    o.model("ender_pouch_open", m -> m.parent((ModelFile)GENERATED).texture("layer0", this.modLoc("item/pouch/open")));
                });
                e.override(o -> {
                    o.predicate(this.modLoc("open"), 0.0f);
                    o.predicate(this.modLoc("owned"), 1.0f);
                    o.model("ender_pouch_owned_closed", m -> m.parent((ModelFile)GENERATED).texture("layer0", this.modLoc("item/pouch/owned_closed")));
                });
                e.override(o -> {
                    o.predicate(this.modLoc("open"), 1.0f);
                    o.predicate(this.modLoc("owned"), 1.0f);
                    o.model("ender_pouch_owned_open", m -> m.parent((ModelFile)GENERATED).texture("layer0", this.modLoc("item/pouch/owned_open")));
                });
            });
            for (String side : new String[]{"left", "middle", "right"}) {
                bag.nested(side, e -> {
                    e.parent((ModelFile)GENERATED).noTexture();
                    for (EnumColour colour : EnumColour.values()) {
                        String col = colour.getSerializedName();
                        e.override(o -> {
                            o.predicate(this.modLoc(side), (float)colour.ordinal());
                            o.model("ender_pouch_button_" + side + "_" + col, m -> m.parent((ModelFile)GENERATED).texture(this.modLoc("item/pouch/buttons/" + side + "/" + col)));
                        });
                    }
                });
            }
        }

        public String getName() {
            return "EnderStorage Item models";
        }
    }

    private static class BlockTagGen
    extends BlockTagsProvider {
        public BlockTagGen(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, "enderstorage", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider pProvider) {
            this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object)((Block)EnderStorageModContent.ENDER_CHEST_BLOCK.get())).add((Object)((Block)EnderStorageModContent.ENDER_TANK_BLOCK.get()));
        }
    }

    private static class Recipes
    extends RecipeProvider {
        public Recipes(CompletableFuture<HolderLookup.Provider> lookupProvider, PackOutput output) {
            super(lookupProvider, output, "enderstorage");
        }

        protected void registerRecipes() {
            this.customShaped((Supplier)EnderStorageModContent.ENDER_POUCH, (group, category, pattern, stack, showNotification) -> new CreateRecipe(group, pattern, stack)).key('P', Tags.Items.ENDER_PEARLS).key('L', Tags.Items.LEATHERS).key('B', (ItemLike)Items.BLAZE_POWDER).key('W', CCLTags.Items.WOOLS).patternLine("BLB").patternLine("LPL").patternLine("BWB");
            this.customShaped((Supplier)EnderStorageModContent.ENDER_CHEST_ITEM, (group, category, pattern, stack, showNotification) -> new CreateRecipe(group, pattern, stack)).key('P', Tags.Items.ENDER_PEARLS).key('O', Tags.Items.OBSIDIANS).key('C', Tags.Items.CHESTS_WOODEN).key('B', (ItemLike)Items.BLAZE_ROD).key('W', CCLTags.Items.WOOLS).patternLine("BWB").patternLine("OCO").patternLine("BPB");
            this.customShaped((Supplier)EnderStorageModContent.ENDER_TANK_ITEM, (group, category, pattern, stack, showNotification) -> new CreateRecipe(group, pattern, stack)).key('P', Tags.Items.ENDER_PEARLS).key('O', Tags.Items.OBSIDIANS).key('C', (ItemLike)Items.CAULDRON).key('B', (ItemLike)Items.BLAZE_ROD).key('W', CCLTags.Items.WOOLS).patternLine("BWB").patternLine("OCO").patternLine("BPB");
            this.special(ResourceLocation.fromNamespaceAndPath((String)"enderstorage", (String)"recolour_ender_pouch"), () -> new ReColourRecipe(new ItemStack((ItemLike)EnderStorageModContent.ENDER_POUCH.get())));
            this.special(ResourceLocation.fromNamespaceAndPath((String)"enderstorage", (String)"recolour_ender_chest"), () -> new ReColourRecipe(new ItemStack((ItemLike)EnderStorageModContent.ENDER_CHEST_ITEM.get())));
            this.special(ResourceLocation.fromNamespaceAndPath((String)"enderstorage", (String)"recolour_ender_tank"), () -> new ReColourRecipe(new ItemStack((ItemLike)EnderStorageModContent.ENDER_TANK_ITEM.get())));
        }
    }
}

