/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.shaded.oshi.hardware.platform.mac;

import com.hypherionmc.sdlink.shaded.oshi.annotation.concurrent.Immutable;
import com.hypherionmc.sdlink.shaded.oshi.hardware.Display;
import com.hypherionmc.sdlink.shaded.oshi.hardware.common.AbstractDisplay;
import com.sun.jna.Pointer;
import com.sun.jna.platform.mac.CoreFoundation;
import com.sun.jna.platform.mac.IOKit;
import com.sun.jna.platform.mac.IOKitUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
final class MacDisplay
extends AbstractDisplay {
    private static final Logger LOG = LoggerFactory.getLogger(MacDisplay.class);

    MacDisplay(byte[] edid) {
        super(edid);
        LOG.debug("Initialized MacDisplay");
    }

    public static List<Display> getDisplays() {
        ArrayList<Display> displays = new ArrayList<Display>();
        IOKit.IOIterator serviceIterator = IOKitUtil.getMatchingServices((String)"IODisplayConnect");
        if (serviceIterator != null) {
            CoreFoundation.CFStringRef cfEdid = CoreFoundation.CFStringRef.createCFString((String)"IODisplayEDID");
            IOKit.IORegistryEntry sdService = serviceIterator.next();
            while (sdService != null) {
                IOKit.IORegistryEntry properties = sdService.getChildEntry("IOService");
                if (properties != null) {
                    CoreFoundation.CFTypeRef edidRaw = properties.createCFProperty(cfEdid);
                    if (edidRaw != null) {
                        CoreFoundation.CFDataRef edid = new CoreFoundation.CFDataRef(edidRaw.getPointer());
                        int length = edid.getLength();
                        Pointer p = edid.getBytePtr();
                        displays.add(new MacDisplay(p.getByteArray(0L, length)));
                        edid.release();
                    }
                    properties.release();
                }
                sdService.release();
                sdService = serviceIterator.next();
            }
            serviceIterator.release();
            cfEdid.release();
        }
        return displays;
    }
}

