/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.automod.build;

import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.automod.AutoModRule;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.automod.AutoModTriggerType;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.automod.build.AbstractKeywordTriggerConfig;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.utils.data.DataObject;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.internal.utils.Checks;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.internal.utils.Helpers;
import com.hypherionmc.sdlink.shaded.javax.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;

public class PresetKeywordTriggerConfig
extends AbstractKeywordTriggerConfig<PresetKeywordTriggerConfig> {
    private final EnumSet<AutoModRule.KeywordPreset> presets = EnumSet.noneOf(AutoModRule.KeywordPreset.class);

    protected PresetKeywordTriggerConfig() {
        super(AutoModTriggerType.KEYWORD_PRESET);
    }

    @Nonnull
    public PresetKeywordTriggerConfig enablePresets(AutoModRule.KeywordPreset ... presets) {
        Checks.notNull(presets, "Presets");
        for (AutoModRule.KeywordPreset preset : presets) {
            PresetKeywordTriggerConfig.checkKnown(preset);
        }
        Collections.addAll(this.presets, presets);
        return this;
    }

    @Nonnull
    public PresetKeywordTriggerConfig enablePresets(@Nonnull Collection<AutoModRule.KeywordPreset> presets) {
        Checks.notNull(presets, "Presets");
        presets.forEach(PresetKeywordTriggerConfig::checkKnown);
        this.presets.addAll(presets);
        return this;
    }

    @Nonnull
    public PresetKeywordTriggerConfig disablePresets(AutoModRule.KeywordPreset ... presets) {
        Checks.noneNull((Object[])presets, "Presets");
        for (AutoModRule.KeywordPreset preset : presets) {
            this.presets.remove((Object)preset);
        }
        return this;
    }

    @Nonnull
    public PresetKeywordTriggerConfig disablePresets(@Nonnull Collection<AutoModRule.KeywordPreset> presets) {
        Checks.noneNull(presets, "Presets");
        this.presets.removeAll(presets);
        return this;
    }

    @Override
    protected int maxAllowListAmount() {
        return 1000;
    }

    private static void checkKnown(AutoModRule.KeywordPreset preset) {
        Checks.notNull((Object)preset, "Presets");
        Checks.check(preset != AutoModRule.KeywordPreset.UNKNOWN, "Cannot use unknown preset");
    }

    @Override
    @Nonnull
    public DataObject toData() {
        DataObject data = super.toData();
        data.put("presets", this.presets.stream().map(AutoModRule.KeywordPreset::getKey).collect(Helpers.toDataArray()));
        return data;
    }
}

