/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.core.managers;

import com.hypherionmc.sdlink.api.messaging.MessageType;
import com.hypherionmc.sdlink.core.config.SDLinkConfig;
import com.hypherionmc.sdlink.core.config.impl.MessageChannelConfig;
import com.hypherionmc.sdlink.core.discord.BotController;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.JDA;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.Member;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.channel.ChannelType;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.emoji.RichCustomEmoji;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;

public final class CacheManager {
    private static final HashMap<String, String> serverChannels = new HashMap();
    private static final HashMap<String, String> serverRoles = new HashMap();
    private static final HashMap<String, String> userCache = new HashMap();
    private static final Set<Member> discordMembers = new HashSet<Member>();
    private static final HashMap<String, RichCustomEmoji> customEmotes = new HashMap();
    public static final HashMap<MessageType, MessageChannelConfig.DestinationObject> messageDestinations = new HashMap();

    public static void loadCache() {
        CacheManager.loadChannelCache();
        CacheManager.loadRoleCache();
        CacheManager.loadUserCache();
        CacheManager.loadEmoteCache();
    }

    public static void loadChannelCache() {
        CacheManager.reloadChannelConfigCache();
        serverChannels.clear();
        JDA jda = BotController.INSTANCE.getJDA();
        if (jda.getGuilds().isEmpty()) {
            return;
        }
        jda.getGuilds().get(0).getChannels(false).forEach(c -> {
            if (c.getType() != ChannelType.CATEGORY) {
                serverChannels.put("#" + c.getName(), c.getAsMention());
            }
        });
    }

    public static void loadRoleCache() {
        serverRoles.clear();
        JDA jda = BotController.INSTANCE.getJDA();
        if (jda.getGuilds().isEmpty()) {
            return;
        }
        jda.getGuilds().get(0).getRoles().forEach(r -> {
            if (r.isMentionable() && !r.isManaged()) {
                serverRoles.put("@" + r.getName(), r.getAsMention());
            }
        });
    }

    public static void loadUserCache() {
        userCache.clear();
        discordMembers.clear();
        JDA jda = BotController.INSTANCE.getJDA();
        if (jda.getGuilds().isEmpty()) {
            return;
        }
        jda.getGuilds().get(0).getMembers().forEach(r -> {
            userCache.put("@" + r.getEffectiveName(), r.getAsMention());
            discordMembers.add((Member)r);
        });
    }

    public static void loadEmoteCache() {
        customEmotes.clear();
        JDA jda = BotController.INSTANCE.getJDA();
        if (jda.getGuilds().isEmpty()) {
            return;
        }
        jda.getGuilds().get(0).getEmojis().forEach(e -> customEmotes.put(":" + e.getName() + ":", (RichCustomEmoji)e));
    }

    public static void reloadChannelConfigCache() {
        try {
            messageDestinations.clear();
            messageDestinations.put(MessageType.CHAT, SDLinkConfig.INSTANCE.messageDestinations.chat);
            messageDestinations.put(MessageType.START, SDLinkConfig.INSTANCE.messageDestinations.start);
            messageDestinations.put(MessageType.STOP, SDLinkConfig.INSTANCE.messageDestinations.stop);
            messageDestinations.put(MessageType.JOIN, SDLinkConfig.INSTANCE.messageDestinations.join);
            messageDestinations.put(MessageType.LEAVE, SDLinkConfig.INSTANCE.messageDestinations.leave);
            messageDestinations.put(MessageType.ADVANCEMENTS, SDLinkConfig.INSTANCE.messageDestinations.advancements);
            messageDestinations.put(MessageType.DEATH, SDLinkConfig.INSTANCE.messageDestinations.death);
            messageDestinations.put(MessageType.COMMANDS, SDLinkConfig.INSTANCE.messageDestinations.commands);
            messageDestinations.put(MessageType.WHITELIST, SDLinkConfig.INSTANCE.messageDestinations.whitelist);
            messageDestinations.put(MessageType.CUSTOM, SDLinkConfig.INSTANCE.messageDestinations.custom);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Generated
    public static HashMap<String, String> getServerChannels() {
        return serverChannels;
    }

    @Generated
    public static HashMap<String, String> getServerRoles() {
        return serverRoles;
    }

    @Generated
    public static HashMap<String, String> getUserCache() {
        return userCache;
    }

    @Generated
    public static Set<Member> getDiscordMembers() {
        return discordMembers;
    }

    @Generated
    public static HashMap<String, RichCustomEmoji> getCustomEmotes() {
        return customEmotes;
    }

    @Generated
    public static HashMap<MessageType, MessageChannelConfig.DestinationObject> getMessageDestinations() {
        return messageDestinations;
    }
}

