/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.api.messaging;

import com.hypherionmc.sdlink.util.translations.Text;
import lombok.Generated;

public final class Result {
    private final Type type;
    private final String message;

    private Result(Type type, String message) {
        this.type = type;
        this.message = message;
    }

    public static Result success(Text text) {
        return Result.success(text.toString());
    }

    public static Result success(String message) {
        return new Result(Type.SUCCESS, message);
    }

    public static Result error(Text text) {
        return Result.error(text.toString());
    }

    public static Result error(String message) {
        return new Result(Type.ERROR, message);
    }

    public boolean isError() {
        return this.type == Type.ERROR;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    static enum Type {
        ERROR,
        SUCCESS;

    }
}

