/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.sky_aesthetics.client.skies.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import fr.tathan.SkyAesthetics;
import fr.tathan.sky_aesthetics.client.skies.record.CloudSettings;
import fr.tathan.sky_aesthetics.client.skies.record.CustomVanillaObject;
import fr.tathan.sky_aesthetics.client.skies.record.SkyObject;
import fr.tathan.sky_aesthetics.client.skies.record.SkyProperties;
import fr.tathan.sky_aesthetics.client.skies.record.Star;
import fr.tathan.sky_aesthetics.client.skies.utils.ShootingStar;
import fr.tathan.sky_aesthetics.client.skies.utils.SkyHelper;
import fr.tathan.sky_aesthetics.client.skies.utils.StarHelper;
import fr.tathan.sky_aesthetics.helper.PlatformHelper;
import fr.tathan.sky_aesthetics.helper.SkyCompat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class SkyRenderer {
    private final SkyProperties properties;
    private VertexBuffer starBuffer = null;
    private final Map<UUID, ShootingStar> shootingStars;

    public SkyRenderer(SkyProperties properties) {
        this.properties = properties;
        if (properties.stars().count() > 100) {
            this.starBuffer = StarHelper.createStars(properties.stars().scale(), properties.stars().count(), (int)properties.stars().color().x(), (int)properties.stars().color().y(), (int)properties.stars().color().z(), properties.constellations(), properties.stars().starsTexture());
        } else if (properties.stars().vanilla()) {
            this.starBuffer = StarHelper.createVanillaStars();
        }
        this.shootingStars = new HashMap<UUID, ShootingStar>();
    }

    public void render(ClientLevel level, PoseStack poseStack, Matrix4f projectionMatrix, float partialTick, Camera camera, Runnable fogCallback) {
        if (!this.isSkyRendered()) {
            return;
        }
        this.runFogCallback(fogCallback);
        Tesselator tesselator = Tesselator.getInstance();
        CustomVanillaObject customVanillaObject = null;
        if (this.properties.customVanillaObject().isPresent()) {
            customVanillaObject = this.properties.customVanillaObject().get();
        }
        float dayAngle = level.getTimeOfDay(partialTick) * 360.0f % 360.0f;
        float nightAngle = dayAngle + 180.0f;
        Vec3 vec3 = level.getSkyColor(camera.getPosition(), partialTick);
        Vector4f vec4 = new Vector4f((float)vec3.x, (float)vec3.y, (float)vec3.z, 1.0f);
        if (this.properties.skyColor().customColor() && this.properties.skyColor().color().isPresent()) {
            vec4 = this.properties.skyColor().color().get();
        }
        FogRenderer.levelFogColor();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShaderColor((float)vec4.x, (float)vec4.y, (float)vec4.z, (float)vec4.w);
        ShaderInstance shaderInstance = RenderSystem.getShader();
        if (Objects.equals(this.properties.skyType(), "NORMAL")) {
            SkyHelper.drawSky(poseStack.last().pose(), projectionMatrix, shaderInstance);
        } else if (Objects.equals(this.properties.skyType(), "END")) {
            SkyHelper.renderEndSky(poseStack);
        }
        this.renderStars(level, partialTick, poseStack, projectionMatrix, fogCallback, nightAngle);
        this.properties.stars().shootingStars().ifPresent(shootingStar -> this.handleShootingStars(level, poseStack, projectionMatrix, this.properties.stars(), partialTick));
        if (customVanillaObject != null) {
            if (customVanillaObject.sun() && customVanillaObject.sunTexture().isPresent() && customVanillaObject.sunHeight().isPresent() && customVanillaObject.sunSize().isPresent()) {
                SkyHelper.drawCelestialBody(customVanillaObject.sunTexture().get(), tesselator, poseStack, customVanillaObject.sunHeight().get().floatValue(), customVanillaObject.sunSize().get().floatValue(), dayAngle, true);
            }
            if (customVanillaObject.moon()) {
                if (PlatformHelper.isModLoaded("lunar")) {
                    SkyCompat.drawLunarSky(level, tesselator, poseStack, customVanillaObject.moonSize().get().floatValue(), nightAngle);
                } else if (customVanillaObject.moonPhase()) {
                    SkyHelper.drawMoonWithPhase(tesselator, poseStack, customVanillaObject.moonSize().get().floatValue(), customVanillaObject, nightAngle);
                } else {
                    SkyHelper.drawCelestialBody(customVanillaObject.moonTexture().get(), tesselator, poseStack, customVanillaObject.moonHeight().get().floatValue(), customVanillaObject.moonSize().get().floatValue(), nightAngle, 0.0f, 1.0f, 0.0f, 1.0f, false);
                }
            }
        }
        for (SkyObject skyObject : this.properties.skyObjects()) {
            SkyHelper.drawCelestialBody(skyObject, tesselator, poseStack, dayAngle);
        }
        this.runFogCallback(fogCallback);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
    }

    private void handleShootingStars(ClientLevel level, PoseStack poseStack, Matrix4f projectionMatrix, Star star, float partialTick) {
        if (!level.isClientSide) {
            return;
        }
        float starLight = level.getStarBrightness(partialTick) * (1.0f - level.getRainLevel(partialTick));
        if (!star.allDaysVisible() && !(starLight > 0.2f)) {
            if (!this.shootingStars.isEmpty()) {
                this.shootingStars.clear();
            }
            return;
        }
        Star.ShootingStars shootingStarConfig = star.shootingStars().get();
        Random random = new Random();
        if (random.nextInt(1001) >= shootingStarConfig.percentage()) {
            UUID starId = UUID.randomUUID();
            ShootingStar shootingStar = new ShootingStar(random.nextInt((int)shootingStarConfig.randomLifetime().x, (int)shootingStarConfig.randomLifetime().y), shootingStarConfig, starId);
            this.shootingStars.putIfAbsent(starId, shootingStar);
        }
        if (this.shootingStars == null || this.shootingStars.isEmpty()) {
            return;
        }
        ArrayList<UUID> starsToRemove = new ArrayList<UUID>();
        for (ShootingStar shootingStar : this.shootingStars.values()) {
            if (!shootingStar.render(poseStack, projectionMatrix)) continue;
            starsToRemove.add(shootingStar.starId);
        }
        starsToRemove.forEach(this.shootingStars::remove);
    }

    private void renderStars(ClientLevel level, float partialTick, PoseStack poseStack, Matrix4f projectionMatrix, Runnable fogCallback, float nightAngle) {
        float starsAngle;
        float starLight = level.getStarBrightness(partialTick) * (1.0f - level.getRainLevel(partialTick));
        if (this.starBuffer == null) {
            return;
        }
        if (this.properties.stars().vanilla()) {
            if (starLight > 0.0f) {
                RenderSystem.setShaderColor((float)starLight, (float)starLight, (float)starLight, (float)starLight);
                FogRenderer.setupNoFog();
                this.starBuffer.bind();
                this.starBuffer.drawWithShader(poseStack.last().pose(), projectionMatrix, GameRenderer.getPositionShader());
                VertexBuffer.unbind();
            }
            return;
        }
        float f = starsAngle = !this.properties.stars().movingStars() ? -90.0f : nightAngle;
        if (this.properties.stars().allDaysVisible()) {
            if (this.properties.stars().starsTexture().isPresent()) {
                RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
            } else {
                RenderSystem.setShader(GameRenderer::getPositionColorShader);
            }
            RenderSystem.setShaderColor((float)(starLight + 1.0f), (float)(starLight + 1.0f), (float)(starLight + 1.0f), (float)(starLight + 1.0f));
            StarHelper.drawStars(this.starBuffer, poseStack, projectionMatrix, starsAngle, this.properties.stars().starsTexture());
        } else if (starLight > 0.2f) {
            if (this.properties.stars().starsTexture().isPresent()) {
                RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
            } else {
                RenderSystem.setShader(GameRenderer::getPositionColorShader);
            }
            RenderSystem.setShaderColor((float)(starLight + 0.5f), (float)(starLight + 0.5f), (float)(starLight + 0.5f), (float)(starLight + 0.5f));
            StarHelper.drawStars(this.starBuffer, poseStack, projectionMatrix, starsAngle, this.properties.stars().starsTexture());
        }
        this.runFogCallback(fogCallback);
    }

    public void runFogCallback(Runnable fogCallback) {
        if (this.properties.fogSettings().isEmpty()) {
            fogCallback.run();
            return;
        }
        this.properties.fogSettings().ifPresent(fogSettings -> {
            if (fogSettings.fog().booleanValue()) {
                fogCallback.run();
            }
        });
    }

    public Boolean shouldRemoveCloud() {
        return SkyHelper.isAModCancelRendering(SkyAesthetics.CONFIG.modDisablingCloudRender) || this.properties.cloudSettings().isPresent() && !this.properties.cloudSettings().get().showCloud();
    }

    public Boolean shouldRemoveSnowAndRain() {
        return SkyHelper.isAModCancelRendering(SkyAesthetics.CONFIG.modDisablingWeather) || this.properties.rain() == false;
    }

    public boolean isSkyRendered() {
        if (this.properties.renderCondition().isEmpty() || !this.properties.renderCondition().get().condition()) {
            return true;
        }
        SkyProperties.RenderCondition condition = this.properties.renderCondition().get();
        ServerLevel level = this.getServerLevel();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || level == null) {
            return false;
        }
        if (condition.biomes().isPresent()) {
            return level.getBiome(player.getOnPos()).is(condition.biomes().get());
        }
        if (condition.biome().isPresent()) {
            return level.getBiome(player.getOnPos()).is(condition.biome().get());
        }
        return true;
    }

    public Vec3 getCloudColor(float rainLevel, float stormLevel) {
        if (this.properties.cloudSettings().isPresent() && this.properties.cloudSettings().get().cloudColor().isPresent()) {
            CloudSettings.CustomCloudColor color = this.properties.cloudSettings().get().cloudColor().get();
            if (stormLevel > 0.0f && !color.alwaysBaseColor()) {
                return new Vec3(color.stormColor().x, color.stormColor().y, color.stormColor().z);
            }
            if (rainLevel > 0.0f && !color.alwaysBaseColor()) {
                return new Vec3(color.rainColor().x, color.rainColor().y, color.rainColor().z);
            }
            return new Vec3(color.baseColor().x, color.baseColor().y, color.baseColor().z);
        }
        return null;
    }

    private ServerLevel getServerLevel() {
        Minecraft minecraft = Minecraft.getInstance();
        IntegratedServer integratedServer = minecraft.getSingleplayerServer();
        return integratedServer != null ? integratedServer.getLevel(minecraft.level.dimension()) : null;
    }
}

