/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.sky_aesthetics.client.skies.record;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Axis;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public record SkyObject(ResourceLocation texture, boolean blend, float size, Vec3 rotation, Optional<Vector3f> objectRotation, int height, String rotationType) {
    public static Codec<Vector3f> VEC3F = Codec.FLOAT.listOf().comapFlatMap(list -> Util.fixedSize((List)list, (int)3).map(listx -> new Vector3f(((Float)listx.getFirst()).floatValue(), ((Float)listx.get(1)).floatValue(), ((Float)listx.getLast()).floatValue())), vector3f -> List.of(Float.valueOf(vector3f.x), Float.valueOf(vector3f.y), Float.valueOf(vector3f.z)));
    public static final Codec<SkyObject> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(SkyObject::texture), (App)Codec.BOOL.fieldOf("blend").forGetter(SkyObject::blend), (App)Codec.FLOAT.fieldOf("size").forGetter(SkyObject::size), (App)Vec3.CODEC.fieldOf("rotation").forGetter(SkyObject::rotation), (App)VEC3F.optionalFieldOf("object_rotation").forGetter(SkyObject::objectRotation), (App)Codec.INT.fieldOf("height").forGetter(SkyObject::height), (App)Codec.STRING.fieldOf("rotation_type").forGetter(SkyObject::rotationType)).apply((Applicative)instance, SkyObject::new));

    public void setObjectPosition(PoseStack poseStack, float dayAngle) {
        poseStack.mulPose(Axis.YP.rotationDegrees((float)this.rotation().y));
        if (Objects.equals(this.rotationType(), "DAY")) {
            poseStack.mulPose(Axis.XP.rotationDegrees(dayAngle));
        } else if (Objects.equals(this.rotationType(), "NIGHT")) {
            poseStack.mulPose(Axis.XP.rotationDegrees(dayAngle + 180.0f));
        } else {
            poseStack.mulPose(Axis.XP.rotationDegrees((float)this.rotation().x));
        }
        poseStack.mulPose(Axis.ZP.rotationDegrees((float)this.rotation().z));
    }

    public void setObjectRotation(PoseStack poseStack) {
        this.objectRotation.ifPresent(rotation -> {
            poseStack.translate(0.0f, 100.0f, 0.0f);
            poseStack.mulPose(Axis.XP.rotationDegrees(rotation.x));
            poseStack.mulPose(Axis.YP.rotationDegrees(rotation.y));
            poseStack.mulPose(Axis.ZP.rotationDegrees(rotation.z));
            poseStack.translate(0.0f, -100.0f, 0.0f);
        });
    }
}

