/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.sky_aesthetics.client.skies;

import fr.tathan.sky_aesthetics.client.skies.record.SkyProperties;
import fr.tathan.sky_aesthetics.client.skies.renderer.SkyRenderer;
import fr.tathan.sky_aesthetics.client.skies.utils.SkyHelper;
import java.lang.runtime.SwitchBootstraps;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DimensionSky
extends DimensionSpecialEffects {
    private final SkyRenderer renderer;
    private final SkyProperties properties;

    public DimensionSky(SkyProperties properties) {
        super(properties.cloudSettings().isPresent() && properties.cloudSettings().get().showCloud() ? (float)properties.cloudSettings().get().cloudHeight().get().intValue() : 192.0f, true, DimensionSpecialEffects.SkyType.valueOf((String)properties.skyType()), false, false);
        this.properties = properties;
        this.renderer = new SkyRenderer(properties);
    }

    @NotNull
    public Vec3 getBrightnessDependentFogColor(Vec3 fogColor, float brightness) {
        return this.getProperties().fogSettings().isPresent() ? fogColor.multiply((double)(brightness * 0.94f + 0.06f), (double)(brightness * 0.94f + 0.06f), (double)(brightness * 0.91f + 0.09f)) : fogColor;
    }

    @Nullable
    public float[] getSunriseColor(float timeOfDay, float partialTicks) {
        this.properties.sunriseColor().ifPresent(sunriseColor -> {
            float g = Mth.cos((float)(timeOfDay * ((float)Math.PI * 2)));
            if (g >= -0.4f && g <= 0.4f) {
                float i = g / 0.4f * 0.5f + 0.5f;
                float alpha = 1.0f - (1.0f - Mth.sin((float)(i * (float)Math.PI))) * 0.99f;
                alpha *= alpha;
                if (this.properties.sunriseModifier().isPresent()) {
                    alpha *= this.properties.sunriseModifier().get().floatValue();
                }
                if (this.sunriseCol == null) {
                    this.sunriseCol = new float[4];
                }
                this.sunriseCol[0] = (float)((int)sunriseColor.x) / 255.0f;
                this.sunriseCol[1] = (float)((int)sunriseColor.y) / 255.0f;
                this.sunriseCol[2] = (float)((int)sunriseColor.z) / 255.0f;
                this.sunriseCol[3] = alpha * 1.5f;
            } else {
                this.sunriseCol = null;
            }
        });
        if (this.sunriseCol == null) {
            return super.getSunriseColor(timeOfDay, partialTicks);
        }
        return this.sunriseCol;
    }

    public boolean hasGround() {
        return SkyHelper.skyTypeToHasGround(this.properties.skyType());
    }

    public DimensionSpecialEffects.SkyType skyType() {
        String string = this.properties.skyType();
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"END", "NONE"}, (Object)string, n)) {
            case 0 -> DimensionSpecialEffects.SkyType.END;
            case 1 -> DimensionSpecialEffects.SkyType.NONE;
            default -> DimensionSpecialEffects.SkyType.NORMAL;
        };
    }

    public boolean isFoggyAt(int x, int y) {
        return false;
    }

    public SkyRenderer getRenderer() {
        return this.renderer;
    }

    public SkyProperties getProperties() {
        return this.properties;
    }
}

