/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.sky_aesthetics.client.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import fr.tathan.SkyAesthetics;
import fr.tathan.sky_aesthetics.client.skies.DimensionSky;
import fr.tathan.sky_aesthetics.client.skies.record.SkyProperties;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.Nullable;

public class SkyPropertiesData
extends SimpleJsonResourceReloadListener {
    public static final Map<ResourceLocation, DimensionSky> SKY_PROPERTIES = new HashMap<ResourceLocation, DimensionSky>();

    public SkyPropertiesData() {
        super(SkyAesthetics.GSON, "sky_aesthetics");
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, @Nullable ResourceManager resourceManager, @Nullable ProfilerFiller profiler) {
        SKY_PROPERTIES.clear();
        object.forEach((key, value) -> {
            JsonObject json = GsonHelper.convertToJsonObject((JsonElement)value, (String)"sky properties");
            DataResult decoder = SkyProperties.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
            if (decoder.error().isPresent()) {
                SkyAesthetics.LOG.error("Error parsing sky : {}", (Object)((DataResult.Error)decoder.error().get()).message());
                return;
            }
            SkyProperties skyProperties = (SkyProperties)decoder.getOrThrow();
            DimensionSky dimensionSky = new DimensionSky(skyProperties);
            if (skyProperties.id().isPresent()) {
                SKY_PROPERTIES.putIfAbsent(skyProperties.id().get(), dimensionSky);
                SkyAesthetics.LOG.info(String.valueOf(skyProperties.id().get()) + " | registered");
            } else {
                SKY_PROPERTIES.putIfAbsent(skyProperties.world().location(), dimensionSky);
                SkyAesthetics.LOG.info(String.valueOf(skyProperties.world().location()) + " | registered");
            }
        });
    }
}

