/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.inworldrecipes.recipes;

import com.benbenlaw.core.recipe.NoInventoryRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.NotNull;

public record RightClickOnBlockTransformsBlockRecipe(SizedIngredient heldItem, Ingredient targetBlock, boolean damageHeldItem, boolean consumeHeldItem, String newBlock) implements Recipe<NoInventoryRecipe>
{
    public boolean matches(NoInventoryRecipe p_346065_, Level p_345375_) {
        return true;
    }

    public ItemStack assemble(NoInventoryRecipe p_345149_, HolderLookup.Provider p_346030_) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int p_43999_, int p_44000_) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider p_336125_) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<RightClickOnBlockTransformsBlockRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public final MapCodec<RightClickOnBlockTransformsBlockRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SizedIngredient.FLAT_CODEC.fieldOf("held_item").forGetter(RightClickOnBlockTransformsBlockRecipe::heldItem), (App)Ingredient.CODEC.fieldOf("target_block").forGetter(RightClickOnBlockTransformsBlockRecipe::targetBlock), (App)Codec.BOOL.fieldOf("damage_held_item").forGetter(RightClickOnBlockTransformsBlockRecipe::damageHeldItem), (App)Codec.BOOL.fieldOf("consume_held_item").forGetter(RightClickOnBlockTransformsBlockRecipe::consumeHeldItem), (App)Codec.STRING.fieldOf("new_block").forGetter(RightClickOnBlockTransformsBlockRecipe::newBlock)).apply((Applicative)instance, RightClickOnBlockTransformsBlockRecipe::new));
        private final StreamCodec<RegistryFriendlyByteBuf, RightClickOnBlockTransformsBlockRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        @NotNull
        public MapCodec<RightClickOnBlockTransformsBlockRecipe> codec() {
            return this.CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, RightClickOnBlockTransformsBlockRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private static RightClickOnBlockTransformsBlockRecipe read(RegistryFriendlyByteBuf buffer) {
            SizedIngredient heldItem = (SizedIngredient)SizedIngredient.STREAM_CODEC.decode((Object)buffer);
            Ingredient targetBlock = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            boolean damageHeldItem = buffer.readBoolean();
            boolean consumeHeldItem = buffer.readBoolean();
            String newBlock = buffer.readUtf();
            return new RightClickOnBlockTransformsBlockRecipe(heldItem, targetBlock, damageHeldItem, consumeHeldItem, newBlock);
        }

        private static void write(RegistryFriendlyByteBuf buffer, RightClickOnBlockTransformsBlockRecipe recipe) {
            SizedIngredient.STREAM_CODEC.encode((Object)buffer, (Object)recipe.heldItem);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.targetBlock);
            buffer.writeBoolean(recipe.damageHeldItem);
            buffer.writeBoolean(recipe.consumeHeldItem);
            buffer.writeUtf(recipe.newBlock);
        }
    }

    public static class Type
    implements RecipeType<RightClickOnBlockTransformsBlockRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

