/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.inworldrecipes.recipes;

import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public sealed interface BlockTarget {
    public boolean matches(BlockState var1, boolean var2);

    public record Tag(TagKey<Block> tag) implements BlockTarget
    {
        @Override
        public boolean matches(BlockState state, boolean ignoreBlockState) {
            return state.is(this.tag);
        }
    }

    public record Single(BlockState blockState) implements BlockTarget
    {
        @Override
        public boolean matches(BlockState state, boolean ignoreBlockState) {
            if (state.getBlock() != this.blockState.getBlock()) {
                return false;
            }
            if (ignoreBlockState) {
                return true;
            }
            BlockState defaultState = this.blockState.getBlock().defaultBlockState();
            for (Property property : this.blockState.getProperties()) {
                Comparable recipeValue = this.blockState.getValue(property);
                Comparable defaultValue = defaultState.getValue(property);
                Comparable levelValue = state.getValue(property);
                if (recipeValue.equals(defaultValue) || recipeValue.equals(levelValue)) continue;
                return false;
            }
            return true;
        }
    }
}

