/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.inworldrecipes.integration.jei;

import com.benbenlaw.inworldrecipes.integration.jei.JEIInWorldRecipesPlugin;
import com.benbenlaw.inworldrecipes.recipes.RightClickOnBlockTransformsBlockRecipe;
import java.awt.Color;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RightClickOnBlockTransformsBlockRecipeCategory
implements IRecipeCategory<RightClickOnBlockTransformsBlockRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"inworldrecipes", (String)"right_click_on_block_transforms_block");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"inworldrecipes", (String)"textures/gui/jei_right_click_on_block.png");
    static final RecipeType<RightClickOnBlockTransformsBlockRecipe> RECIPE_TYPE = RecipeType.create((String)"inworldrecipes", (String)"right_click_on_block_transforms_block", RightClickOnBlockTransformsBlockRecipe.class);
    int yOffset = 21;
    int totalMessages;
    private IDrawable background;
    private final IDrawable icon;
    private final IGuiHelper helper;

    @Nullable
    public ResourceLocation getRegistryName(RightClickOnBlockTransformsBlockRecipe recipe) {
        assert (Minecraft.getInstance().level != null);
        return Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RightClickOnBlockTransformsBlockRecipe.Type.INSTANCE).stream().filter(recipeHolder -> ((RightClickOnBlockTransformsBlockRecipe)recipeHolder.value()).equals(recipe)).map(RecipeHolder::id).findFirst().orElse(null);
    }

    public RightClickOnBlockTransformsBlockRecipeCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(TEXTURE, 0, 0, 139, 18);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Blocks.DIAMOND_BLOCK));
    }

    @NotNull
    public RecipeType<RightClickOnBlockTransformsBlockRecipe> getRecipeType() {
        return JEIInWorldRecipesPlugin.RIGHT_CLICK_ON_BLOCK_TRANSFORM_BLOCK_RECIPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.literal((String)"Right Click On Block");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RightClickOnBlockTransformsBlockRecipe recipe, @NotNull IFocusGroup focusGroup) {
        this.totalMessages = 0;
        builder.addSlot(RecipeIngredientRole.CATALYST, 4, 2).addItemStacks(Arrays.asList(recipe.heldItem().getItems()));
        builder.addSlot(RecipeIngredientRole.INPUT, 40, 2).addIngredients(recipe.targetBlock());
        Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)recipe.newBlock()));
        Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)recipe.newBlock()));
        if (item != Items.AIR) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 120, 2).addItemStack(item.getDefaultInstance());
        } else {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 120, 2).addFluidStack(fluid, 1000L);
        }
        if (recipe.damageHeldItem()) {
            ++this.totalMessages;
        }
        if (recipe.consumeHeldItem()) {
            ++this.totalMessages;
        }
        this.background = this.helper.createDrawable(TEXTURE, 0, 0, 139, 18 + this.totalMessages * 10);
    }

    public void draw(RightClickOnBlockTransformsBlockRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.yOffset = 20;
        if (recipe.damageHeldItem()) {
            guiGraphics.drawString(Minecraft.getInstance().font, "Damages Item", 0, 20, Color.GRAY.getRGB(), false);
            this.yOffset += 10;
        }
        if (recipe.consumeHeldItem()) {
            guiGraphics.drawString(Minecraft.getInstance().font, "Consumes Item", 0, 20, Color.GRAY.getRGB(), false);
            this.yOffset += 10;
        }
    }
}

