/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.placers.data;

import com.benbenlaw.placers.data.PlacersBlockStatesProvider;
import com.benbenlaw.placers.data.PlacersBlockTags;
import com.benbenlaw.placers.data.PlacersItemModelProvider;
import com.benbenlaw.placers.data.PlacersItemTags;
import com.benbenlaw.placers.data.PlacersLangProvider;
import com.benbenlaw.placers.data.PlacersLootTableProvider;
import com.benbenlaw.placers.data.PlacersRecipeProvider;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="placers", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(PlacersLootTableProvider::new, LootContextParamSets.BLOCK)), event.getLookupProvider()));
        PlacersBlockTags blockTags = new PlacersBlockTags(packOutput, lookupProvider, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        PlacersItemTags itemTags = new PlacersItemTags(packOutput, lookupProvider, blockTags, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)itemTags);
        generator.addProvider(event.includeClient(), (DataProvider)new PlacersItemModelProvider(packOutput, event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new PlacersBlockStatesProvider(packOutput, event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new PlacersLangProvider(packOutput, event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new PlacersRecipeProvider(packOutput, lookupProvider));
    }
}

