/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.widget;

import java.util.List;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.clothconfig2.gui.widget.DynamicSmoothScrollingEntryListWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenAxis;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class DynamicElementListWidget<E extends ElementEntry<E>>
extends DynamicSmoothScrollingEntryListWidget<E> {
    private static final Component USAGE_NARRATION = Component.translatable((String)"narration.selection.usage");

    public DynamicElementListWidget(Minecraft client, int width, int height, int top, int bottom, ResourceLocation backgroundLocation) {
        super(client, width, height, top, bottom, backgroundLocation);
    }

    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent focusNavigationEvent) {
        ComponentPath componentPath;
        if (this.getItemCount() == 0) {
            return null;
        }
        if (!(focusNavigationEvent instanceof FocusNavigationEvent.ArrowNavigation)) {
            return super.nextFocusPath(focusNavigationEvent);
        }
        FocusNavigationEvent.ArrowNavigation arrowNavigation = (FocusNavigationEvent.ArrowNavigation)focusNavigationEvent;
        ElementEntry entry = (ElementEntry)this.getFocused();
        if (arrowNavigation.direction().getAxis() == ScreenAxis.HORIZONTAL && entry != null) {
            return ComponentPath.path((ContainerEventHandler)this, (ComponentPath)entry.nextFocusPath(focusNavigationEvent));
        }
        int i = -1;
        ScreenDirection screenDirection = arrowNavigation.direction();
        if (entry != null) {
            i = entry.children().indexOf(entry.getFocused());
        }
        if (i == -1) {
            switch (screenDirection) {
                case LEFT: {
                    i = Integer.MAX_VALUE;
                    screenDirection = ScreenDirection.DOWN;
                    break;
                }
                case RIGHT: {
                    i = 0;
                    screenDirection = ScreenDirection.DOWN;
                    break;
                }
                default: {
                    i = 0;
                }
            }
        }
        ElementEntry entry2 = entry;
        do {
            if ((entry2 = this.nextEntry(screenDirection, entryx -> !entryx.children().isEmpty(), entry2)) != null) continue;
            return null;
        } while ((componentPath = entry2.focusPathAtIndex((FocusNavigationEvent)arrowNavigation, i)) == null);
        return ComponentPath.path((ContainerEventHandler)this, (ComponentPath)componentPath);
    }

    @Override
    public void updateNarration(NarrationElementOutput narrationElementOutput) {
        ElementEntry entry = (ElementEntry)this.hoveredItem;
        if (entry != null) {
            entry.updateNarration(narrationElementOutput.nest());
            this.narrateListElementPosition(narrationElementOutput, entry);
        } else {
            ElementEntry entry2 = (ElementEntry)this.getFocused();
            if (entry2 != null) {
                entry2.updateNarration(narrationElementOutput.nest());
                this.narrateListElementPosition(narrationElementOutput, entry2);
            }
        }
        narrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.component_list.usage"));
    }

    @Override
    public void setFocused(@Nullable GuiEventListener guiEventListener) {
        super.setFocused(guiEventListener);
        if (guiEventListener == null) {
            this.selectItem(null);
        }
    }

    @Override
    public NarratableEntry.NarrationPriority narrationPriority() {
        return this.isFocused() ? NarratableEntry.NarrationPriority.FOCUSED : super.narrationPriority();
    }

    @Override
    protected boolean isSelected(int i) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class ElementEntry<E extends ElementEntry<E>>
    extends DynamicEntryListWidget.Entry<E>
    implements ContainerEventHandler,
    NarratableEntry {
        @Nullable
        private GuiEventListener focused;
        @Nullable
        private NarratableEntry lastNarratable;
        private boolean dragging;

        public boolean isDragging() {
            return this.dragging;
        }

        public void setDragging(boolean bl) {
            this.dragging = bl;
        }

        @Nullable
        public GuiEventListener getFocused() {
            return this.focused;
        }

        public void setFocused(@Nullable GuiEventListener guiEventListener) {
            if (this.focused != null) {
                this.focused.setFocused(false);
            }
            if (guiEventListener != null) {
                guiEventListener.setFocused(true);
            }
            this.focused = guiEventListener;
        }

        @Nullable
        public ComponentPath focusPathAtIndex(FocusNavigationEvent focusNavigationEvent, int i) {
            if (this.children().isEmpty()) {
                return null;
            }
            ComponentPath componentPath = ((GuiEventListener)this.children().get(Math.min(i, this.children().size() - 1))).nextFocusPath(focusNavigationEvent);
            return ComponentPath.path((ContainerEventHandler)this, (ComponentPath)componentPath);
        }

        @Nullable
        public ComponentPath nextFocusPath(FocusNavigationEvent focusNavigationEvent) {
            if (focusNavigationEvent instanceof FocusNavigationEvent.ArrowNavigation) {
                int j;
                int var10000;
                FocusNavigationEvent.ArrowNavigation arrowNavigation = (FocusNavigationEvent.ArrowNavigation)focusNavigationEvent;
                switch (arrowNavigation.direction()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case LEFT: {
                        int n = -1;
                        break;
                    }
                    case RIGHT: {
                        int n = 1;
                        break;
                    }
                    case UP: 
                    case DOWN: {
                        int n = var10000 = 0;
                    }
                }
                if (var10000 == 0) {
                    return null;
                }
                for (int k = j = Mth.clamp((int)(var10000 + this.children().indexOf(this.getFocused())), (int)0, (int)(this.children().size() - 1)); k >= 0 && k < this.children().size(); k += var10000) {
                    GuiEventListener guiEventListener = (GuiEventListener)this.children().get(k);
                    ComponentPath componentPath = guiEventListener.nextFocusPath(focusNavigationEvent);
                    if (componentPath == null) continue;
                    return ComponentPath.path((ContainerEventHandler)this, (ComponentPath)componentPath);
                }
            }
            return super.nextFocusPath(focusNavigationEvent);
        }

        @Override
        public abstract List<? extends NarratableEntry> narratables();

        @Override
        public void updateNarration(NarrationElementOutput narrationElementOutput) {
            List<NarratableEntry> list = this.narratables();
            Screen.NarratableSearchResult narratableSearchResult = Screen.findNarratableWidget(list, (NarratableEntry)this.lastNarratable);
            if (narratableSearchResult != null) {
                if (narratableSearchResult.priority.isTerminal()) {
                    this.lastNarratable = narratableSearchResult.entry;
                }
                if (list.size() > 1) {
                    narrationElementOutput.add(NarratedElementType.POSITION, (Component)Component.translatable((String)"narrator.position.object_list", (Object[])new Object[]{narratableSearchResult.index + 1, list.size()}));
                    if (narratableSearchResult.priority == NarratableEntry.NarrationPriority.FOCUSED) {
                        narrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.component_list.usage"));
                    }
                }
                narratableSearchResult.entry.updateNarration(narrationElementOutput.nest());
            }
        }

        public boolean isActive() {
            return false;
        }

        public NarratableEntry.NarrationPriority narrationPriority() {
            if (this.isFocused()) {
                return NarratableEntry.NarrationPriority.FOCUSED;
            }
            return NarratableEntry.NarrationPriority.NONE;
        }

        public boolean mouseClicked(double d, double e, int i) {
            if (!this.isEnabled()) {
                return false;
            }
            return super.mouseClicked(d, e, i);
        }

        public boolean mouseReleased(double d, double e, int i) {
            if (!this.isEnabled()) {
                return false;
            }
            return super.mouseReleased(d, e, i);
        }

        public boolean mouseDragged(double d, double e, int i, double f, double g) {
            if (!this.isEnabled()) {
                return false;
            }
            return super.mouseDragged(d, e, i, f, g);
        }

        public boolean mouseScrolled(double d, double e, double amountX, double amountY) {
            if (!this.isEnabled()) {
                return false;
            }
            return super.mouseScrolled(d, e, amountX, amountY);
        }

        public boolean keyPressed(int i, int j, int k) {
            if (!this.isEnabled()) {
                return false;
            }
            return super.keyPressed(i, j, k);
        }

        public boolean keyReleased(int i, int j, int k) {
            if (!this.isEnabled()) {
                return false;
            }
            return super.keyReleased(i, j, k);
        }

        public boolean charTyped(char c, int i) {
            if (!this.isEnabled()) {
                return false;
            }
            return super.charTyped(c, i);
        }
    }
}

