/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.nbthandler.data;

import com.hrznstudio.titanium.api.INBTHandler;
import com.hrznstudio.titanium.util.Unboxing;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;

public class FloatNBTHandler
implements INBTHandler<Float> {
    @Override
    public boolean isClassValid(Class<?> aClass) {
        return Float.TYPE.isAssignableFrom(aClass) || Float.class.isAssignableFrom(aClass);
    }

    @Override
    public boolean storeToNBT(HolderLookup.Provider provider, @Nonnull CompoundTag compound, @Nonnull String name, @Nonnull Float object) {
        compound.putFloat(name, object.floatValue());
        return true;
    }

    @Override
    public Float readFromNBT(HolderLookup.Provider provider, @Nonnull CompoundTag compound, @Nonnull String name, @Nullable Float currentValue) {
        return Float.valueOf(compound.contains(name) ? compound.getFloat(name) : Unboxing.safelyUnbox(currentValue));
    }
}

