/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.common.blocks.metal.FluidPipeBlockEntity;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.neoforged.fml.InterModComms;

public class IEIMCHandler {
    private static final HashMap<String, Consumer<InterModComms.IMCMessage>> MESSAGE_HANDLERS = new HashMap();

    public static void init() {
        MESSAGE_HANDLERS.put("fluidpipe_cover", imcMessage -> {
            Predicate func = (Predicate)imcMessage.messageSupplier().get();
            FluidPipeBlockEntity.validPipeCovers.add(func);
        });
        MESSAGE_HANDLERS.put("fluidpipe_cover_climb", imcMessage -> {
            Predicate func = (Predicate)imcMessage.messageSupplier().get();
            FluidPipeBlockEntity.climbablePipeCovers.add(func);
        });
    }

    public static void handleIMCMessages(Stream<InterModComms.IMCMessage> messages) {
        messages.forEach(message -> {
            if (MESSAGE_HANDLERS.containsKey(message.method())) {
                Consumer<InterModComms.IMCMessage> handler = MESSAGE_HANDLERS.get(message.method());
                handler.accept((InterModComms.IMCMessage)message);
            }
        });
    }
}

