/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.api.utils.FastEither;
import blusunrize.immersiveengineering.common.items.VoltmeterItem;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.network.MessageStoredEnergy;
import com.mojang.datafixers.util.Either;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MessageRequestEnergyUpdate(Either<BlockPos, Integer> pos) implements IMessage
{
    public static final CustomPacketPayload.Type<MessageRequestEnergyUpdate> ID = IMessage.createType("request_energy_update");
    public static final StreamCodec<ByteBuf, MessageRequestEnergyUpdate> CODEC = ByteBufCodecs.either((StreamCodec)BlockPos.STREAM_CODEC, (StreamCodec)ByteBufCodecs.INT).map(MessageRequestEnergyUpdate::new, MessageRequestEnergyUpdate::pos);

    @Override
    public void process(IPayloadContext context) {
        context.enqueueWork(() -> {
            Level level = context.player().level();
            IEnergyStorage storage = (IEnergyStorage)this.pos.map(bp -> (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, bp, null), id -> {
                Entity entity = level.getEntity(id.intValue());
                if (entity != null) {
                    return (IEnergyStorage)entity.getCapability(Capabilities.EnergyStorage.ENTITY, null);
                }
                return null;
            });
            VoltmeterItem.RemoteEnergyData data = null;
            if (storage != null && storage.getMaxEnergyStored() > 0) {
                data = new VoltmeterItem.RemoteEnergyData(this.pos, level.getGameTime(), true, storage.getEnergyStored(), storage.getMaxEnergyStored());
            }
            if (data == null) {
                data = new VoltmeterItem.RemoteEnergyData(this.pos, level.getGameTime(), false, 0, 0);
            }
            PacketDistributor.sendToPlayer((ServerPlayer)IMessage.serverPlayer(context), (CustomPacketPayload)new MessageStoredEnergy(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
    }

    public static FastEither<BlockPos, Integer> readPos(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            return FastEither.right(buf.readInt());
        }
        return FastEither.left(buf.readBlockPos());
    }

    public static void writePos(FriendlyByteBuf out, FastEither<BlockPos, Integer> pos) {
        out.writeBoolean(pos.isRight());
        if (pos.isRight()) {
            out.writeInt(pos.rightNonnull().intValue());
        } else {
            out.writeBlockPos(pos.leftNonnull());
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

