/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.client.utils.TextUtils;
import blusunrize.immersiveengineering.common.blocks.BlockCapabilityRegistration;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.MetalBarrelBlockEntity;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.config.IEClientConfig;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import blusunrize.immersiveengineering.common.util.IEBlockCapabilityCaches;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class WoodenBarrelBlockEntity
extends IEBaseBlockEntity
implements IEServerTickableBE,
IEBlockInterfaces.IBlockOverlayText,
IEBlockInterfaces.IConfigurableSides,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IBlockEntityDrop,
IEBlockInterfaces.IComparatorOverride {
    public static final int IGNITION_TEMPERATURE = 573;
    public EnumMap<Direction, IEEnums.IOSideConfig> sideConfig = new EnumMap(ImmutableMap.of((Object)Direction.DOWN, (Object)((Object)IEEnums.IOSideConfig.OUTPUT), (Object)Direction.UP, (Object)((Object)IEEnums.IOSideConfig.INPUT)));
    public FluidTank tank = new FluidTank(12000, this::isFluidValid);
    private final Map<Direction, IEBlockCapabilityCaches.IEBlockCapabilityCache<IFluidHandler>> neighbors = ImmutableMap.of((Object)Direction.UP, IEBlockCapabilityCaches.forNeighbor(Capabilities.FluidHandler.BLOCK, this, () -> Direction.UP), (Object)Direction.DOWN, IEBlockCapabilityCaches.forNeighbor(Capabilities.FluidHandler.BLOCK, this, () -> Direction.DOWN));
    private final Map<Direction, IFluidHandler> sidedFluidHandler = new HashMap<Direction, IFluidHandler>();

    public WoodenBarrelBlockEntity(BlockEntityType<? extends WoodenBarrelBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.sidedFluidHandler.put(Direction.DOWN, new SidedFluidHandler(this, Direction.DOWN));
        this.sidedFluidHandler.put(Direction.UP, new SidedFluidHandler(this, Direction.UP));
        this.sidedFluidHandler.put(null, new SidedFluidHandler(this, null));
    }

    public WoodenBarrelBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends WoodenBarrelBlockEntity>)((BlockEntityType)IEBlockEntities.WOODEN_BARREL.get()), pos, state);
    }

    @Override
    public void tickServer() {
        boolean update = false;
        for (Direction side : this.neighbors.keySet()) {
            int accepted;
            FluidStack drained;
            if (this.tank.getFluidAmount() <= 0 || this.sideConfig.get(side) != IEEnums.IOSideConfig.OUTPUT) continue;
            int out = Math.min(1000, this.tank.getFluidAmount());
            IEBlockCapabilityCaches.IEBlockCapabilityCache<IFluidHandler> capRef = this.neighbors.get(side);
            IFluidHandler handler = capRef.getCapability();
            if (handler == null || (drained = this.tank.drain(accepted = handler.fill(this.tank.getFluid().copyWithAmount(out), IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE)).isEmpty()) continue;
            handler.fill(drained, IFluidHandler.FluidAction.EXECUTE);
            update = true;
        }
        if (update) {
            this.setChanged();
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public Component[] getOverlayText(Player player, HitResult rtr, boolean hammer) {
        if (rtr.getType() == HitResult.Type.MISS) {
            return null;
        }
        if (Utils.isFluidRelatedItemStack(player.getItemInHand(InteractionHand.MAIN_HAND))) {
            return new Component[]{TextUtils.formatFluidStack(this.tank.getFluid())};
        }
        if (!(rtr instanceof BlockHitResult)) {
            return null;
        }
        BlockHitResult brtr = (BlockHitResult)rtr;
        if (hammer && ((Boolean)IEClientConfig.showTextOverlay.get()).booleanValue() && brtr.getDirection().getAxis() == Direction.Axis.Y) {
            IEEnums.IOSideConfig side = this.sideConfig.getOrDefault(brtr.getDirection(), IEEnums.IOSideConfig.NONE);
            IEEnums.IOSideConfig opposite = this.sideConfig.getOrDefault(brtr.getDirection().getOpposite(), IEEnums.IOSideConfig.NONE);
            return TextUtils.sideConfigWithOpposite("desc.immersiveengineering.info.blockSide.connectFluid.", side, opposite);
        }
        return null;
    }

    @Override
    public boolean useNixieFont(Player player, HitResult mop) {
        return false;
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        int[] sideCfgArray = nbt.getIntArray("sideConfig");
        if (sideCfgArray.length < 2) {
            sideCfgArray = new int[]{-1, 0};
        }
        this.sideConfig.clear();
        for (int i = 0; i < sideCfgArray.length; ++i) {
            this.sideConfig.put(Direction.from3DDataValue((int)i), IEEnums.IOSideConfig.VALUES[sideCfgArray[i]]);
        }
        this.readTank(provider, nbt);
    }

    public void readTank(HolderLookup.Provider provider, CompoundTag nbt) {
        this.tank.readFromNBT(provider, nbt.getCompound("tank"));
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        int[] sideCfgArray = new int[]{this.sideConfig.get(Direction.DOWN).ordinal(), this.sideConfig.get(Direction.UP).ordinal()};
        nbt.putIntArray("sideConfig", sideCfgArray);
        this.writeTank(provider, nbt, false);
    }

    public void writeTank(HolderLookup.Provider provider, CompoundTag nbt, boolean toItem) {
        boolean write = this.tank.getFluidAmount() > 0;
        CompoundTag tankTag = this.tank.writeToNBT(provider, new CompoundTag());
        if (!toItem || write) {
            nbt.put("tank", (Tag)tankTag);
        }
    }

    public static void registerCapabilities(BlockCapabilityRegistration.BECapabilityRegistrar<? extends WoodenBarrelBlockEntity> registrar) {
        registrar.register(Capabilities.FluidHandler.BLOCK, (be, side) -> be.sidedFluidHandler.getOrDefault(side, null));
    }

    public boolean isFluidValid(FluidStack fluid) {
        return !fluid.isEmpty() && fluid.getFluid().getFluidType().getTemperature(fluid) < 573 && !fluid.getFluid().is(Tags.Fluids.GASEOUS);
    }

    @Override
    public IEEnums.IOSideConfig getSideConfig(Direction side) {
        return this.sideConfig.getOrDefault(side, IEEnums.IOSideConfig.NONE);
    }

    @Override
    public boolean toggleSide(Direction side, Player p) {
        if (side.getAxis() != Direction.Axis.Y) {
            return false;
        }
        this.sideConfig.compute(side, (s, config) -> IEEnums.IOSideConfig.next(config));
        this.setChanged();
        this.markContainingBlockForUpdate(null);
        this.level.blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), 0, 0);
        return true;
    }

    @Override
    public boolean triggerEvent(int id, int arg) {
        if (id == 0) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    @Override
    public ItemInteractionResult interact(Direction side, Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        ItemInteractionResult ret;
        Optional fOptional = FluidUtil.getFluidContained((ItemStack)heldItem);
        boolean metal = this instanceof MetalBarrelBlockEntity;
        if (!metal && (ret = fOptional.map(f -> {
            if (f.getFluid().is(Tags.Fluids.GASEOUS)) {
                player.displayClientMessage((Component)Component.translatable((String)"chat.immersiveengineering.info.noGasAllowed"), true);
                return ItemInteractionResult.FAIL;
            }
            if (f.getFluid().getFluidType().getTemperature(f) >= 573) {
                player.displayClientMessage((Component)Component.translatable((String)"chat.immersiveengineering.info.tooHot"), true);
                return ItemInteractionResult.FAIL;
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }).orElse(ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION)) != ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION) {
            return ret;
        }
        if (FluidUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.tank)) {
            this.setChanged();
            this.markContainingBlockForUpdate(null);
            return ItemInteractionResult.sidedSuccess((boolean)player.level().isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public void getBlockEntityDrop(LootContext context, Consumer<ItemStack> drop) {
        ItemStack stack = new ItemStack((ItemLike)this.getBlockState().getBlock(), 1);
        if (!this.tank.isEmpty()) {
            stack.set(IEDataComponents.GENERIC_FLUID, (Object)SimpleFluidContent.copyOf((FluidStack)this.tank.getFluid()));
        }
        drop.accept(stack);
    }

    @Override
    public void onBEPlaced(BlockPlaceContext ctx) {
        this.onBEPlaced(ctx.getItemInHand());
    }

    public void onBEPlaced(ItemStack stack) {
        this.tank.setFluid(((SimpleFluidContent)stack.getOrDefault(IEDataComponents.GENERIC_FLUID, (Object)SimpleFluidContent.EMPTY)).copy());
    }

    @Override
    public int getComparatorInputOverride() {
        return (int)(15.0f * ((float)this.tank.getFluidAmount() / (float)this.tank.getCapacity()));
    }

    static class SidedFluidHandler
    implements IFluidHandler {
        WoodenBarrelBlockEntity barrel;
        @Nullable
        Direction facing;

        SidedFluidHandler(WoodenBarrelBlockEntity barrel, @Nullable Direction facing) {
            this.barrel = barrel;
            this.facing = facing;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
            if (resource.isEmpty() || this.facing != null && this.barrel.sideConfig.get(this.facing) != IEEnums.IOSideConfig.INPUT || !this.barrel.isFluidValid(resource)) {
                return 0;
            }
            int i = this.barrel.tank.fill(resource, doFill);
            if (i > 0 && doFill.execute()) {
                this.barrel.setChanged();
                this.barrel.markContainingBlockForUpdate(null);
            }
            return i;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
            if (resource.isEmpty()) {
                return FluidStack.EMPTY;
            }
            return this.drain(resource.getAmount(), doDrain);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
            if (this.facing != null && this.barrel.sideConfig.get(this.facing) != IEEnums.IOSideConfig.OUTPUT) {
                return FluidStack.EMPTY;
            }
            FluidStack f = this.barrel.tank.drain(maxDrain, doDrain);
            if (!f.isEmpty()) {
                this.barrel.setChanged();
                this.barrel.markContainingBlockForUpdate(null);
            }
            return f;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.barrel.tank.getFluidInTank(tank);
        }

        public int getTankCapacity(int tank) {
            return this.barrel.tank.getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return this.barrel.tank.isFluidValid(tank, stack);
        }
    }
}

