/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.orientation.RotationUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class TurntableBlockEntity
extends IEBaseBlockEntity
implements IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IHammerInteraction {
    private Rotation[] rotationMapping = new Rotation[]{Rotation.CLOCKWISE_90, Rotation.CLOCKWISE_90, Rotation.CLOCKWISE_90, Rotation.CLOCKWISE_90};
    private boolean[] redstone = new boolean[]{false, false, false, false};
    private static final int[] rotationDirectionIndexMap = new int[]{0, 2, 1, 3, 1};

    public TurntableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.TURNTABLE.get(), pos, state);
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        byte redstoneByte = nbt.getByte("redstone");
        byte rotationMapValue = nbt.getByte("rotationMapping");
        for (int i = 0; i < this.rotationMapping.length; ++i) {
            this.rotationMapping[i] = this.intToRotation(rotationMapValue >> 2 * i & 3);
            this.redstone[i] = (redstoneByte & 1 << i) != 0;
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        byte rotationMapValue = 0;
        byte redstoneByte = 0;
        for (int i = 0; i < this.rotationMapping.length; ++i) {
            rotationMapValue = (byte)(rotationMapValue + (this.rotationToInt(this.rotationMapping[i]) << 2 * i));
            if (!this.redstone[i]) continue;
            redstoneByte = (byte)(redstoneByte + (1 << i));
        }
        nbt.putByte("redstone", redstoneByte);
        nbt.putByte("rotationMapping", rotationMapValue);
    }

    @Override
    public void onNeighborBlockChange(BlockPos otherPos) {
        int directionIndex;
        boolean r;
        super.onNeighborBlockChange(otherPos);
        Direction facing = this.getFacing();
        BlockPos difference = otherPos.subtract((Vec3i)this.worldPosition);
        Direction otherDir = Direction.getNearest((float)difference.getX(), (float)difference.getY(), (float)difference.getZ());
        if (otherDir.getAxis() != facing.getAxis() && (r = this.level.hasSignal(this.worldPosition.relative(otherDir), otherDir)) != this.redstone[directionIndex = this.getRotationDirectionIndexFromFacing(otherDir, facing)]) {
            this.redstone[directionIndex] = r;
            if (this.redstone[directionIndex]) {
                BlockPos target = this.worldPosition.relative(facing);
                RotationUtil.rotateBlock(this.level, target, this.rotationMapping[directionIndex]);
            }
        }
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.PISTON_LIKE;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return placer.isShiftKeyDown();
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return !entity.isShiftKeyDown();
    }

    @Override
    public boolean hammerUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        Direction facing = this.getFacing();
        if (player.isShiftKeyDown() && side.getAxis() != facing.getAxis()) {
            if (!this.level.isClientSide) {
                int directionIndex = this.getRotationDirectionIndexFromFacing(side, facing);
                this.rotationMapping[directionIndex] = this.intToRotation(this.rotationToInt(this.rotationMapping[directionIndex]) % 3 + 1);
                this.setChanged();
                this.level.blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), 254, 0);
            }
            return true;
        }
        return false;
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_ALL;
    }

    private Rotation intToRotation(int rotationValue) {
        switch (rotationValue) {
            case 2: {
                return Rotation.CLOCKWISE_180;
            }
            case 3: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.CLOCKWISE_90;
    }

    private int rotationToInt(Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return 2;
            }
            case COUNTERCLOCKWISE_90: {
                return 3;
            }
        }
        return 1;
    }

    private int getRotationDirectionIndexFromFacing(Direction indexee, Direction facing) {
        int index = indexee.get3DDataValue();
        if (facing.get3DDataValue() < index) {
            index -= 2;
        }
        if (index >= 2 && facing.getAxisDirection() == Direction.AxisDirection.POSITIVE != (facing.getAxis() == Direction.Axis.Z)) {
            ++index;
        }
        return rotationDirectionIndexMap[index];
    }

    public Rotation getRotationFromSide(Direction side) {
        Direction facing = this.getFacing();
        if (side.getAxis() == facing.getAxis()) {
            return Rotation.NONE;
        }
        return this.rotationMapping[this.getRotationDirectionIndexFromFacing(side, facing)];
    }

    public void rotateRotationMap(Rotation rotation) {
        if (rotation == Rotation.NONE) {
            return;
        }
        int offset = this.rotationToInt(rotation);
        for (int i = 0; i < this.rotationMapping.length; ++i) {
            this.rotationMapping[i] = this.rotationMapping[Math.floorMod(i - offset, this.rotationMapping.length)];
        }
    }

    public void verticalTransitionRotationMap(Direction facingOld, Direction facingNew) {
        Direction horizontalFacing;
        boolean toVert = false;
        if (facingNew.getAxis() == Direction.Axis.Y) {
            toVert = true;
        }
        if (facingOld.getAxis() == Direction.Axis.Y == toVert) {
            return;
        }
        Direction direction = horizontalFacing = toVert ? facingOld : facingNew;
        int offset = horizontalFacing.getAxis() == Direction.Axis.Z ? (facingNew.getAxisDirection() == facingOld.getAxisDirection() ? 2 : 0) : (horizontalFacing.getAxisDirection() == Direction.AxisDirection.POSITIVE == toVert ? 3 : 1);
        Rotation[] oldRotMap = (Rotation[])this.rotationMapping.clone();
        boolean[] oldRedstone = (boolean[])this.redstone.clone();
        for (int i = 0; i < this.rotationMapping.length; ++i) {
            int sourceIndex = Math.floorMod(i + offset, this.rotationMapping.length);
            this.rotationMapping[i] = oldRotMap[sourceIndex];
            this.redstone[i] = oldRedstone[sourceIndex];
        }
    }
}

