/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.plant;

import blusunrize.immersiveengineering.common.register.IEItems;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;

public class HempBlock
extends CropBlock
implements BonemealableBlock {
    public static final Supplier<BlockBehaviour.Properties> PROPERTIES = () -> BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).sound(SoundType.CROP).noCollission().instabreak().randomTicks();
    public static final IntegerProperty AGE = BlockStateProperties.AGE_4;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    private static final VoxelShape[] shapesByAge = new VoxelShape[]{Shapes.create((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0)), Shapes.create((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0)), Shapes.create((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0)), Shapes.block(), Shapes.block()};

    public HempBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE}).add(new Property[]{HALF});
    }

    protected IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 4;
    }

    protected ItemLike getBaseSeedId() {
        return IEItems.Misc.HEMP_SEEDS.asItem();
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        boolean b = super.canSurvive(state, world, pos);
        if (state.getBlock().equals((Object)this) && state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            BlockState stateBelow = world.getBlockState(pos.below());
            b = stateBelow.getBlock().equals((Object)this) && this.getAge(stateBelow) == this.getMaxAge();
        }
        return b;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            return Shapes.block();
        }
        return shapesByAge[this.getAge(state)];
    }

    private boolean canGrowTop(LevelReader world, BlockPos pos, BlockState state) {
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            return false;
        }
        if (!world.isEmptyBlock(pos.above())) {
            return false;
        }
        return !world.getBlockState(pos.above()).getBlock().equals((Object)this);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return state.getValue(HALF) == DoubleBlockHalf.LOWER;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        if (!world.isAreaLoaded(pos, 1)) {
            return;
        }
        if (world.getRawBrightness(pos, 0) >= 9) {
            float f;
            int i = this.getAge(state);
            boolean notMaxAge = i < this.getMaxAge();
            boolean canGrowTop = this.canGrowTop((LevelReader)world, pos, state);
            if ((notMaxAge || canGrowTop) && CommonHooks.canCropGrow((Level)world, (BlockPos)pos, (BlockState)state, (rand.nextInt((int)(25.0f / (f = HempBlock.getGrowthSpeed((BlockState)state, (BlockGetter)world, (BlockPos)pos))) + 1) == 0 ? 1 : 0) != 0)) {
                if (notMaxAge) {
                    world.setBlock(pos, this.getStateForAge(i + 1), 2);
                    CommonHooks.fireCropGrowPost((Level)world, (BlockPos)pos, (BlockState)state);
                } else if (canGrowTop) {
                    BlockPos above = pos.above();
                    BlockState aboveState = (BlockState)this.getStateForAge(this.getMaxAge()).setValue(HALF, (Comparable)DoubleBlockHalf.UPPER);
                    world.setBlockAndUpdate(above, aboveState);
                    CommonHooks.fireCropGrowPost((Level)world, (BlockPos)above, (BlockState)aboveState);
                }
            }
        }
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return !this.isMaxAge(state) && state.getValue(HALF) == DoubleBlockHalf.LOWER || this.canGrowTop(world, pos, state);
    }

    public void growCrops(Level world, BlockPos pos, BlockState state) {
        int newAge = this.getAge(state) + this.getBonemealAgeIncrease(world);
        boolean growTop = false;
        if (newAge > this.getMaxAge()) {
            newAge = this.getMaxAge();
            growTop = this.canGrowTop((LevelReader)world, pos, state);
        }
        world.setBlock(pos, this.getStateForAge(newAge), 2);
        if (growTop) {
            world.setBlockAndUpdate(pos.above(), (BlockState)this.getStateForAge(this.getMaxAge()).setValue(HALF, (Comparable)DoubleBlockHalf.UPPER));
        }
    }
}

